/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.synccontext.named;

import java.util.Collection;
import java.util.TreeSet;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.metadata.Metadata;

@Singleton
@Named(value="gav")
public class GAVNameMapper
implements NameMapper {
    public static final String NAME = "gav";

    @Override
    public Collection<String> nameLocks(RepositorySystemSession session, Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        CharSequence key;
        TreeSet<String> keys = new TreeSet<String>();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                key = "artifact:" + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getBaseVersion();
                keys.add((String)key);
            }
        }
        if (metadatas != null) {
            for (Metadata metadata : metadatas) {
                key = new StringBuilder("metadata:");
                if (!metadata.getGroupId().isEmpty()) {
                    ((StringBuilder)key).append(metadata.getGroupId());
                    if (!metadata.getArtifactId().isEmpty()) {
                        ((StringBuilder)key).append(':').append(metadata.getArtifactId());
                        if (!metadata.getVersion().isEmpty()) {
                            ((StringBuilder)key).append(':').append(metadata.getVersion());
                        }
                    }
                }
                keys.add(((StringBuilder)key).toString());
            }
        }
        return keys;
    }
}

