/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.processors;

import org.drools.compiler.builder.impl.AssetFilter;
import org.drools.compiler.builder.impl.processors.CompilationPhase;
import org.drools.compiler.builder.impl.processors.ImmutableFunctionCompiler;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.drl.ast.descr.FunctionDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.kie.internal.builder.ResourceChange;

public class FunctionCompiler
extends ImmutableFunctionCompiler {
    private final AssetFilter assetFilter;

    public static CompilationPhase of(PackageRegistry pkgRegistry, PackageDescr packageDescr, AssetFilter assetFilter, ClassLoader rootClassLoader) {
        if (assetFilter == null) {
            return new ImmutableFunctionCompiler(pkgRegistry, packageDescr, rootClassLoader);
        }
        return new FunctionCompiler(pkgRegistry, packageDescr, assetFilter, rootClassLoader);
    }

    private FunctionCompiler(PackageRegistry pkgRegistry, PackageDescr packageDescr, AssetFilter assetFilter, ClassLoader rootClassLoader) {
        super(pkgRegistry, packageDescr, rootClassLoader);
        this.assetFilter = assetFilter;
    }

    @Override
    protected void postCompileAddFunction(FunctionDescr functionDescr) {
        if (this.filterAccepts(functionDescr)) {
            super.postCompileAddFunction(functionDescr);
        }
    }

    @Override
    protected void addFunction(FunctionDescr functionDescr) {
        if (this.filterAccepts(functionDescr)) {
            super.addFunction(functionDescr);
        }
    }

    private boolean filterAccepts(FunctionDescr functionDescr) {
        return this.assetFilter == null || !AssetFilter.Action.DO_NOTHING.equals((Object)this.assetFilter.accept(ResourceChange.Type.FUNCTION, functionDescr.getNamespace(), functionDescr.getName()));
    }
}

