/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.fluent;

import java.util.HashMap;
import java.util.Map;

public class Variable<T> {
    private String name;
    private T value;
    private Class<T> type;
    private Map<String, Object> metadata;

    private Variable(String name, Class<T> type) {
        this.name = name;
        this.type = type;
    }

    public static <T> Variable<T> var(String name, Class<T> type) {
        return new Variable<T>(name, type);
    }

    public Variable<T> value(T value) {
        this.value = value;
        return this;
    }

    public Variable<T> metadata(String key, Object value) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Object>();
        }
        this.metadata.put(key, value);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public T getValue() {
        return this.value;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "Variable [name=" + this.name + ", value=" + this.value + ", type=" + this.type + ", metadata=" + this.metadata + "]";
    }
}

