/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import org.drools.core.reteoo.TupleMemory;
import org.drools.core.util.index.FastUtilHashTupleMemory;
import org.drools.core.util.index.FastUtilTreeMemory;
import org.drools.core.util.index.IndexSpec;
import org.drools.core.util.index.TupleIndexHashTable;
import org.drools.core.util.index.TupleIndexRBTree;

public class IndexMemory {
    private static final String INTERNAL_INDEX = "internal";
    private static final String FASTUTIL_INDEX = "fastutil";
    private static final String DEFAULT_INDEX = "internal";
    private static EqualityMemoryType EQUALITY_MEMORY_TYPE = EqualityMemoryType.get(System.getProperty("org.drools.equalitymemory", "internal"));
    private static ComparisonMemoryType COMPARISON_MEMORY_TYPE = ComparisonMemoryType.get(System.getProperty("org.drools.comparisonmemory", "internal"));

    public static EqualityMemoryType getEqualityMemoryType() {
        return EQUALITY_MEMORY_TYPE;
    }

    public static void setEqualityMemoryType(EqualityMemoryType type) {
        EQUALITY_MEMORY_TYPE = type;
        EqualityMemoryFactoryHolder.reinit();
    }

    public static ComparisonMemoryType getComparisonMemoryType() {
        return COMPARISON_MEMORY_TYPE;
    }

    public static void setComparisonMemoryType(ComparisonMemoryType type) {
        COMPARISON_MEMORY_TYPE = type;
        ComparisonMemoryFactoryHolder.reinit();
    }

    public static TupleMemory createEqualityMemory(IndexSpec indexSpec, boolean isLeft) {
        return EqualityMemoryFactoryHolder.INSTANCE.createMemory(indexSpec, isLeft);
    }

    public static TupleMemory createComparisonMemory(IndexSpec indexSpec, boolean isLeft) {
        return ComparisonMemoryFactoryHolder.INSTANCE.createMemory(indexSpec, isLeft);
    }

    static class FastUtilComparisonMemoryFactory
    implements Factory {
        FastUtilComparisonMemoryFactory() {
        }

        @Override
        public TupleMemory createMemory(IndexSpec indexSpec, boolean isLeft) {
            return new FastUtilTreeMemory(indexSpec.getConstraintType(), indexSpec.getIndex(0), isLeft);
        }
    }

    static class InternalComparisonMemoryFactory
    implements Factory {
        InternalComparisonMemoryFactory() {
        }

        @Override
        public TupleMemory createMemory(IndexSpec indexSpec, boolean isLeft) {
            return new TupleIndexRBTree(indexSpec.getConstraintType(), indexSpec.getIndex(0), isLeft);
        }
    }

    static class FastUtilEqualityMemoryFactory
    implements Factory {
        FastUtilEqualityMemoryFactory() {
        }

        @Override
        public TupleMemory createMemory(IndexSpec indexSpec, boolean isLeft) {
            return new FastUtilHashTupleMemory(indexSpec.getIndexes(), isLeft);
        }
    }

    static class InternalEqualityMemoryFactory
    implements Factory {
        InternalEqualityMemoryFactory() {
        }

        @Override
        public TupleMemory createMemory(IndexSpec indexSpec, boolean isLeft) {
            return new TupleIndexHashTable(indexSpec.getIndexes(), isLeft);
        }
    }

    static class ComparisonMemoryFactoryHolder {
        private static Factory INSTANCE = COMPARISON_MEMORY_TYPE.createFactory();

        ComparisonMemoryFactoryHolder() {
        }

        private static void reinit() {
            INSTANCE = COMPARISON_MEMORY_TYPE.createFactory();
        }
    }

    static class EqualityMemoryFactoryHolder {
        private static Factory INSTANCE = EQUALITY_MEMORY_TYPE.createFactory();

        EqualityMemoryFactoryHolder() {
        }

        private static void reinit() {
            INSTANCE = EQUALITY_MEMORY_TYPE.createFactory();
        }
    }

    static interface Factory {
        public TupleMemory createMemory(IndexSpec var1, boolean var2);
    }

    public static enum ComparisonMemoryType {
        INTERNAL,
        FASTUTIL;


        static ComparisonMemoryType get(String s) {
            if (s.equalsIgnoreCase(IndexMemory.FASTUTIL_INDEX)) {
                return FASTUTIL;
            }
            return INTERNAL;
        }

        Factory createFactory() {
            if (this == FASTUTIL) {
                return new FastUtilComparisonMemoryFactory();
            }
            return new InternalComparisonMemoryFactory();
        }
    }

    public static enum EqualityMemoryType {
        INTERNAL,
        FASTUTIL;


        static EqualityMemoryType get(String s) {
            if (s.equalsIgnoreCase(IndexMemory.FASTUTIL_INDEX)) {
                return FASTUTIL;
            }
            return INTERNAL;
        }

        Factory createFactory() {
            if (this == FASTUTIL) {
                return new FastUtilEqualityMemoryFactory();
            }
            return new InternalEqualityMemoryFactory();
        }
    }
}

