/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence;

import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import org.drools.commands.ChainableRunner;
import org.drools.commands.EntryPointCreator;
import org.drools.commands.SingleSessionCommandService;
import org.drools.commands.fluent.InternalExecutable;
import org.drools.commands.fluent.PseudoClockRunner;
import org.drools.commands.impl.AbstractInterceptor;
import org.drools.commands.impl.CommandBasedEntryPoint;
import org.drools.core.SessionConfiguration;
import org.drools.core.common.EndOperationListener;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.runtime.process.InternalProcessRuntime;
import org.drools.core.time.impl.CommandServiceTimerJobFactoryManager;
import org.drools.core.time.impl.TimerJobFactoryManager;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.persistence.SessionMarshallingHelper;
import org.drools.persistence.TriggerUpdateTransactionSynchronization;
import org.drools.persistence.api.OrderedTransactionSynchronization;
import org.drools.persistence.api.PersistenceContext;
import org.drools.persistence.api.PersistenceContextManager;
import org.drools.persistence.api.PersistentSession;
import org.drools.persistence.api.SessionNotFoundException;
import org.drools.persistence.api.TransactionAware;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerFactory;
import org.drools.persistence.api.TransactionManagerHelper;
import org.drools.persistence.api.TransactionSynchronization;
import org.drools.persistence.api.Transformable;
import org.drools.persistence.info.SessionInfo;
import org.drools.persistence.jpa.JpaPersistenceContextManager;
import org.drools.persistence.jpa.processinstance.JPAWorkItemManager;
import org.drools.serialization.protobuf.marshalling.KieSessionInitializer;
import org.drools.serialization.protobuf.marshalling.MarshallingConfigurationImpl;
import org.kie.api.KieBase;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Executable;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.RequestContext;
import org.kie.api.runtime.rule.EntryPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistableRunner
implements SingleSessionCommandService {
    private static Logger logger = LoggerFactory.getLogger(PersistableRunner.class);
    private SessionInfo sessionInfo;
    private SessionMarshallingHelper marshallingHelper;
    private KieSession ksession;
    private Environment env;
    private ChainableRunner runner;
    private TransactionManager txm;
    private PersistenceContextManager jpm;
    private volatile boolean doRollback;
    private LinkedList<ChainableRunner> interceptors = new LinkedList();
    private static String SPRING_TM_CLASSNAME = "org.springframework.transaction.support.AbstractPlatformTransactionManager";
    private static ThreadLocal<String> txParent = new ThreadLocal();

    public void checkEnvironment(Environment env) {
        if (env.get("org.kie.api.persistence.jpa.EntityManagerFactory") == null && env.get("org.kie.api.persistence.PersistenceContextManager") == null) {
            throw new IllegalArgumentException("Environment must have an EntityManagerFactory or a PersistenceContextManager instance");
        }
    }

    public PersistableRunner(KieBase kbase, KieSessionConfiguration conf, Environment env) {
        if (conf == null) {
            conf = new SessionConfiguration();
        }
        this.env = env;
        this.checkEnvironment(this.env);
        this.initTransactionManager(this.env);
        this.initNewKnowledgeSession(kbase, conf);
        PersistenceContext persistenceContext = this.jpm.getApplicationScopedPersistenceContext();
        boolean transactionOwner = false;
        try {
            transactionOwner = this.txm.begin();
            this.registerRollbackSync();
            persistenceContext.joinTransaction();
            this.sessionInfo = (SessionInfo)persistenceContext.persist((PersistentSession)this.sessionInfo);
            this.registerUpdateSync();
            this.txm.commit(transactionOwner);
        }
        catch (RuntimeException re) {
            this.rollbackTransaction(re, transactionOwner);
            throw re;
        }
        catch (Exception t1) {
            this.rollbackTransaction(t1, transactionOwner);
            throw new RuntimeException("Wrapped exception see cause", t1);
        }
        ((InternalKnowledgeRuntime)this.ksession).setIdentifier(this.sessionInfo.getId().longValue());
    }

    protected void initNewKnowledgeSession(KieBase kbase, KieSessionConfiguration conf) {
        this.sessionInfo = new SessionInfo();
        this.ksession = kbase.newKieSession(conf, this.env);
        this.initKieSessionMBeans(this.ksession);
        this.marshallingHelper = new SessionMarshallingHelper(this.ksession, conf);
        MarshallingConfigurationImpl config = (MarshallingConfigurationImpl)this.marshallingHelper.getMarshaller().getMarshallingConfiguration();
        config.setMarshallProcessInstances(false);
        config.setMarshallWorkItems(false);
        this.sessionInfo.setJPASessionMashallingHelper(this.marshallingHelper);
        ((InternalKnowledgeRuntime)this.ksession).setEndOperationListener((EndOperationListener)new EndOperationListenerImpl(this.txm, this.sessionInfo));
        this.runner = new TransactionInterceptor();
        TimerJobFactoryManager timerJobFactoryManager = ((InternalKnowledgeRuntime)this.ksession).getTimerService().getTimerJobFactoryManager();
        if (timerJobFactoryManager instanceof CommandServiceTimerJobFactoryManager) {
            ((CommandServiceTimerJobFactoryManager)timerJobFactoryManager).setRunner((ExecutableRunner)this);
        }
    }

    private void initKieSessionMBeans(KieSession ksession) {
        InternalKnowledgeBase internalKnowledgeBase = (InternalKnowledgeBase)ksession.getKieBase();
        StatefulKnowledgeSessionImpl statefulKnowledgeSessionImpl = (StatefulKnowledgeSessionImpl)ksession;
        statefulKnowledgeSessionImpl.initMBeans(internalKnowledgeBase.getContainerId(), internalKnowledgeBase.getId(), "persistent");
    }

    public PersistableRunner(Long sessionId, KieBase kbase, KieSessionConfiguration conf, Environment env) {
        if (conf == null) {
            conf = new SessionConfiguration();
        }
        this.env = env;
        this.checkEnvironment(this.env);
        this.initTransactionManager(this.env);
        PersistenceContext persistenceContext = this.jpm.getApplicationScopedPersistenceContext();
        boolean transactionOwner = false;
        try {
            transactionOwner = this.txm.begin();
            this.registerRollbackSync();
            persistenceContext.joinTransaction();
            this.initExistingKnowledgeSession(sessionId, kbase, conf, persistenceContext);
            this.registerUpdateSync();
            this.txm.commit(transactionOwner);
        }
        catch (SessionNotFoundException e) {
            if (transactionOwner) {
                this.rollbackTransaction((Exception)((Object)e), transactionOwner, false);
            }
            throw e;
        }
        catch (RuntimeException re) {
            this.rollbackTransaction(re, transactionOwner);
            throw re;
        }
        catch (Exception t1) {
            this.rollbackTransaction(t1, transactionOwner);
            throw new RuntimeException("Wrapped exception see cause", t1);
        }
    }

    protected void initExistingKnowledgeSession(Long sessionId, KieBase kbase, KieSessionConfiguration conf, PersistenceContext persistenceContext) {
        if (!this.doRollback && this.ksession != null) {
            return;
        }
        this.doRollback = false;
        try {
            this.sessionInfo = (SessionInfo)persistenceContext.findSession(sessionId);
        }
        catch (Exception e) {
            throw new SessionNotFoundException("Could not find session data for id " + sessionId, e);
        }
        if (this.sessionInfo == null) {
            throw new SessionNotFoundException("Could not find session data for id " + sessionId);
        }
        if (this.marshallingHelper == null) {
            this.marshallingHelper = new SessionMarshallingHelper(kbase, conf, this.env);
            MarshallingConfigurationImpl config = (MarshallingConfigurationImpl)this.marshallingHelper.getMarshaller().getMarshallingConfiguration();
            config.setMarshallProcessInstances(false);
            config.setMarshallWorkItems(false);
        }
        this.sessionInfo.setJPASessionMashallingHelper(this.marshallingHelper);
        this.ksession = this.marshallingHelper.loadSnapshot(this.sessionInfo.getData(), this.ksession, new JpaSessionInitializer(this));
        InternalKnowledgeRuntime kruntime = (InternalKnowledgeRuntime)this.ksession;
        kruntime.setIdentifier(this.sessionInfo.getId().longValue());
        kruntime.setEndOperationListener((EndOperationListener)new EndOperationListenerImpl(this.txm, this.sessionInfo));
        this.runner = new TransactionInterceptor();
        Iterator<ChainableRunner> iterator = this.interceptors.descendingIterator();
        while (iterator.hasNext()) {
            this.addInterceptor(iterator.next(), false);
        }
        this.initKieSessionMBeans(this.ksession);
    }

    public void initTransactionManager(Environment env) {
        Object tm = env.get("org.kie.transaction.TransactionManager");
        if (env.get("org.kie.api.persistence.PersistenceContextManager") != null && env.get("org.kie.transaction.TransactionManager") != null) {
            this.txm = (TransactionManager)tm;
            this.jpm = (PersistenceContextManager)env.get("org.kie.api.persistence.PersistenceContextManager");
        } else {
            if (tm != null && PersistableRunner.isSpringTransactionManager(tm.getClass())) {
                try {
                    logger.debug("Instantiating KieSpringTransactionManager");
                    Class<?> cls = Class.forName("org.kie.spring.persistence.KieSpringTransactionManager");
                    Constructor<?> con = cls.getConstructors()[0];
                    this.txm = (TransactionManager)con.newInstance(tm);
                    env.set("org.kie.transaction.TransactionManager", (Object)this.txm);
                    cls = Class.forName("org.kie.spring.persistence.KieSpringJpaManager");
                    con = cls.getConstructors()[0];
                    this.jpm = (PersistenceContextManager)con.newInstance(this.env);
                }
                catch (Exception e) {
                    logger.warn("Could not instantiate KieSpringTransactionManager. Trying with DroolsSpringTransactionManager.");
                    try {
                        logger.debug("Instantiating DroolsSpringTransactionManager");
                        Class<?> cls = Class.forName("org.drools.container.spring.beans.persistence.DroolsSpringTransactionManager");
                        Constructor<?> con = cls.getConstructors()[0];
                        this.txm = (TransactionManager)con.newInstance(tm);
                        env.set("org.kie.transaction.TransactionManager", (Object)this.txm);
                        cls = Class.forName("org.drools.container.spring.beans.persistence.DroolsSpringJpaManager");
                        con = cls.getConstructors()[0];
                        this.jpm = (PersistenceContextManager)con.newInstance(this.env);
                    }
                    catch (Exception ex) {
                        logger.warn("Could not instantiate DroolsSpringTransactionManager");
                        throw new RuntimeException("Could not instantiate org.kie.container.spring.beans.persistence.DroolsSpringTransactionManager", ex);
                    }
                }
            } else {
                logger.debug("Instantiating JtaTransactionManager");
                this.txm = TransactionManagerFactory.get().newTransactionManager(env);
                env.set("org.kie.transaction.TransactionManager", (Object)this.txm);
                try {
                    Class<?> jpaPersistenceCtxMngrClass = Class.forName("org.jbpm.persistence.JpaProcessPersistenceContextManager");
                    Constructor<?> jpaPersistenceCtxMngrCtor = jpaPersistenceCtxMngrClass.getConstructors()[0];
                    this.jpm = (PersistenceContextManager)jpaPersistenceCtxMngrCtor.newInstance(this.env);
                }
                catch (ClassNotFoundException e) {
                    this.jpm = new JpaPersistenceContextManager(this.env);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error creating JpaProcessPersistenceContextManager", e);
                }
            }
            env.set("org.kie.api.persistence.PersistenceContextManager", (Object)this.jpm);
            env.set("org.kie.transaction.TransactionManager", (Object)this.txm);
        }
    }

    public static boolean isSpringTransactionManager(Class<?> clazz) {
        if (SPRING_TM_CLASSNAME.equals(clazz.getName())) {
            return true;
        }
        return clazz.getSuperclass() != null && PersistableRunner.isSpringTransactionManager(clazz.getSuperclass());
    }

    public RequestContext createContext() {
        RequestContext context = RequestContext.create((ClassLoader)this.ksession.getClass().getClassLoader()).with(this.ksession);
        context.set(EntryPointCreator.class.getName(), (Object)new CommandBasedEntryPointCreator((ExecutableRunner)this.runner));
        return context;
    }

    public ChainableRunner getChainableRunner() {
        return this.runner;
    }

    public synchronized RequestContext execute(Executable executable, RequestContext ctx) {
        this.runner.execute(executable, (Context)ctx);
        return ctx;
    }

    private void rollbackTransaction(Exception t1, boolean transactionOwner) {
        this.rollbackTransaction(t1, transactionOwner, true);
    }

    private void rollbackTransaction(Exception cause, boolean transactionOwner, boolean logstack) {
        try {
            if (logstack) {
                logger.warn("Could not commit session", (Throwable)cause);
            } else {
                logger.warn("Could not commit session due to {}", (Object)cause.getMessage());
            }
            this.txm.rollback(transactionOwner);
        }
        catch (Exception rollbackError) {
            String errorMessage = "Could not rollback due to '" + rollbackError.getMessage() + "' rollback caused by " + cause.getMessage();
            logger.error("Could not rollback", (Throwable)rollbackError);
            throw new RuntimeException(errorMessage, cause);
        }
    }

    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
        this.interceptors.clear();
    }

    public void destroy() {
        PersistenceContext persistenceContext = this.jpm.getApplicationScopedPersistenceContext();
        boolean transactionOwner = false;
        try {
            transactionOwner = this.txm.begin();
            persistenceContext.joinTransaction();
            this.initExistingKnowledgeSession(this.sessionInfo.getId(), this.marshallingHelper.getKbase(), this.marshallingHelper.getConf(), persistenceContext);
            persistenceContext.remove((PersistentSession)this.sessionInfo);
            this.txm.commit(transactionOwner);
        }
        catch (RuntimeException re) {
            this.rollbackTransaction(re, transactionOwner);
            throw re;
        }
        catch (Exception t1) {
            this.rollbackTransaction(t1, transactionOwner);
            throw new RuntimeException("Wrapped exception see cause", t1);
        }
    }

    public Long getSessionId() {
        return this.sessionInfo.getId();
    }

    private void registerRollbackSync() {
        if (this.txm != null) {
            ObjectMarshallingStrategy[] strategies;
            for (ObjectMarshallingStrategy strategy : strategies = (ObjectMarshallingStrategy[])this.env.get("org.kie.api.marshalling.ObjectMarshallingStrategies")) {
                if (!(strategy instanceof TransactionAware)) continue;
                ((TransactionAware)strategy).onStart(this.txm);
            }
        }
        TransactionManagerHelper.registerTransactionSyncInContainer((TransactionManager)this.txm, (OrderedTransactionSynchronization)new SynchronizationImpl(this));
    }

    public KieSession getKieSession() {
        return this.ksession;
    }

    public void addInterceptor(ChainableRunner interceptor) {
        this.addInterceptor(interceptor, true);
    }

    protected void addInterceptor(ChainableRunner interceptor, boolean store) {
        interceptor.setNext((ExecutableRunner)this.runner);
        this.runner = interceptor;
        if (store) {
            this.interceptors.push(interceptor);
        }
    }

    private void rollback() {
        this.doRollback = true;
    }

    private void registerUpdateSync() {
        if (this.txm.getResource((Object)("TriggerUpdateTransactionSynchronization-" + this.toString())) == null) {
            this.txm.registerTransactionSynchronization((TransactionSynchronization)new TriggerUpdateTransactionSynchronization(this.txm, this.env));
            this.txm.putResource((Object)("TriggerUpdateTransactionSynchronization-" + this.toString()), (Object)true);
        }
    }

    private class TransactionInterceptor
    extends AbstractInterceptor {
        public TransactionInterceptor() {
            this.setNext((ExecutableRunner)new PseudoClockRunner());
        }

        public RequestContext execute(Executable executable, RequestContext context) {
            boolean isParentRunner;
            if (!((InternalExecutable)executable).canRunInTransaction()) {
                this.executeNext(executable, (Context)context);
                if (((InternalExecutable)executable).requiresDispose()) {
                    PersistableRunner.this.jpm.dispose();
                }
                return context;
            }
            PersistenceContext persistenceContext = PersistableRunner.this.jpm.getApplicationScopedPersistenceContext();
            String DROOLS_PARENT_RUNNER = "DROOLS_PARENT_RUNNER";
            boolean bl = isParentRunner = txParent.get() == null;
            if (isParentRunner) {
                txParent.set("DROOLS_PARENT_RUNNER");
            }
            boolean transactionOwner = false;
            try {
                transactionOwner = PersistableRunner.this.txm.begin();
                persistenceContext.joinTransaction();
                PersistableRunner.this.initExistingKnowledgeSession(PersistableRunner.this.sessionInfo.getId(), PersistableRunner.this.marshallingHelper.getKbase(), PersistableRunner.this.marshallingHelper.getConf(), persistenceContext);
                PersistableRunner.this.jpm.beginCommandScopedEntityManager();
                PersistableRunner.this.registerRollbackSync();
                this.executeNext(executable, (Context)context);
                PersistableRunner.this.registerUpdateSync();
                PersistableRunner.this.txm.commit(transactionOwner);
            }
            catch (RuntimeException re) {
                if (isParentRunner) {
                    PersistableRunner.this.rollbackTransaction(re, transactionOwner);
                }
                throw re;
            }
            catch (Exception t1) {
                if (isParentRunner) {
                    PersistableRunner.this.rollbackTransaction(t1, transactionOwner);
                }
                throw new RuntimeException("Wrapped exception see cause", t1);
            }
            finally {
                if (isParentRunner) {
                    txParent.remove();
                }
            }
            return context;
        }

        public RequestContext createContext() {
            return PersistableRunner.this.createContext();
        }
    }

    private static class SynchronizationImpl
    extends OrderedTransactionSynchronization {
        PersistableRunner service;

        public SynchronizationImpl(PersistableRunner service) {
            super(Integer.valueOf(1), "SynchronizationImpl-" + service.toString());
            this.service = service;
        }

        public void afterCompletion(int status) {
            if (status != 0) {
                this.service.rollback();
            }
            if (this.service.txm != null) {
                ObjectMarshallingStrategy[] strategies;
                for (ObjectMarshallingStrategy strategy : strategies = (ObjectMarshallingStrategy[])this.service.env.get("org.kie.api.marshalling.ObjectMarshallingStrategies")) {
                    if (!(strategy instanceof TransactionAware)) continue;
                    ((TransactionAware)strategy).onEnd(this.service.txm);
                }
            }
            this.service.jpm.endCommandScopedEntityManager();
            KieSession ksession = this.service.ksession;
            if (ksession != null) {
                InternalProcessRuntime internalProcessRuntime = ((InternalWorkingMemory)ksession).internalGetProcessRuntime();
                if (internalProcessRuntime != null) {
                    if (this.service.doRollback) {
                        internalProcessRuntime.clearProcessInstancesState();
                    }
                    internalProcessRuntime.clearProcessInstances();
                }
                ((JPAWorkItemManager)ksession.getWorkItemManager()).clearWorkItems();
            }
            if (status != 0) {
                this.service.jpm.resetApplicationScopedPersistenceContext();
            }
        }

        public void beforeCompletion() {
        }

        public String toString() {
            return "SynchronizationImpl{service=" + this.service.sessionInfo + " cmd=" + this.service.toString() + "}";
        }
    }

    public static class CommandBasedEntryPointCreator
    implements EntryPointCreator {
        private final ExecutableRunner runner;

        public CommandBasedEntryPointCreator(ExecutableRunner runner) {
            this.runner = runner;
        }

        public EntryPoint getEntryPoint(String entryPoint) {
            return new CommandBasedEntryPoint(this.runner, entryPoint);
        }
    }

    public static class EndOperationListenerImpl
    implements EndOperationListener {
        private TransactionManager txm;
        private SessionInfo info;

        public EndOperationListenerImpl(TransactionManager txm, SessionInfo info) {
            this.info = info;
            this.txm = txm;
        }

        public void endOperation(InternalKnowledgeRuntime kruntime) {
            this.info.setLastModificationDate(new Date(kruntime.getLastIdleTimestamp()));
            TransactionManagerHelper.addToUpdatableSet((TransactionManager)this.txm, (Transformable)this.info);
        }
    }

    public class JpaSessionInitializer
    implements KieSessionInitializer {
        private final PersistableRunner runner;

        public JpaSessionInitializer(PersistableRunner runner) {
            this.runner = runner;
        }

        public void init(KieSession ksession) {
            TimerJobFactoryManager timerJobFactoryManager = ((InternalKnowledgeRuntime)ksession).getTimerService().getTimerJobFactoryManager();
            if (timerJobFactoryManager instanceof CommandServiceTimerJobFactoryManager) {
                ((CommandServiceTimerJobFactoryManager)timerJobFactoryManager).setRunner((ExecutableRunner)this.runner);
            }
        }
    }
}

