/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.utils;

import java.io.InputStream;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.Option;
import org.kie.api.definition.KieDescr;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.internal.builder.conf.EvaluatorOption;
import org.kie.internal.builder.conf.KnowledgeBuilderOption;
import org.kie.internal.builder.conf.SingleValueKieBuilderOption;

public class KieHelper {
    public final KieServices ks = KieServices.Factory.get();
    public final KieFileSystem kfs = this.ks.newKieFileSystem();
    private ReleaseId releaseId;
    private ClassLoader classLoader;
    private int counter = 0;
    private KieModuleModel kieModuleModel;

    public KieHelper() {
    }

    public KieHelper(KnowledgeBuilderOption ... options) {
        if (options.length > 0) {
            KieModuleModel kmm = KieServices.Factory.get().newKieModuleModel();
            for (KnowledgeBuilderOption opt : options) {
                if (opt instanceof EvaluatorOption) {
                    kmm.setConfigurationProperty("drools.evaluator." + opt.getPropertyName(), ((EvaluatorOption)opt).getEvaluatorDefinition().getClass().getName());
                    continue;
                }
                if (!(opt instanceof SingleValueKieBuilderOption)) continue;
                kmm.setConfigurationProperty(opt.getPropertyName(), opt.toString());
            }
            this.setKieModuleModel(kmm);
        }
    }

    public KieBase build(KieBaseConfiguration kieBaseConf) {
        KieContainer kieContainer = this.getKieContainer();
        return kieContainer.newKieBase(kieBaseConf);
    }

    public KieBase build(KieBaseOption ... options) {
        return this.build((Class<? extends KieBuilder.ProjectType>)null, options);
    }

    public KieBase build(Class<? extends KieBuilder.ProjectType> projectType, KieBaseOption ... options) {
        if (options == null || options.length == 0) {
            return this.getKieContainer(projectType).getKieBase();
        }
        KieBaseConfiguration kieBaseConf = this.ks.newKieBaseConfiguration();
        for (KieBaseOption option : options) {
            kieBaseConf.setOption((Option)option);
        }
        return this.build(projectType, kieBaseConf);
    }

    public KieBase build(Class<? extends KieBuilder.ProjectType> projectType, KieBaseConfiguration kieBaseConf) {
        KieContainer kieContainer = this.getKieContainer(projectType);
        return kieContainer.newKieBase(kieBaseConf);
    }

    public KieContainer getKieContainer() {
        return this.getKieContainer(null);
    }

    public KieContainer getKieContainer(Class<? extends KieBuilder.ProjectType> projectType) {
        InternalKieBuilder kieBuilder = (InternalKieBuilder)this.ks.newKieBuilder(this.kfs, this.classLoader);
        kieBuilder.withKModuleModel(this.kieModuleModel).buildAll(projectType);
        Results results = kieBuilder.getResults();
        if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuntimeException(results.getMessages().toString());
        }
        ReleaseId kieContainerReleaseId = this.releaseId != null ? this.releaseId : this.ks.getRepository().getDefaultReleaseId();
        return this.ks.newKieContainer(kieContainerReleaseId, this.classLoader);
    }

    public Results verify() {
        KieBuilder kieBuilder = ((InternalKieBuilder)this.ks.newKieBuilder(this.kfs, this.classLoader)).withKModuleModel(this.kieModuleModel).buildAll();
        return kieBuilder.getResults();
    }

    public KieHelper setReleaseId(ReleaseId releaseId) {
        this.releaseId = releaseId;
        this.kfs.generateAndWritePomXML(releaseId);
        return this;
    }

    public KieHelper setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public KieHelper setKieModuleModel(KieModuleModel kieModuleModel) {
        this.kieModuleModel = kieModuleModel;
        return this;
    }

    public KieHelper addContent(KieDescr descr) {
        return this.addResource(this.ks.getResources().newDescrResource(descr), ResourceType.DESCR);
    }

    public KieHelper addContent(String content, ResourceType type) {
        this.kfs.write(this.generateResourceName(type), content);
        return this;
    }

    public KieHelper addContent(String content, String name) {
        this.kfs.write("src/main/resources/" + name, content);
        return this;
    }

    public KieHelper addFromClassPath(String name) {
        return this.addFromClassPath(name, null);
    }

    public KieHelper addFromClassPath(String name, String encoding) {
        InputStream input = this.getClass().getResourceAsStream(name);
        if (input == null && this.classLoader != null) {
            input = this.classLoader.getResourceAsStream(name);
        }
        if (input == null) {
            throw new IllegalArgumentException("The file (" + name + ") does not exist as a classpath resource.");
        }
        ResourceType type = ResourceType.determineResourceType((String)name);
        this.kfs.write(this.generateResourceName(type), this.ks.getResources().newInputStreamResource(input, encoding));
        return this;
    }

    public KieHelper addResource(Resource resource) {
        this.kfs.write(resource);
        return this;
    }

    public KieHelper addResource(Resource resource, ResourceType type) {
        if (resource.getSourcePath() == null && resource.getTargetPath() == null) {
            resource.setSourcePath(this.generateResourceName(type));
        }
        if (resource.getResourceType() == null) {
            resource.setResourceType(type);
        }
        return this.addResource(resource);
    }

    private String generateResourceName(ResourceType type) {
        return "src/main/resources/file" + this.counter++ + "." + type.getDefaultExtension();
    }
}

