/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.util;

import java.io.Externalizable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.traits.core.factmodel.CodedHierarchy;
import org.drools.traits.core.factmodel.LatticeElement;
import org.drools.traits.core.util.AbstractBitwiseHierarchyImpl;
import org.drools.traits.core.util.HierNode;

public abstract class AbstractCodedHierarchyImpl<T>
extends AbstractBitwiseHierarchyImpl<T, HierNode<T>>
implements CodedHierarchy<T>,
Externalizable {
    @Override
    protected abstract HierNode<T> getNode(T var1);

    @Override
    public void addMember(T val, BitSet key) {
        if (this.hasKey(key)) {
            HierNode node = (HierNode)this.line.get(key);
            node.setValue(val);
        } else {
            HierNode<T> node = new HierNode<T>(val, key);
            List infs = this.gcsBorderNodes(key, false);
            List sups = this.lcsBorderNodes(key, false);
            for (HierNode child : infs) {
                if (child == null) continue;
                child.getParents().add(node);
                child.getParents().removeAll(sups);
                node.getChildren().add(child);
            }
            for (HierNode parent : sups) {
                if (parent == null) continue;
                parent.getChildren().add(node);
                parent.getChildren().removeAll(infs);
                node.getParents().add(parent);
            }
            this.add(node);
        }
    }

    @Override
    public void removeMember(T val) {
        if (val == null) {
            return;
        }
        BitSet key = this.getCode(val);
        this.removeMember(key);
    }

    @Override
    public void removeMember(BitSet key) {
        if (!this.hasKey(key)) {
            return;
        }
        HierNode node = (HierNode)this.getNodeByKey(key);
        Collection children = node.getChildren();
        Collection parents = node.getParents();
        for (HierNode child : children) {
            child.getParents().remove(node);
            child.getParents().addAll(parents);
        }
        for (HierNode parent : parents) {
            parent.getChildren().remove(node);
            parent.getChildren().addAll(children);
        }
        this.remove(node);
    }

    @Override
    protected Collection<T> parentValues(HierNode<T> node) {
        if (node == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<T> p = new ArrayList<T>(node.getParents().size());
        for (HierNode<T> parent : node.getParents()) {
            p.add(parent.getValue());
        }
        return p;
    }

    @Override
    public Collection<T> ancestors(T x) {
        LatticeElement node = this.getNode((Object)x);
        return this.ancestorValues((HierNode<T>)node);
    }

    @Override
    public Collection<T> ancestors(BitSet key) {
        HierNode node = (HierNode)this.getNodeByKey(key);
        return this.ancestorValues(node);
    }

    protected Collection<T> ancestorValues(HierNode<T> node) {
        if (node == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<T> ancestors = new HashSet<T>();
        Collection<HierNode<T>> parents = node.getParents();
        for (HierNode<T> p : parents) {
            ancestors.add(p.getValue());
            ancestors.addAll(this.ancestors(p.getValue()));
        }
        return ancestors;
    }

    protected Set<HierNode<T>> ancestorNodes(HierNode<T> x) {
        Collection<HierNode<T>> parents = x.getParents();
        HashSet<HierNode<T>> ancestors = new HashSet<HierNode<T>>(parents);
        for (HierNode<T> p : parents) {
            ancestors.addAll(this.ancestorNodes(p));
        }
        return ancestors;
    }

    protected Collection<T> childrenValues(HierNode<T> node) {
        if (node == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<T> c = new ArrayList<T>(node.getChildren().size());
        for (HierNode<T> child : node.getChildren()) {
            c.add(child.getValue());
        }
        return c;
    }

    @Override
    public Collection<T> children(T x) {
        LatticeElement node = this.getNode((Object)x);
        return this.childrenValues((HierNode<T>)node);
    }

    @Override
    public Collection<T> children(BitSet key) {
        HierNode node = (HierNode)this.getNodeByKey(key);
        return this.childrenValues(node);
    }

    protected Collection<T> descendantValues(HierNode<T> node) {
        if (node == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<T> descendants = new HashSet<T>();
        descendants.add(node.getValue());
        Collection<HierNode<T>> children = node.getChildren();
        for (HierNode<T> c : children) {
            descendants.add(c.getValue());
            descendants.addAll(this.descendants(c.getValue()));
        }
        return descendants;
    }

    @Override
    public Collection<T> descendants(T y) {
        LatticeElement node = this.getNode((Object)y);
        return this.descendantValues((HierNode<T>)node);
    }

    @Override
    public Collection<T> descendants(BitSet key) {
        HierNode node = (HierNode)this.getNodeByKey(key);
        return this.descendantValues(node);
    }

    protected Set<HierNode<T>> descendantNodes(HierNode<T> y) {
        HashSet<HierNode<T>> descendants = new HashSet<HierNode<T>>();
        descendants.add(y);
        Collection<HierNode<T>> children = y.getChildren();
        descendants.addAll(children);
        for (HierNode<T> c : children) {
            descendants.addAll(this.descendantNodes(c));
        }
        return descendants;
    }
}

