/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.core.base.ClassObjectType;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.accessor.PatternExtractor;

public class XpathBackReference {
    public static final String BACK_REFERENCE_HEAD = "$back$ref$";
    private final Pattern pattern;
    private final List<Class<?>> backReferenceClasses;
    private Map<String, Declaration> declarations = Collections.emptyMap();
    private MapAdapter declarationMap;

    public XpathBackReference(Pattern pattern, List<Class<?>> backReferenceClasses) {
        this.pattern = pattern;
        this.backReferenceClasses = backReferenceClasses;
    }

    public void reset() {
        this.declarations.clear();
    }

    public List<Class<?>> getBackReferenceClasses() {
        return this.backReferenceClasses;
    }

    public Declaration getDeclaration(Pattern pattern, String id) {
        if (!id.startsWith(BACK_REFERENCE_HEAD)) {
            return null;
        }
        Declaration declaration = this.declarations.get(id);
        if (declaration != null) {
            return declaration;
        }
        int backRefPos = Integer.parseInt(id.substring(BACK_REFERENCE_HEAD.length()));
        int relativeOffset = this.backReferenceClasses.size() - 1 - backRefPos;
        declaration = new Declaration(id, new PatternExtractor(new ClassObjectType(this.backReferenceClasses.get(backRefPos))), pattern, true);
        declaration.setxPathOffset(relativeOffset);
        if (this.declarations.isEmpty()) {
            this.declarations = new HashMap<String, Declaration>();
        }
        this.declarations.put(id, declaration);
        return declaration;
    }

    public Map<String, Declaration> getDeclarationMap() {
        if (this.declarationMap == null) {
            this.declarationMap = new MapAdapter();
        }
        return this.declarationMap;
    }

    public class MapAdapter
    implements Map<String, Declaration> {
        @Override
        public int size() {
            return XpathBackReference.this.pattern.getDeclarations().size() + XpathBackReference.this.declarations.size();
        }

        @Override
        public boolean isEmpty() {
            return XpathBackReference.this.pattern.getDeclarations().isEmpty() && XpathBackReference.this.declarations.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return XpathBackReference.this.pattern.getDeclarations().containsKey(key) || XpathBackReference.this.declarations.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return XpathBackReference.this.pattern.getDeclarations().containsValue(value) || XpathBackReference.this.declarations.containsValue(value);
        }

        @Override
        public Declaration get(Object key) {
            Declaration declaration = XpathBackReference.this.pattern.getDeclarations().get(key);
            if (declaration == null) {
                declaration = XpathBackReference.this.getDeclaration(XpathBackReference.this.pattern, (String)key);
            }
            return declaration;
        }

        @Override
        public Declaration put(String key, Declaration value) {
            return XpathBackReference.this.pattern.getDeclarations().put(key, value);
        }

        @Override
        public Declaration remove(Object key) {
            return XpathBackReference.this.pattern.getDeclarations().remove(key);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Declaration> m) {
            XpathBackReference.this.pattern.getDeclarations().putAll(m);
        }

        @Override
        public void clear() {
            XpathBackReference.this.pattern.getDeclarations().clear();
            XpathBackReference.this.declarations.clear();
        }

        @Override
        public Set<String> keySet() {
            return XpathBackReference.this.pattern.getDeclarations().keySet();
        }

        @Override
        public Collection<Declaration> values() {
            return XpathBackReference.this.pattern.getDeclarations().values();
        }

        @Override
        public Set<Map.Entry<String, Declaration>> entrySet() {
            return XpathBackReference.this.pattern.getDeclarations().entrySet();
        }
    }

    public static class RelativePattern
    extends Pattern {
        private final Pattern pattern;
        private final int relativeOffset;

        public RelativePattern(Pattern pattern, int relativeOffset) {
            this.pattern = pattern;
            this.relativeOffset = relativeOffset;
        }

        @Override
        public int getTupleIndex() {
            return this.pattern.getTupleIndex() + this.relativeOffset;
        }
    }
}

