/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jpa.processinstance;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.core.WorkItemHandlerNotFoundException;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.process.impl.WorkItemImpl;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.persistence.api.PersistenceContext;
import org.drools.persistence.api.PersistenceContextManager;
import org.drools.persistence.api.PersistentWorkItem;
import org.drools.persistence.info.WorkItemInfo;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.runtime.Closeable;

public class JPAWorkItemManager
implements org.drools.core.process.WorkItemManager {
    private InternalKnowledgeRuntime kruntime;
    private Map<String, WorkItemHandler> workItemHandlers = new HashMap<String, WorkItemHandler>();
    private transient Map<Long, WorkItemInfo> workItems;
    private volatile transient boolean pessimisticLocking;

    public JPAWorkItemManager(InternalKnowledgeRuntime kruntime) {
        this.kruntime = kruntime;
        Boolean locking = (Boolean)this.kruntime.getEnvironment().get("org.kie.api.persistence.pessimistic");
        if (locking != null && locking.booleanValue()) {
            this.pessimisticLocking = locking;
        }
    }

    public void internalExecuteWorkItem(org.drools.core.process.WorkItem workItem) {
        Environment env = this.kruntime.getEnvironment();
        WorkItemInfo workItemInfo = new WorkItemInfo(workItem, env);
        PersistenceContext context = this.getPersistenceContext();
        workItemInfo = (WorkItemInfo)context.persist((PersistentWorkItem)workItemInfo);
        ((WorkItemImpl)workItem).setId(workItemInfo.getId().longValue());
        if (this.workItems == null) {
            this.workItems = new HashMap<Long, WorkItemInfo>();
        }
        this.workItems.put(workItem.getId(), workItemInfo);
        WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler != null) {
            handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)this);
        } else {
            this.throwWorkItemNotFoundException(workItem);
        }
    }

    private void throwWorkItemNotFoundException(org.drools.core.process.WorkItem workItem) {
        throw new WorkItemHandlerNotFoundException("Could not find work item handler for " + workItem.getName(), workItem.getName());
    }

    public WorkItemHandler getWorkItemHandler(String name) {
        return this.workItemHandlers.get(name);
    }

    public void retryWorkItemWithParams(long workItemId, Map<String, Object> map) {
        Environment env = this.kruntime.getEnvironment();
        org.drools.core.process.WorkItem workItem = this.getWorkItem(workItemId);
        if (workItem != null) {
            workItem.setParameters(map);
            WorkItemInfo workItemInfo = new WorkItemInfo(workItem, env);
            PersistenceContext context = this.getPersistenceContext();
            context.merge((PersistentWorkItem)workItemInfo);
            this.retryWorkItem(workItem);
        }
    }

    public void retryWorkItem(long workItemId) {
        org.drools.core.process.WorkItem workItem = this.getWorkItem(workItemId);
        this.retryWorkItem(workItem);
    }

    private void retryWorkItem(org.drools.core.process.WorkItem workItem) {
        if (workItem != null) {
            WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler != null) {
                handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)this);
            } else {
                this.throwWorkItemNotFoundException(workItem);
            }
        }
    }

    public void internalAbortWorkItem(long id) {
        PersistenceContext context = this.getPersistenceContext();
        WorkItemInfo workItemInfo = (WorkItemInfo)context.findWorkItem(Long.valueOf(id));
        if (workItemInfo != null) {
            WorkItemImpl workItem = (WorkItemImpl)this.internalGetWorkItem(workItemInfo);
            WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler != null) {
                handler.abortWorkItem((WorkItem)workItem, (WorkItemManager)this);
            } else if (this.workItems != null) {
                this.workItems.remove(id);
                this.throwWorkItemNotFoundException((org.drools.core.process.WorkItem)workItem);
            }
            if (this.workItems != null) {
                this.workItems.remove(id);
            }
            if ((workItemInfo = (WorkItemInfo)context.findWorkItem(Long.valueOf(id))) != null) {
                context.remove((PersistentWorkItem)workItemInfo);
            }
        }
    }

    private PersistenceContext getPersistenceContext() {
        Environment env = this.kruntime.getEnvironment();
        PersistenceContext context = ((PersistenceContextManager)env.get("org.kie.api.persistence.PersistenceContextManager")).getCommandScopedPersistenceContext();
        return context;
    }

    public void internalAddWorkItem(org.drools.core.process.WorkItem workItem) {
    }

    public void completeWorkItem(long id, Map<String, Object> results) {
        PersistenceContext context = this.getPersistenceContext();
        WorkItemInfo workItemInfo = null;
        if (this.workItems != null && (workItemInfo = this.workItems.get(id)) != null) {
            workItemInfo = (WorkItemInfo)context.merge((PersistentWorkItem)workItemInfo);
        }
        if (workItemInfo == null) {
            workItemInfo = (WorkItemInfo)context.findWorkItem(Long.valueOf(id));
        }
        if (workItemInfo != null) {
            org.drools.core.process.WorkItem workItem = this.internalGetWorkItem(workItemInfo);
            workItem.setResults(results);
            ProcessInstance processInstance = this.kruntime.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(2);
            if (processInstance != null) {
                processInstance.signalEvent("workItemCompleted", (Object)workItem);
            }
            context.remove((PersistentWorkItem)workItemInfo);
            if (this.workItems != null) {
                this.workItems.remove(workItem.getId());
            }
        }
    }

    public void abortWorkItem(long id) {
        PersistenceContext context = this.getPersistenceContext();
        WorkItemInfo workItemInfo = null;
        if (this.workItems != null && (workItemInfo = this.workItems.get(id)) != null) {
            workItemInfo = (WorkItemInfo)context.merge((PersistentWorkItem)workItemInfo);
        }
        if (workItemInfo == null) {
            workItemInfo = (WorkItemInfo)context.findWorkItem(Long.valueOf(id));
        }
        if (workItemInfo != null) {
            org.drools.core.process.WorkItem workItem = this.internalGetWorkItem(workItemInfo);
            ProcessInstance processInstance = this.kruntime.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(3);
            if (processInstance != null) {
                processInstance.signalEvent("workItemAborted", (Object)workItem);
            }
            context.remove((PersistentWorkItem)workItemInfo);
            if (this.workItems != null) {
                this.workItems.remove(workItem.getId());
            }
        }
    }

    public org.drools.core.process.WorkItem getWorkItem(long id) {
        PersistenceContext context = this.getPersistenceContext();
        WorkItemInfo workItemInfo = null;
        if (this.workItems != null) {
            workItemInfo = this.workItems.get(id);
        }
        if (this.pessimisticLocking && workItemInfo != null) {
            context.lock((PersistentWorkItem)workItemInfo);
        }
        if (workItemInfo == null && context != null) {
            workItemInfo = (WorkItemInfo)context.findWorkItem(Long.valueOf(id));
        }
        if (workItemInfo == null) {
            return null;
        }
        return this.internalGetWorkItem(workItemInfo);
    }

    private org.drools.core.process.WorkItem internalGetWorkItem(WorkItemInfo workItemInfo) {
        Environment env = this.kruntime.getEnvironment();
        org.drools.core.process.WorkItem workItem = workItemInfo.getWorkItem(env, (InternalKnowledgeBase)this.kruntime.getKieBase());
        return workItem;
    }

    public Set<org.drools.core.process.WorkItem> getWorkItems() {
        return new HashSet<org.drools.core.process.WorkItem>();
    }

    public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        this.workItemHandlers.put(workItemName, handler);
    }

    public void clearWorkItems() {
        if (this.workItems != null) {
            this.workItems.clear();
        }
    }

    public void clear() {
        this.clearWorkItems();
    }

    public void signalEvent(String type, Object event) {
        this.kruntime.signalEvent(type, event);
    }

    public void signalEvent(String type, Object event, String processInstanceId) {
        this.kruntime.signalEvent(type, event, processInstanceId);
    }

    public void dispose() {
        if (this.workItemHandlers != null) {
            for (Map.Entry<String, WorkItemHandler> handlerEntry : this.workItemHandlers.entrySet()) {
                if (!(handlerEntry.getValue() instanceof Closeable)) continue;
                ((Closeable)handlerEntry.getValue()).close();
            }
        }
    }

    public void retryWorkItem(Long workItemID, Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            this.retryWorkItem(workItemID);
        } else {
            this.retryWorkItemWithParams(workItemID, params);
        }
    }
}

