/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.runtime.manager.deploy;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kie.internal.runtime.conf.BuilderHandler;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.DeploymentDescriptorBuilder;
import org.kie.internal.runtime.conf.MergeMode;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;

public class DeploymentDescriptorMerger {
    private DeploymentDescriptorMerger() {
    }

    public static DeploymentDescriptor merge(List<DeploymentDescriptor> descriptorHierarchy, MergeMode mode) {
        if (descriptorHierarchy == null || descriptorHierarchy.isEmpty()) {
            throw new IllegalArgumentException("Descriptor hierarchy list cannot be empty");
        }
        if (descriptorHierarchy.size() == 1) {
            return descriptorHierarchy.get(0);
        }
        ArrayDeque<DeploymentDescriptor> stack = new ArrayDeque<DeploymentDescriptor>();
        descriptorHierarchy.forEach(stack::push);
        while (stack.size() > 1) {
            stack.push(DeploymentDescriptorMerger.merge((DeploymentDescriptor)stack.pop(), (DeploymentDescriptor)stack.pop(), mode));
        }
        return (DeploymentDescriptor)stack.pop();
    }

    public static DeploymentDescriptor merge(DeploymentDescriptor primary, DeploymentDescriptor secondary, MergeMode mode) {
        DeploymentDescriptor merged;
        if (primary == null || secondary == null) {
            throw new IllegalArgumentException("Descriptors to merge must be provided");
        }
        if (mode == null) {
            mode = MergeMode.MERGE_COLLECTIONS;
        }
        DeploymentDescriptorBuilder builder = primary.getBuilder();
        builder.setBuildHandler(new MergeModeBuildHandler(mode));
        switch (mode) {
            case KEEP_ALL: {
                merged = primary;
                break;
            }
            case OVERRIDE_ALL: {
                merged = secondary;
                break;
            }
            case OVERRIDE_EMPTY: {
                builder.auditMode(secondary.getAuditMode());
                builder.auditPersistenceUnit(secondary.getAuditPersistenceUnit());
                builder.persistenceMode(secondary.getPersistenceMode());
                builder.persistenceUnit(secondary.getPersistenceUnit());
                builder.runtimeStrategy(secondary.getRuntimeStrategy());
                builder.setConfiguration(secondary.getConfiguration());
                builder.setEnvironmentEntries(secondary.getEnvironmentEntries());
                builder.setEventListeners(secondary.getEventListeners());
                builder.setGlobals(secondary.getGlobals());
                builder.setMarshalingStrategies(secondary.getMarshallingStrategies());
                builder.setTaskEventListeners(secondary.getTaskEventListeners());
                builder.setWorkItemHandlers(secondary.getWorkItemHandlers());
                builder.setRequiredRoles(secondary.getRequiredRoles());
                builder.setClasses(secondary.getClasses());
                builder.setLimitSerializationClasses(secondary.getLimitSerializationClasses());
                merged = builder.get();
                break;
            }
            default: {
                builder.auditMode(secondary.getAuditMode());
                builder.auditPersistenceUnit(secondary.getAuditPersistenceUnit());
                builder.persistenceMode(secondary.getPersistenceMode());
                builder.persistenceUnit(secondary.getPersistenceUnit());
                builder.runtimeStrategy(secondary.getRuntimeStrategy());
                for (ObjectModel objectModel : secondary.getEventListeners()) {
                    builder.addEventListener(objectModel);
                }
                for (ObjectModel objectModel : secondary.getMarshallingStrategies()) {
                    builder.addMarshalingStrategy(objectModel);
                }
                ArrayList<ObjectModel> taskEventListeners = new ArrayList<ObjectModel>(secondary.getTaskEventListeners());
                for (ObjectModel objectModel : primary.getTaskEventListeners()) {
                    if (taskEventListeners.contains(objectModel)) continue;
                    taskEventListeners.add(objectModel);
                }
                builder.setTaskEventListeners(taskEventListeners);
                for (NamedObjectModel namedObjectModel : secondary.getConfiguration()) {
                    builder.addConfiguration(namedObjectModel);
                }
                for (NamedObjectModel namedObjectModel : secondary.getEnvironmentEntries()) {
                    builder.addEnvironmentEntry(namedObjectModel);
                }
                for (NamedObjectModel namedObjectModel : secondary.getGlobals()) {
                    builder.addGlobal(namedObjectModel);
                }
                for (NamedObjectModel namedObjectModel : secondary.getWorkItemHandlers()) {
                    builder.addWorkItemHandler(namedObjectModel);
                }
                for (String string : secondary.getRequiredRoles()) {
                    builder.addRequiredRole(string);
                }
                for (String string : secondary.getClasses()) {
                    builder.addClass(string);
                }
                Boolean bl = secondary.getLimitSerializationClasses();
                Boolean bl2 = primary.getLimitSerializationClasses();
                if (!(bl == null || bl2 == null || bl.booleanValue() && bl2.booleanValue())) {
                    builder.setLimitSerializationClasses(false);
                }
                merged = builder.get();
            }
        }
        return merged;
    }

    private static class MergeModeBuildHandler
    implements BuilderHandler {
        private MergeMode mode;

        MergeModeBuildHandler(MergeMode mode) {
            this.mode = mode;
        }

        @Override
        public boolean accepted(Object value) {
            switch (this.mode) {
                case KEEP_ALL: {
                    return false;
                }
                case OVERRIDE_ALL: {
                    return true;
                }
            }
            return !this.isEmpty(value);
        }

        private boolean isEmpty(Object value) {
            if (value == null) {
                return true;
            }
            if (value instanceof String) {
                return ((String)value).isEmpty();
            }
            if (value instanceof Collection) {
                return ((Collection)value).isEmpty();
            }
            return false;
        }
    }
}

