/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.definitions.InternalKnowledgePackage;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.reteoo.PropertySpecificUtil;
import org.drools.base.rule.EntryPointId;
import org.drools.base.rule.TypeDeclaration;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.marshalling.MarshallerReaderContext;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.util.bitmask.BitMask;
import org.kie.api.runtime.rule.FactHandle;

public class PhreakPropagationContext
implements PropagationContext {
    private static final long serialVersionUID = 510L;
    private PropagationContext.Type type;
    private RuleImpl rule;
    private TerminalNode terminalNodeOrigin;
    private FactHandle factHandle;
    private long propagationNumber;
    private EntryPointId entryPoint;
    private BitMask modificationMask = PropertySpecificUtil.allSetBitMask();
    private BitMask originalMask = PropertySpecificUtil.allSetBitMask();
    private Class<?> modifiedClass;
    private transient MarshallerReaderContext readerContext;

    public PhreakPropagationContext() {
    }

    public PhreakPropagationContext(long number, PropagationContext.Type type, RuleImpl rule, TerminalNode terminalNode, InternalFactHandle factHandle) {
        this(number, type, rule, terminalNode, factHandle, EntryPointId.DEFAULT, PropertySpecificUtil.allSetBitMask(), Object.class, null);
    }

    public PhreakPropagationContext(long number, PropagationContext.Type type, RuleImpl rule, TerminalNode terminalNode, InternalFactHandle factHandle, EntryPointId entryPoint) {
        this(number, type, rule, terminalNode, factHandle, entryPoint, PropertySpecificUtil.allSetBitMask(), Object.class, null);
    }

    public PhreakPropagationContext(long number, PropagationContext.Type type, RuleImpl rule, TerminalNode terminalNode, InternalFactHandle factHandle, EntryPointId entryPoint, MarshallerReaderContext readerContext) {
        this(number, type, rule, terminalNode, factHandle, entryPoint, PropertySpecificUtil.allSetBitMask(), Object.class, readerContext);
    }

    public PhreakPropagationContext(long number, PropagationContext.Type type, RuleImpl rule, TerminalNode terminalNode, InternalFactHandle factHandle, EntryPointId entryPoint, BitMask modificationMask, Class<?> modifiedClass, MarshallerReaderContext readerContext) {
        this.type = type;
        this.rule = rule;
        this.terminalNodeOrigin = terminalNode;
        this.factHandle = factHandle;
        this.propagationNumber = number;
        this.entryPoint = entryPoint;
        this.modificationMask = modificationMask;
        this.originalMask = modificationMask;
        this.modifiedClass = modifiedClass;
        this.readerContext = readerContext;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = (PropagationContext.Type)((Object)in.readObject());
        this.propagationNumber = in.readLong();
        this.rule = (RuleImpl)in.readObject();
        this.entryPoint = (EntryPointId)in.readObject();
        this.modificationMask = (BitMask)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject((Object)this.type);
        out.writeLong(this.propagationNumber);
        out.writeObject(this.rule);
        out.writeObject(this.entryPoint);
        out.writeObject(this.modificationMask);
    }

    @Override
    public long getPropagationNumber() {
        return this.propagationNumber;
    }

    @Override
    public void cleanReaderContext() {
        this.readerContext = null;
    }

    @Override
    public RuleImpl getRuleOrigin() {
        return this.rule;
    }

    @Override
    public TerminalNode getTerminalNodeOrigin() {
        return this.terminalNodeOrigin;
    }

    @Override
    public FactHandle getFactHandle() {
        return this.factHandle;
    }

    @Override
    public void setFactHandle(FactHandle factHandle) {
        this.factHandle = factHandle;
    }

    @Override
    public PropagationContext.Type getType() {
        return this.type;
    }

    @Override
    public EntryPointId getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public void setEntryPoint(EntryPointId entryPoint) {
        this.entryPoint = entryPoint;
    }

    @Override
    public BitMask getModificationMask() {
        return this.modificationMask;
    }

    @Override
    public void setModificationMask(BitMask modificationMask) {
        this.modificationMask = modificationMask;
    }

    @Override
    public PropagationContext adaptModificationMaskForObjectType(ObjectType type, ReteEvaluator reteEvaluator) {
        if (PropertySpecificUtil.isAllSetPropertyReactiveMask((BitMask)this.originalMask) || this.originalMask.isSet(0) || !(type instanceof ClassObjectType)) {
            return this;
        }
        ClassObjectType classObjectType = (ClassObjectType)type;
        BitMask cachedMask = classObjectType.getTransformedMask(this.modifiedClass, this.originalMask);
        if (cachedMask != null) {
            this.modificationMask = cachedMask;
            return this;
        }
        this.modificationMask = this.originalMask;
        boolean typeBit = this.modificationMask.isSet(0);
        this.modificationMask = this.modificationMask.reset(0);
        Class classType = classObjectType.getClassType();
        String pkgName = classType.getPackage().getName();
        if (classType == this.modifiedClass || "java.lang".equals(pkgName) || !classType.isInterface() && !this.modifiedClass.isInterface()) {
            if (typeBit) {
                this.modificationMask = this.modificationMask.set(0);
            }
            return this;
        }
        List<String> typeClassProps = this.getAccessibleProperties(reteEvaluator, classType, pkgName);
        List<String> modifiedClassProps = this.getAccessibleProperties(reteEvaluator, this.modifiedClass);
        this.modificationMask = PropertySpecificUtil.getEmptyPropertyReactiveMask((int)typeClassProps.size());
        for (int i = 0; i < modifiedClassProps.size(); ++i) {
            int posInType;
            if (!PropertySpecificUtil.isPropertySetOnMask((BitMask)this.originalMask, (int)i) || (posInType = typeClassProps.indexOf(modifiedClassProps.get(i))) < 0) continue;
            this.modificationMask = PropertySpecificUtil.setPropertyOnMask((BitMask)this.modificationMask, (int)posInType);
        }
        if (typeBit) {
            this.modificationMask = this.modificationMask.set(0);
        }
        classObjectType.storeTransformedMask(this.modifiedClass, this.originalMask, this.modificationMask);
        return this;
    }

    private List<String> getAccessibleProperties(ReteEvaluator reteEvaluator, Class<?> classType) {
        return this.getAccessibleProperties(reteEvaluator, classType, classType.getPackage().getName());
    }

    private List<String> getAccessibleProperties(ReteEvaluator reteEvaluator, Class<?> classType, String pkgName) {
        if (pkgName.equals("java.lang") || pkgName.equals("java.util")) {
            return Collections.EMPTY_LIST;
        }
        InternalKnowledgePackage pkg = reteEvaluator.getKnowledgeBase().getPackage(pkgName);
        TypeDeclaration tdecl = pkg != null ? pkg.getTypeDeclaration(classType) : null;
        return tdecl != null ? tdecl.getAccessibleProperties() : Collections.EMPTY_LIST;
    }

    @Override
    public MarshallerReaderContext getReaderContext() {
        return this.readerContext;
    }

    public static String intEnumToString(PropagationContext pctx) {
        switch (pctx.getType()) {
            case INSERTION: {
                return "INSERTION";
            }
            case RULE_ADDITION: {
                return "RULE_ADDITION";
            }
            case MODIFICATION: {
                return "MODIFICATION";
            }
            case RULE_REMOVAL: {
                return "RULE_REMOVAL";
            }
            case DELETION: {
                return "DELETION";
            }
            case EXPIRATION: {
                return "EXPIRATION";
            }
        }
        throw new IllegalStateException("Int type unknown");
    }

    public String toString() {
        return "PhreakPropagationContext [entryPoint=" + this.entryPoint + ", factHandle=" + this.factHandle + ", propagationNumber=" + this.propagationNumber + ", rule=" + this.rule + ", type=" + this.type + "]";
    }
}

