/*
 * Decompiled with CFR 0.152.
 */
package org.drools.tms.beliefsystem.defeasible;

import java.util.Arrays;
import org.drools.base.beliefsystem.Mode;
import org.drools.core.util.LinkedListNode;
import org.drools.tms.beliefsystem.BeliefSystem;
import org.drools.tms.beliefsystem.defeasible.DefeasibilityStatus;
import org.drools.tms.beliefsystem.defeasible.Defeater;
import org.drools.tms.beliefsystem.defeasible.Defeats;
import org.drools.tms.beliefsystem.jtms.JTMSMode;

public class DefeasibleMode<M extends DefeasibleMode<M>>
extends JTMSMode<M> {
    private static final String[] EMPTY_DEFEATS = new String[0];
    public static final String DEFEATS = Defeats.class.getSimpleName();
    public static final String DEFEATER = Defeater.class.getSimpleName();
    private DefeasibilityStatus status;
    private String[] defeats;
    private M rootDefeated;
    private M tailDefeated;
    private M defeatedBy;
    private boolean isDefeater;
    private Mode nextMode;

    public DefeasibleMode(String value, BeliefSystem beliefSystem) {
        super(value, beliefSystem);
    }

    public DefeasibleMode(String value, BeliefSystem beliefSystem, Mode nextMode) {
        super(value, beliefSystem);
        this.nextMode = nextMode;
    }

    public void initDefeats() {
        Object o = this.getLogicalDependency().getJustifier().getRule().getMetaData().get(DEFEATER);
        if (o != null && ((Boolean)o).booleanValue()) {
            this.isDefeater = true;
        }
        if ((o = this.getLogicalDependency().getJustifier().getRule().getMetaData().get(DEFEATS)) != null) {
            if (o instanceof String) {
                this.defeats = new String[]{(String)o};
                Arrays.sort(this.defeats);
            } else if (o instanceof Object[]) {
                this.defeats = (String[])Arrays.copyOf((Object[])o, ((Object[])o).length, String[].class);
                Arrays.sort(this.defeats);
            }
        } else {
            this.defeats = EMPTY_DEFEATS;
        }
    }

    public void addDefeated(M defeated) {
        defeated.setDefeatedBy((DefeasibleMode)this);
        if (this.rootDefeated == null) {
            this.rootDefeated = defeated;
        } else {
            this.tailDefeated.setNext(defeated);
            defeated.setPrevious((LinkedListNode)this.tailDefeated);
        }
        this.tailDefeated = defeated;
    }

    public void removeDefeated(M defeated) {
        ((DefeasibleMode)defeated).setDefeatedBy(null);
        if (this.rootDefeated == defeated) {
            this.removeFirst();
        } else if (this.tailDefeated == defeated) {
            this.removeLast();
        } else {
            Object entry;
            for (entry = this.rootDefeated; entry != defeated; entry = (DefeasibleMode)entry.getNext()) {
            }
            ((DefeasibleMode)entry.getPrevious()).setNext((DefeasibleMode)entry.getNext());
            ((DefeasibleMode)entry.getNext()).setPrevious((DefeasibleMode)entry.getPrevious());
            entry.nullPrevNext();
        }
    }

    public M removeFirst() {
        if (this.rootDefeated == null) {
            return null;
        }
        M node = this.rootDefeated;
        this.rootDefeated = (DefeasibleMode)node.getNext();
        node.setNext(null);
        if (this.rootDefeated != null) {
            this.rootDefeated.setPrevious(null);
        } else {
            this.tailDefeated = null;
        }
        return node;
    }

    public M removeLast() {
        if (this.tailDefeated == null) {
            return null;
        }
        M node = this.tailDefeated;
        this.tailDefeated = (DefeasibleMode)node.getPrevious();
        node.setPrevious(null);
        if (this.tailDefeated != null) {
            this.tailDefeated.setNext(null);
        } else {
            this.rootDefeated = this.tailDefeated;
        }
        return node;
    }

    public M getRootDefeated() {
        return this.rootDefeated;
    }

    public M getTailDefeated() {
        return this.tailDefeated;
    }

    public String[] getDefeats() {
        return this.defeats;
    }

    public M getDefeatedBy() {
        return this.defeatedBy;
    }

    public void setDefeatedBy(M defeatedBy) {
        this.defeatedBy = defeatedBy;
    }

    public DefeasibilityStatus getStatus() {
        return this.status;
    }

    public void setStatus(DefeasibilityStatus status) {
        this.status = status;
    }

    public boolean isDefeater() {
        return this.isDefeater;
    }

    public void setDefeater(boolean defeater) {
        this.isDefeater = defeater;
    }

    public void clearDefeated() {
        this.rootDefeated = null;
        this.tailDefeated = null;
    }

    @Override
    public Mode getNextMode() {
        return this.nextMode;
    }

    public String toString() {
        return "DefeasibleMode{status=" + this.status + " Object=" + this.getLogicalDependency().getObject() + "} ";
    }
}

