/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml.support.converters;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.drools.base.base.XMLSupport;
import org.drools.compiler.kproject.models.ChannelModelImpl;
import org.drools.compiler.kproject.models.FileLoggerModelImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.drools.compiler.kproject.models.ListenerModelImpl;
import org.drools.compiler.kproject.models.QualifierModelImpl;
import org.drools.compiler.kproject.models.RuleTemplateModelImpl;
import org.drools.compiler.kproject.models.WorkItemHandlerModelImpl;
import org.drools.util.IoUtils;
import org.drools.xml.support.converters.ChannelConverter;
import org.drools.xml.support.converters.KBaseConverter;
import org.drools.xml.support.converters.KSessionConverter;
import org.drools.xml.support.converters.KieModuleConverter;
import org.drools.xml.support.converters.KieModuleValidator;
import org.drools.xml.support.converters.ListenerConverter;
import org.drools.xml.support.converters.QualifierConverter;
import org.drools.xml.support.converters.RuleTemplateConverter;
import org.drools.xml.support.converters.WorkItemHandelerConverter;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.utll.xml.XStreamUtils;

public class KieModuleMarshaller
implements XMLSupport.XmlMarshaller<KieModuleModel> {
    public static final KieModuleMarshaller MARSHALLER = new KieModuleMarshaller();
    private final XStream xStream = XStreamUtils.createNonTrustingXStream((HierarchicalStreamDriver)new DomDriver());

    private KieModuleMarshaller() {
        this.xStream.addPermission((TypePermission)new WildcardTypePermission(new String[]{"org.drools.compiler.kproject.models.*"}));
        this.xStream.registerConverter((Converter)new KieModuleConverter());
        this.xStream.registerConverter((Converter)new KBaseConverter());
        this.xStream.registerConverter((Converter)new KSessionConverter());
        this.xStream.registerConverter((Converter)new ListenerConverter());
        this.xStream.registerConverter((Converter)new QualifierConverter());
        this.xStream.registerConverter((Converter)new WorkItemHandelerConverter());
        this.xStream.registerConverter((Converter)new ChannelConverter());
        this.xStream.registerConverter((Converter)new RuleTemplateConverter());
        this.xStream.alias("kmodule", KieModuleModelImpl.class);
        this.xStream.alias("kbase", KieBaseModelImpl.class);
        this.xStream.alias("ksession", KieSessionModelImpl.class);
        this.xStream.alias("listener", ListenerModelImpl.class);
        this.xStream.alias("qualifier", QualifierModelImpl.class);
        this.xStream.alias("workItemHandler", WorkItemHandlerModelImpl.class);
        this.xStream.alias("channel", ChannelModelImpl.class);
        this.xStream.alias("fileLogger", FileLoggerModelImpl.class);
        this.xStream.alias("ruleTemplate", RuleTemplateModelImpl.class);
        this.xStream.setClassLoader(KieModuleModelImpl.class.getClassLoader());
    }

    public String toXML(KieModuleModel kieProject) {
        return this.xStream.toXML((Object)kieProject);
    }

    public KieModuleModel fromXML(InputStream kModuleStream) {
        byte[] bytes;
        try {
            bytes = IoUtils.readBytesFromInputStream((InputStream)kModuleStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KieModuleValidator.validate(bytes);
        return (KieModuleModel)this.xStream.fromXML((InputStream)new ByteArrayInputStream(bytes));
    }

    public KieModuleModel fromXML(File kModuleFile) {
        KieModuleValidator.validate(kModuleFile);
        return (KieModuleModel)this.xStream.fromXML(kModuleFile);
    }

    public KieModuleModel fromXML(URL kModuleUrl) {
        KieModuleValidator.validate(kModuleUrl);
        return (KieModuleModel)this.xStream.fromXML(kModuleUrl);
    }

    public KieModuleModel fromXML(String kModuleString) {
        KieModuleValidator.validate(kModuleString);
        return (KieModuleModel)this.xStream.fromXML(kModuleString);
    }
}

