/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.accessors;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import org.drools.base.base.AccessorKey;
import org.drools.base.base.AccessorKeySupplier;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.ValueType;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.core.base.FieldNameSupplier;
import org.drools.util.ClassUtils;
import org.drools.util.StringUtils;

public class ClassFieldReader
implements Externalizable,
ReadAccessor,
FieldNameSupplier,
AccessorKeySupplier {
    private static final long serialVersionUID = 510L;
    private String className;
    private String fieldName;
    private transient ReadAccessor reader;

    public ClassFieldReader() {
    }

    public ClassFieldReader(String className, String fieldName) {
        this.className = className;
        this.fieldName = StringUtils.lcFirstForBean((String)fieldName);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
        out.writeObject(this.fieldName);
    }

    @Override
    public void readExternal(ObjectInput is) throws ClassNotFoundException, IOException {
        this.className = (String)is.readObject();
        this.fieldName = (String)is.readObject();
    }

    public void setReadAccessor(ReadAccessor reader) {
        this.reader = reader;
    }

    public int getIndex() {
        return this.reader.getIndex();
    }

    public String getClassName() {
        return this.className;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean hasReadAccessor() {
        return this.reader != null;
    }

    public Object getValue(ValueResolver valueResolver, Object object) {
        return this.reader.getValue(valueResolver, object);
    }

    public ValueType getValueType() {
        return this.reader.getValueType();
    }

    public Class<?> getExtractToClass() {
        return this.reader != null ? this.reader.getExtractToClass() : null;
    }

    public String getExtractToClassName() {
        return ClassUtils.canonicalName((Class)this.reader.getExtractToClass());
    }

    public String toString() {
        return "[ClassFieldExtractor class=" + this.className + " field=" + this.fieldName + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassFieldReader)) {
            return false;
        }
        ClassFieldReader other = (ClassFieldReader)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        return !(this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName));
    }

    public boolean getBooleanValue(ValueResolver valueResolver, Object object) {
        return this.reader.getBooleanValue(valueResolver, object);
    }

    public byte getByteValue(ValueResolver valueResolver, Object object) {
        return this.reader.getByteValue(valueResolver, object);
    }

    public char getCharValue(ValueResolver valueResolver, Object object) {
        return this.reader.getCharValue(valueResolver, object);
    }

    public double getDoubleValue(ValueResolver valueResolver, Object object) {
        return this.reader.getDoubleValue(valueResolver, object);
    }

    public float getFloatValue(ValueResolver valueResolver, Object object) {
        return this.reader.getFloatValue(valueResolver, object);
    }

    public int getIntValue(ValueResolver valueResolver, Object object) {
        return this.reader.getIntValue(valueResolver, object);
    }

    public long getLongValue(ValueResolver valueResolver, Object object) {
        return this.reader.getLongValue(valueResolver, object);
    }

    public short getShortValue(ValueResolver valueResolver, Object object) {
        return this.reader.getShortValue(valueResolver, object);
    }

    public boolean isNullValue(ValueResolver valueResolver, Object object) {
        return this.reader.isNullValue(valueResolver, object);
    }

    public Method getNativeReadMethod() {
        return this.reader.getNativeReadMethod();
    }

    public String getNativeReadMethodName() {
        return this.reader.getNativeReadMethod().getName();
    }

    public int getHashCode(ValueResolver valueResolver, Object object) {
        return this.reader.getHashCode(valueResolver, object);
    }

    public boolean isGlobal() {
        return false;
    }

    public boolean isSelfReference() {
        return "this".equals(this.fieldName);
    }

    public int getHashCode(Object object) {
        return this.reader.getHashCode(object);
    }

    public Object getValue(Object object) {
        return this.reader.getValue(object);
    }

    public AccessorKey getAccessorKey() {
        return new AccessorKey(this.className, this.fieldName, AccessorKey.AccessorType.FieldAccessor);
    }
}

