/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.java;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.base.base.extractors.ArrayElementReader;
import org.drools.base.base.extractors.SelfReferenceClassFieldReader;
import org.drools.base.reteoo.SortDeclarations;
import org.drools.base.rule.Accumulate;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.MultiAccumulate;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.RuleConditionElement;
import org.drools.base.rule.SingleAccumulate;
import org.drools.base.rule.accessor.Accumulator;
import org.drools.base.rule.accessor.DeclarationScopeResolver;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.rule.accessor.TupleValueExtractor;
import org.drools.base.rule.constraint.Constraint;
import org.drools.base.util.index.ConstraintTypeOperator;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.rule.builder.GroupByBuilder;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaLocalDeclarationDescr;
import org.drools.compiler.rule.builder.util.AccumulateUtil;
import org.drools.compiler.rule.builder.util.PackageBuilderUtil;
import org.drools.core.base.accumulators.JavaAccumulatorFunctionExecutor;
import org.drools.drl.ast.descr.AccumulateDescr;
import org.drools.drl.ast.descr.AndDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.GroupByDescr;
import org.drools.drl.parser.DroolsError;
import org.drools.mvel.MVELConstraint;
import org.drools.mvel.MVELGroupByAccumulate;
import org.drools.mvel.builder.MVELExprAnalyzer;
import org.drools.mvel.java.JavaAnalysisResult;
import org.drools.mvel.java.JavaRuleBuilderHelper;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.kie.internal.builder.conf.AccumulateFunctionOption;

public class JavaGroupByBuilder
implements GroupByBuilder {
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        RuleConditionBuilder builder;
        RuleConditionElement source;
        GroupByDescr groupByDescr = (GroupByDescr)descr;
        if (!groupByDescr.hasValidInput()) {
            return null;
        }
        BaseDescr input = groupByDescr.getInput();
        if (input instanceof AndDescr && ((AndDescr)input).getDescrs().size() == 1) {
            input = (BaseDescr)((AndDescr)input).getDescrs().get(0);
        }
        if ((source = (builder = (RuleConditionBuilder)context.getDialect().getBuilder(input.getClass())).build(context, input)) == null) {
            return null;
        }
        boolean readLocalsFromTuple = PackageBuilderUtil.isReadLocalsFromTuple((RuleBuildContext)context, (AccumulateDescr)groupByDescr, (RuleConditionElement)source);
        Map declsInScope = context.getDeclarationResolver().getDeclarations(context.getRule());
        if (prefixPattern != null && prefixPattern.getDeclaration() != null) {
            declsInScope.remove(prefixPattern.getDeclaration().getIdentifier());
        }
        Map declCls = DeclarationScopeResolver.getDeclarationClasses((Map)declsInScope);
        Accumulate accumulate = groupByDescr.isExternalFunction() ? this.buildExternalFunctionCall(context, groupByDescr, source, declsInScope, declCls, readLocalsFromTuple) : this.buildInlineAccumulate(context, groupByDescr, source, declsInScope, declCls, readLocalsFromTuple);
        return accumulate;
    }

    private MVELGroupByAccumulate addGroupingFunctionCompilation(RuleBuildContext context, GroupByDescr groupByDescr, Pattern pattern, Map<String, Class<?>> declCls, Declaration[] sourceDeclArr, boolean readLocalsFromTuple, Function<Collection<Declaration>, Accumulate> innerAccumulateSupplier) {
        HashMap<String, Declaration> groupByDeclsInScope = new HashMap<String, Declaration>();
        groupByDeclsInScope.putAll(Arrays.stream(sourceDeclArr).collect(Collectors.toMap(Declaration::getIdentifier, Function.identity())));
        JavaAnalysisResult analysis = (JavaAnalysisResult)context.getDialect().analyzeExpression((PackageBuildContext)context, (BaseDescr)groupByDescr, (Object)groupByDescr.getGroupingFunction(), new BoundIdentifiers(DeclarationScopeResolver.getDeclarationClasses(groupByDeclsInScope), (PackageBuildContext)context));
        if (analysis == null) {
            return null;
        }
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        Declaration[] requiredDeclarations = this.collectRequiredDeclarations(groupByDeclsInScope, new HashSet<Declaration>(), usedIdentifiers);
        String className = "groupbyExpression" + context.getNextId();
        Class<?> keyType = MVELExprAnalyzer.getExpressionType((PackageBuildContext)context, DeclarationScopeResolver.getDeclarationClasses(groupByDeclsInScope), (RuleConditionElement)pattern, groupByDescr.getGroupingFunction());
        MVELGroupByAccumulate out = new MVELGroupByAccumulate(innerAccumulateSupplier.apply(this.bindGroupingFunctionReaderToDeclaration(context, groupByDescr, pattern, declCls, (ReadAccessor)new ArrayElementReader((ReadAccessor)new SelfReferenceClassFieldReader(Object[].class), groupByDescr.getFunctions().size(), keyType), keyType)), requiredDeclarations, null, false);
        Map<String, Object> map = JavaRuleBuilderHelper.createVariableContext(className, groupByDescr.getGroupingFunction(), context, requiredDeclarations, new Declaration[0], usedIdentifiers.getGlobals());
        map.put("readLocalsFromTuple", readLocalsFromTuple ? Boolean.TRUE : Boolean.FALSE);
        JavaRuleBuilderHelper.generateTemplates("returnValueMethod", "returnValueInvoker", context, className, map, out.new MVELGroupByAccumulate.GroupingFunctionWirer(), (BaseDescr)groupByDescr);
        return out;
    }

    private Accumulate buildExternalFunctionCall(RuleBuildContext context, GroupByDescr groupByDescr, RuleConditionElement source, Map<String, Declaration> declsInScope, Map<String, Class<?>> declCls, boolean readLocalsFromTuple) {
        List funcCalls = groupByDescr.getFunctions();
        Declaration[] sourceDeclArr = source.getOuterDeclarations().values().toArray(new Declaration[source.getOuterDeclarations().size()]);
        Arrays.sort(sourceDeclArr, SortDeclarations.instance);
        HashSet requiredDecl = new HashSet();
        Pattern pattern = (Pattern)context.getDeclarationResolver().peekBuildStack();
        Function<Collection<Object>, Accumulate> accumulateSupplier = groupByDescr.isMultiFunction() ? keyDecls -> {
            for (Declaration declaration : keyDecls) {
                declsInScope.put(declaration.getIdentifier(), declaration);
            }
            requiredDecl.addAll(keyDecls);
            Accumulator[] accumulators = new Accumulator[funcCalls.size()];
            SelfReferenceClassFieldReader reader = new SelfReferenceClassFieldReader(Object[].class);
            int index = 0;
            for (AccumulateDescr.AccumulateFunctionCallDescr fc : funcCalls) {
                AccumulateFunction function = this.getAccumulateFunction(context, groupByDescr, fc, source, declCls);
                if (function == null) {
                    return null;
                }
                this.bindReaderToDeclaration(context, groupByDescr, pattern, fc, (ReadAccessor)new ArrayElementReader((ReadAccessor)reader, index, function.getResultType()), function.getResultType(), index);
                accumulators[index++] = this.buildAccumulator(context, groupByDescr, declsInScope, declCls, readLocalsFromTuple, sourceDeclArr, requiredDecl, (Collection<Declaration>)keyDecls, fc, function);
            }
            requiredDecl.addAll(List.of(sourceDeclArr));
            return new MultiAccumulate(source, requiredDecl.toArray(new Declaration[requiredDecl.size()]), accumulators, accumulators.length + 1);
        } : keyDecls -> {
            for (Declaration declaration : keyDecls) {
                declsInScope.put(declaration.getIdentifier(), declaration);
            }
            requiredDecl.addAll(keyDecls);
            AccumulateDescr.AccumulateFunctionCallDescr fc = (AccumulateDescr.AccumulateFunctionCallDescr)groupByDescr.getFunctions().get(0);
            AccumulateFunction function = this.getAccumulateFunction(context, groupByDescr, fc, source, declCls);
            if (function == null) {
                return null;
            }
            Class returnType = function.getResultType();
            if (!pattern.isCompatibleWithAccumulateReturnType(returnType)) {
                context.addError((DroolsError)new DescrBuildError((BaseDescr)groupByDescr, (BaseDescr)context.getRuleDescr(), null, "Pattern of type: '" + pattern.getObjectType() + "' on rule '" + context.getRuleDescr().getName() + "' is not compatible with type " + returnType.getCanonicalName() + " returned by accumulate function."));
                return null;
            }
            this.bindReaderToDeclaration(context, groupByDescr, pattern, fc, (ReadAccessor)new ArrayElementReader((ReadAccessor)new SelfReferenceClassFieldReader(Object[].class), 0, function.getResultType()), function.getResultType(), -1);
            Accumulator accumulator = this.buildAccumulator(context, groupByDescr, declsInScope, declCls, readLocalsFromTuple, sourceDeclArr, requiredDecl, (Collection<Declaration>)keyDecls, fc, function);
            requiredDecl.addAll(List.of(sourceDeclArr));
            return new SingleAccumulate(source, requiredDecl.toArray(new Declaration[requiredDecl.size()]), accumulator);
        };
        return this.addGroupingFunctionCompilation(context, groupByDescr, pattern, declCls, sourceDeclArr, readLocalsFromTuple, accumulateSupplier);
    }

    private Collection<Declaration> bindGroupingFunctionReaderToDeclaration(RuleBuildContext context, GroupByDescr groupByDescr, Pattern pattern, Map<String, Class<?>> declCls, ReadAccessor readAccessor, Class<?> resultType) {
        if (groupByDescr.getGroupingKey() != null) {
            if (context.getDeclarationResolver().isDuplicated(context.getRule(), groupByDescr.getGroupingKey(), resultType.getName())) {
                context.addError((DroolsError)new DescrBuildError(context.getParentDescr(), (BaseDescr)groupByDescr, null, "Duplicate declaration for variable '" + groupByDescr.getGroupingKey() + "' in the rule '" + context.getRule().getName() + "'"));
            } else {
                Declaration declr = pattern.addDeclaration(groupByDescr.getGroupingKey());
                declr.setDeclarationClass(resultType);
                declr.setReadAccessor(readAccessor);
                declCls.put(groupByDescr.getGroupingKey(), resultType);
                return Collections.singletonList(declr);
            }
        }
        return Collections.emptyList();
    }

    private void bindReaderToDeclaration(RuleBuildContext context, GroupByDescr groupByDescr, Pattern pattern, AccumulateDescr.AccumulateFunctionCallDescr fc, ReadAccessor readAccessor, Class<?> resultType, int index) {
        if (fc.getBind() != null) {
            if (context.getDeclarationResolver().isDuplicated(context.getRule(), fc.getBind(), resultType.getName())) {
                if (!fc.isUnification()) {
                    context.addError((DroolsError)new DescrBuildError(context.getParentDescr(), (BaseDescr)groupByDescr, null, "Duplicate declaration for variable '" + fc.getBind() + "' in the rule '" + context.getRule().getName() + "'"));
                } else {
                    Declaration inner = context.getDeclarationResolver().getDeclaration(fc.getBind());
                    MVELConstraint c = new MVELConstraint(Collections.singletonList(context.getPkg().getName()), index >= 0 ? "this[ " + index + " ] == " + fc.getBind() : "this == " + fc.getBind(), new Declaration[]{inner}, null, null, ConstraintTypeOperator.EQUAL, (TupleValueExtractor)context.getDeclarationResolver().getDeclaration(fc.getBind()), (ReadAccessor)(index >= 0 ? new ArrayElementReader(readAccessor, index, resultType) : readAccessor), true);
                    c.setType(Constraint.ConstraintType.BETA);
                    pattern.addConstraint((Constraint)c);
                }
            } else {
                Declaration declr = pattern.addDeclaration(fc.getBind());
                declr.setReadAccessor(readAccessor);
            }
        }
    }

    private AccumulateFunction getAccumulateFunction(RuleBuildContext context, GroupByDescr groupByDescr, AccumulateDescr.AccumulateFunctionCallDescr fc, RuleConditionElement source, Map<String, Class<?>> declCls) {
        String functionName = AccumulateUtil.getFunctionName(() -> MVELExprAnalyzer.getExpressionType((PackageBuildContext)context, declCls, source, fc.getParams()[0]), (String)fc.getFunction());
        AccumulateFunction function = ((AccumulateFunctionOption)context.getConfiguration().getOption(AccumulateFunctionOption.KEY, functionName)).getFunction();
        if (function == null) {
            function = (AccumulateFunction)context.getPkg().getAccumulateFunctions().get(functionName);
        }
        if (function == null) {
            context.addError((DroolsError)new DescrBuildError((BaseDescr)groupByDescr, (BaseDescr)context.getRuleDescr(), null, "Unknown accumulate function: '" + functionName + "' on rule '" + context.getRuleDescr().getName() + "'. All accumulate functions must be registered before building a resource."));
        }
        return function;
    }

    private Accumulator buildAccumulator(RuleBuildContext context, GroupByDescr groupByDescr, Map<String, Declaration> declsInScope, Map<String, Class<?>> declCls, boolean readLocalsFromTuple, Declaration[] sourceDeclArr, Set<Declaration> requiredDecl, Collection<Declaration> keyDeclarations, AccumulateDescr.AccumulateFunctionCallDescr fc, AccumulateFunction function) {
        JavaAnalysisResult analysis = (JavaAnalysisResult)context.getDialect().analyzeBlock((PackageBuildContext)context, (BaseDescr)groupByDescr, fc.getParams().length > 0 ? fc.getParams()[0] : "\"\"", new BoundIdentifiers(declCls, (PackageBuildContext)context));
        if (analysis == null) {
            return null;
        }
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        if (groupByDescr.getGroupingKey() != null && Stream.of(fc.getParams()).anyMatch(parameter -> parameter.contains(groupByDescr.getGroupingKey()))) {
            usedIdentifiers.getDeclrClasses().put(groupByDescr.getGroupingKey(), declCls.get(groupByDescr.getGroupingKey()));
        }
        Declaration[] previousDeclarations = this.collectRequiredDeclarations(declsInScope, requiredDecl, usedIdentifiers);
        return this.generateFunctionCallCodeTemplate(context, groupByDescr, sourceDeclArr, fc, function, usedIdentifiers, previousDeclarations, readLocalsFromTuple);
    }

    private Declaration[] collectRequiredDeclarations(Map<String, Declaration> declsInScope, Set<Declaration> requiredDecl, BoundIdentifiers usedIdentifiers) {
        Declaration[] previousDeclarations = new Declaration[usedIdentifiers.getDeclrClasses().size()];
        int i = 0;
        for (String key : usedIdentifiers.getDeclrClasses().keySet()) {
            Declaration d = declsInScope.get(key);
            previousDeclarations[i++] = d;
            requiredDecl.add(d);
        }
        return previousDeclarations;
    }

    private JavaAccumulatorFunctionExecutor generateFunctionCallCodeTemplate(RuleBuildContext context, GroupByDescr groupByDescr, Declaration[] sourceDeclArr, AccumulateDescr.AccumulateFunctionCallDescr fc, AccumulateFunction function, BoundIdentifiers usedIdentifiers, Declaration[] previousDeclarations, boolean readLocalsFromTuple) {
        String className = "accumulateExpression" + context.getNextId();
        Map<String, Object> map = JavaRuleBuilderHelper.createVariableContext(className, fc.getParams().length > 0 ? fc.getParams()[0] : "\"\"", context, previousDeclarations, sourceDeclArr, usedIdentifiers.getGlobals());
        map.put("readLocalsFromTuple", readLocalsFromTuple ? Boolean.TRUE : Boolean.FALSE);
        JavaAccumulatorFunctionExecutor accumulator = new JavaAccumulatorFunctionExecutor(function);
        JavaRuleBuilderHelper.generateTemplates("returnValueMethod", "returnValueInvoker", context, className, map, accumulator, (BaseDescr)groupByDescr);
        return accumulator;
    }

    private Accumulate buildInlineAccumulate(RuleBuildContext context, GroupByDescr groupByDescr, RuleConditionElement source, Map<String, Declaration> decls, Map<String, Class<?>> declCls, boolean readLocalsFromTuple) {
        Declaration[] sourceDeclArr = source.getOuterDeclarations().values().toArray(new Declaration[source.getOuterDeclarations().size()]);
        Arrays.sort(sourceDeclArr, SortDeclarations.instance);
        return this.addGroupingFunctionCompilation(context, groupByDescr, (Pattern)context.getDeclarationResolver().peekBuildStack(), new HashMap(), sourceDeclArr, readLocalsFromTuple, keyDecls -> {
            String className = "Accumulate" + context.getNextId();
            groupByDescr.setClassName(className);
            BoundIdentifiers available = new BoundIdentifiers(declCls, (PackageBuildContext)context);
            JavaAnalysisResult initCodeAnalysis = (JavaAnalysisResult)context.getDialect().analyzeBlock((PackageBuildContext)context, (BaseDescr)groupByDescr, groupByDescr.getInitCode(), available);
            AnalysisResult actionCodeAnalysis = context.getDialect().analyzeBlock((PackageBuildContext)context, (BaseDescr)groupByDescr, groupByDescr.getActionCode(), available);
            AnalysisResult resultCodeAnalysis = context.getDialect().analyzeExpression((PackageBuildContext)context, (BaseDescr)groupByDescr, (Object)groupByDescr.getResultCode(), available);
            if (initCodeAnalysis == null || actionCodeAnalysis == null || resultCodeAnalysis == null) {
                return null;
            }
            HashSet requiredDeclarations = new HashSet(initCodeAnalysis.getBoundIdentifiers().getDeclrClasses().keySet());
            requiredDeclarations.addAll(actionCodeAnalysis.getBoundIdentifiers().getDeclrClasses().keySet());
            requiredDeclarations.addAll(resultCodeAnalysis.getBoundIdentifiers().getDeclrClasses().keySet());
            HashMap<String, Type> requiredGlobals = new HashMap<String, Type>(initCodeAnalysis.getBoundIdentifiers().getGlobals());
            requiredGlobals.putAll(actionCodeAnalysis.getBoundIdentifiers().getGlobals());
            requiredGlobals.putAll(resultCodeAnalysis.getBoundIdentifiers().getGlobals());
            if (groupByDescr.getReverseCode() != null) {
                AnalysisResult reverseCodeAnalysis = context.getDialect().analyzeBlock((PackageBuildContext)context, (BaseDescr)groupByDescr, groupByDescr.getActionCode(), available);
                requiredDeclarations.addAll(reverseCodeAnalysis.getBoundIdentifiers().getDeclrClasses().keySet());
                requiredGlobals.putAll(reverseCodeAnalysis.getBoundIdentifiers().getGlobals());
            }
            Declaration[] declarations = new Declaration[requiredDeclarations.size()];
            int i = 0;
            Iterator it = requiredDeclarations.iterator();
            while (it.hasNext()) {
                declarations[i] = (Declaration)decls.get(it.next());
                ++i;
            }
            Map<String, Object> map = JavaRuleBuilderHelper.createVariableContext(className, null, context, declarations, null, requiredGlobals);
            map.put("className", groupByDescr.getClassName());
            map.put("innerDeclarations", sourceDeclArr);
            map.put("isMultiPattern", readLocalsFromTuple ? Boolean.TRUE : Boolean.FALSE);
            String initCode = this.fixInitCode(initCodeAnalysis, groupByDescr.getInitCode());
            String actionCode = groupByDescr.getActionCode();
            String resultCode = groupByDescr.getResultCode();
            String[] attributesTypes = new String[initCodeAnalysis.getLocalVariablesMap().size()];
            String[] attributes = new String[initCodeAnalysis.getLocalVariablesMap().size()];
            int index = 0;
            for (Map.Entry<String, JavaLocalDeclarationDescr> entry : initCodeAnalysis.getLocalVariablesMap().entrySet()) {
                attributes[index] = entry.getKey();
                attributesTypes[index] = entry.getValue().getType();
                ++index;
            }
            map.put("attributes", attributes);
            map.put("attributesTypes", attributesTypes);
            map.put("initCode", initCode);
            map.put("actionCode", actionCode);
            map.put("resultCode", resultCode);
            if (groupByDescr.getReverseCode() == null) {
                map.put("reverseCode", "");
                map.put("supportsReverse", "false");
            } else {
                map.put("reverseCode", groupByDescr.getReverseCode());
                map.put("supportsReverse", "true");
            }
            map.put("hashCode", actionCode.hashCode());
            SingleAccumulate accumulate = new SingleAccumulate(source, declarations);
            JavaRuleBuilderHelper.generateTemplates("accumulateInnerClass", "accumulateInvoker", context, className, map, new SingleAccumulate.Wirer(accumulate), (BaseDescr)groupByDescr);
            return accumulate;
        });
    }

    public String fixInitCode(JavaAnalysisResult analysis, String originalCode) {
        TreeSet<JavaLocalDeclarationDescr> locals = new TreeSet<JavaLocalDeclarationDescr>(new Comparator<JavaLocalDeclarationDescr>(){

            @Override
            public int compare(JavaLocalDeclarationDescr o1, JavaLocalDeclarationDescr o2) {
                return o1.getStart() - o2.getStart();
            }
        });
        locals.addAll(analysis.getLocalVariablesMap().values());
        StringBuilder initCode = new StringBuilder();
        int lastAdded = 0;
        for (JavaLocalDeclarationDescr d : locals) {
            initCode.append(originalCode.substring(lastAdded, d.getStart()));
            lastAdded = d.getEnd();
            for (JavaLocalDeclarationDescr.IdentifierDescr id : d.getIdentifiers()) {
                initCode.append(originalCode.substring(id.getStart(), id.getEnd()));
                initCode.append(";");
                for (lastAdded = id.getEnd(); lastAdded < originalCode.length() && (Character.isWhitespace(originalCode.charAt(lastAdded)) || originalCode.charAt(lastAdded) == ';'); ++lastAdded) {
                }
            }
        }
        initCode.append(originalCode.substring(lastAdded));
        return initCode.toString();
    }
}

