/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.resources;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DrlParser;
import org.drools.drl.parser.DroolsParserException;
import org.drools.drl.parser.ParserError;
import org.drools.drl.parser.lang.ExpanderException;
import org.drools.drl.parser.lang.dsl.DefaultExpander;
import org.drools.util.IoUtils;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceHandler {
    protected KnowledgeBuilderConfigurationImpl configuration;
    protected Collection<KnowledgeBuilderResult> results = new ArrayList<KnowledgeBuilderResult>();
    protected ReleaseId releaseId;
    protected static final Logger logger = LoggerFactory.getLogger(ResourceHandler.class);

    public ResourceHandler(KnowledgeBuilderConfigurationImpl configuration, ReleaseId releaseId) {
        this.configuration = configuration;
        this.releaseId = releaseId;
    }

    public ResourceHandler(KnowledgeBuilderConfigurationImpl configuration) {
        this.configuration = configuration;
    }

    public abstract PackageDescr process(Resource var1, ResourceConfiguration var2) throws DroolsParserException, IOException;

    public final PackageDescr process(Resource resource) throws DroolsParserException, IOException {
        return this.process(resource, null);
    }

    public abstract boolean handles(ResourceType var1);

    public Collection<KnowledgeBuilderResult> getResults() {
        return this.results;
    }

    protected PackageDescr generatedDrlToPackageDescr(Resource resource, String generatedDrl) throws DroolsParserException {
        if (this.configuration.getDumpDir() != null) {
            this.dumpDrlGeneratedFromDTable(this.configuration.getDumpDir(), generatedDrl, resource.getSourcePath());
        }
        DrlParser parser = new DrlParser((LanguageLevelOption)this.configuration.getOption(LanguageLevelOption.KEY));
        PackageDescr pkg = parser.parse(resource, (Reader)new StringReader(generatedDrl));
        this.results.addAll(parser.getErrors());
        if (pkg == null) {
            this.results.add((KnowledgeBuilderResult)new ParserError(resource, "Parser returned a null Package", 0, 0));
        } else {
            pkg.setResource(resource);
        }
        return parser.hasErrors() ? null : pkg;
    }

    protected void dumpDrlGeneratedFromDTable(File dumpDir, String generatedDrl, String srcPath) {
        Object fileName;
        Object object = fileName = srcPath != null ? srcPath : "decision-table-" + UUID.randomUUID();
        if (this.releaseId != null) {
            fileName = this.releaseId.getGroupId() + "_" + this.releaseId.getArtifactId() + "_" + (String)fileName;
        }
        File dumpFile = this.createDumpDrlFile(dumpDir, (String)fileName, ".drl");
        try {
            IoUtils.write((File)dumpFile, (byte[])generatedDrl.getBytes(IoUtils.UTF8_CHARSET));
        }
        catch (IOException ex) {
            logger.warn("Can't write the DRL generated from decision table to file {}!\n{}", (Object)dumpFile.getAbsolutePath(), (Object)Arrays.toString(ex.getStackTrace()));
        }
    }

    protected File createDumpDrlFile(File dumpDir, String fileName, String extension) {
        return new File(dumpDir, fileName.replaceAll("[^a-zA-Z0-9\\.\\-_]+", "_") + extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PackageDescr dslrReaderToPackageDescr(Resource resource, Reader dslrReader, DefaultExpander expander) throws DroolsParserException {
        boolean hasErrors;
        PackageDescr pkg;
        this.results.clear();
        DrlParser parser = new DrlParser((LanguageLevelOption)this.configuration.getOption(LanguageLevelOption.KEY));
        try {
            try {
                if (expander == null) {
                    expander = new DefaultExpander();
                }
                String str = expander.expand(dslrReader);
                if (expander.hasErrors()) {
                    for (ExpanderException error : expander.getErrors()) {
                        error.setResource(resource);
                        this.results.add((KnowledgeBuilderResult)error);
                    }
                }
                pkg = parser.parse(resource, str);
                this.results.addAll(parser.getErrors());
                hasErrors = parser.hasErrors();
            }
            finally {
                if (dslrReader != null) {
                    dslrReader.close();
                }
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return hasErrors ? null : pkg;
    }
}

