/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.core.util.BinaryHeapQueue;
import org.drools.core.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeSetQueue<T extends Queue.QueueEntry>
implements Queue<T>,
Externalizable {
    protected static final Logger log = LoggerFactory.getLogger(BinaryHeapQueue.class);
    private TreeSet<T> elements;

    public TreeSetQueue() {
    }

    public TreeSetQueue(Comparator<T> comparator) {
        this.elements = new TreeSet<T>(comparator);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.elements = (TreeSet)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.elements);
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    @Override
    public Collection<T> getAll() {
        return this.elements;
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public T peek() {
        return (T)(this.isEmpty() ? null : (Queue.QueueEntry)this.elements.last());
    }

    @Override
    public void enqueue(T element) {
        this.elements.add(element);
        element.setQueued(true);
        if (log.isTraceEnabled()) {
            log.trace("Queue Added {}", element);
        }
    }

    @Override
    public T dequeue() {
        return (T)((Queue.QueueEntry)this.elements.pollLast());
    }

    @Override
    public void dequeue(T activation) {
        this.elements.remove(activation);
    }

    public String toString() {
        return Stream.of(this.elements).filter(Objects::nonNull).collect(Collectors.toList()).toString();
    }
}

