/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.processors;

import java.util.ArrayList;
import org.drools.base.definitions.InternalKnowledgePackage;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.compiler.builder.impl.AssetFilter;
import org.drools.compiler.builder.impl.processors.AbstractPackageCompilationPhase;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.core.impl.InternalRuleBase;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.kie.internal.builder.ResourceChange;

public class ReteCompiler
extends AbstractPackageCompilationPhase {
    private final AssetFilter assetFilter;
    private InternalRuleBase kBase;

    public ReteCompiler(PackageRegistry pkgRegistry, PackageDescr packageDescr, InternalRuleBase kBase, AssetFilter assetFilter) {
        super(pkgRegistry, packageDescr);
        this.kBase = kBase;
        this.assetFilter = assetFilter;
    }

    @Override
    public void process() {
        if (this.kBase != null) {
            InternalKnowledgePackage pkg = this.pkgRegistry.getPackage();
            ArrayList<RuleImpl> rulesToBeAdded = new ArrayList<RuleImpl>();
            for (RuleDescr ruleDescr : this.packageDescr.getRules()) {
                if (!this.filterAccepts(ResourceChange.Type.RULE, ruleDescr.getNamespace(), ruleDescr.getName())) continue;
                rulesToBeAdded.add(pkg.getRule(ruleDescr.getName()));
            }
            if (!rulesToBeAdded.isEmpty()) {
                this.kBase.addRules(rulesToBeAdded);
            }
        }
    }

    private boolean filterAccepts(ResourceChange.Type type, String namespace, String name) {
        return this.assetFilter == null || !AssetFilter.Action.DO_NOTHING.equals((Object)this.assetFilter.accept(type, namespace, name));
    }
}

