/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.rule.accessor;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import org.drools.base.base.AcceptsClassObjectType;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.extractors.BaseObjectClassFieldReader;
import org.drools.base.facttemplates.Fact;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.util.ClassUtils;

public class PatternExtractor
extends BaseObjectClassFieldReader
implements ReadAccessor,
AcceptsClassObjectType,
Externalizable {
    private static final long serialVersionUID = 510L;
    private ObjectType objectType;

    public PatternExtractor() {
    }

    public PatternExtractor(ObjectType objectType) {
        this.objectType = objectType;
        if (objectType instanceof ClassObjectType) {
            this.setClassObjectType((ClassObjectType)objectType);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.objectType = (ObjectType)in.readObject();
        this.setIndex(in.readInt());
        this.setFieldType(((ClassObjectType)this.objectType).getClassType());
        this.setValueType(this.objectType.getValueType());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.objectType);
        out.writeInt(this.getIndex());
    }

    @Override
    public void setClassObjectType(ClassObjectType objectType) {
        this.objectType = objectType;
        this.setIndex(-1);
        this.setFieldType(objectType.getClassType());
        this.setValueType(objectType.getValueType());
    }

    @Override
    public Object getValue(ValueResolver valueResolver, Object object) {
        return object;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public Class<?> getExtractToClass() {
        if (this.objectType instanceof ClassObjectType) {
            return ((ClassObjectType)this.objectType).getClassType();
        }
        return Fact.class;
    }

    @Override
    public String getExtractToClassName() {
        Class<Fact> clazz = this.objectType instanceof ClassObjectType ? ((ClassObjectType)this.objectType).getClassType() : Fact.class;
        return ClassUtils.canonicalName(clazz);
    }

    @Override
    public Method getNativeReadMethod() {
        try {
            return this.getClass().getDeclaredMethod("getValue", ValueResolver.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    @Override
    public String getNativeReadMethodName() {
        return "getValue";
    }

    @Override
    public int hashCode() {
        return this.objectType.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PatternExtractor)) {
            return false;
        }
        PatternExtractor other = (PatternExtractor)obj;
        return this.objectType.equals(other.objectType);
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isSelfReference() {
        return true;
    }
}

