/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.rule.constraint;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.drools.base.base.AcceptsClassObjectType;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.DroolsQuery;
import org.drools.base.base.ObjectType;
import org.drools.base.base.ValueResolver;
import org.drools.base.phreak.ReactiveObject;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.ContextEntry;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.From;
import org.drools.base.rule.MutableTypeConstraint;
import org.drools.base.rule.accessor.DataProvider;
import org.drools.base.rule.accessor.PatternExtractor;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.rule.constraint.AlphaNodeFieldConstraint;
import org.drools.base.rule.constraint.BetaNodeFieldConstraint;
import org.drools.base.rule.constraint.Constraint;
import org.drools.util.ClassUtils;
import org.kie.api.runtime.rule.FactHandle;

public class XpathConstraint
extends MutableTypeConstraint {
    private LinkedList<XpathChunk> chunks;
    private Declaration declaration;
    private Declaration xpathStartDeclaration;

    public XpathConstraint() {
        this(new LinkedList<XpathChunk>());
    }

    private XpathConstraint(LinkedList<XpathChunk> chunks) {
        this.chunks = chunks;
    }

    public XpathChunk addChunck(Class<?> clazz, String field, int index, boolean iterate, boolean lazy) {
        XpathChunk chunk = XpathChunk.get(clazz, field, index, iterate, lazy);
        if (chunk != null) {
            this.chunks.add(chunk);
        }
        return chunk;
    }

    @Override
    public Constraint.ConstraintType getType() {
        return Constraint.ConstraintType.XPATH;
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        return new Declaration[0];
    }

    @Override
    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XpathConstraint clone() {
        XpathConstraint clone = new XpathConstraint(this.chunks);
        if (this.declaration != null) {
            clone.setDeclaration(this.declaration.clone());
        }
        if (this.xpathStartDeclaration != null) {
            clone.setXpathStartDeclaration(this.xpathStartDeclaration.clone());
        }
        return clone;
    }

    @Override
    public boolean isTemporal() {
        return false;
    }

    @Override
    public boolean isAllowedCachedLeft(ContextEntry context, FactHandle handle) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAllowedCachedRight(BaseTuple tuple, ContextEntry context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ContextEntry createContextEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAllowed(FactHandle handle, ValueResolver valueResolver) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.chunks = (LinkedList)in.readObject();
        this.declaration = (Declaration)in.readObject();
        this.xpathStartDeclaration = (Declaration)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.chunks);
        out.writeObject(this.declaration);
        out.writeObject(this.xpathStartDeclaration);
    }

    public LinkedList<XpathChunk> getChunks() {
        return this.chunks;
    }

    public Class<?> getResultClass() {
        return this.chunks.isEmpty() ? Object.class : this.chunks.getLast().getReturnedClass();
    }

    public Declaration getDeclaration() {
        return this.declaration;
    }

    public void setDeclaration(Declaration declaration) {
        declaration.setReadAccessor(this.getReadAccessor());
        this.declaration = declaration;
    }

    public ReadAccessor getReadAccessor() {
        return new PatternExtractor(new ClassObjectType(this.getResultClass()));
    }

    public Declaration getXpathStartDeclaration() {
        return this.xpathStartDeclaration;
    }

    public void setXpathStartDeclaration(Declaration xpathStartDeclaration) {
        this.xpathStartDeclaration = xpathStartDeclaration;
        this.chunks.get((int)0).declaration = xpathStartDeclaration;
    }

    public String toString() {
        return this.chunks.toString();
    }

    public static class XpathDataProvider
    implements DataProvider {
        private final XpathEvaluator xpathEvaluator;
        private final Declaration declaration;

        public XpathDataProvider(XpathEvaluator xpathEvaluator, Declaration declaration) {
            this.xpathEvaluator = xpathEvaluator;
            this.declaration = declaration;
        }

        @Override
        public Declaration[] getRequiredDeclarations() {
            return new Declaration[0];
        }

        @Override
        public Object createContext() {
            return null;
        }

        @Override
        public Iterator getResults(BaseTuple tuple, ValueResolver valueResolver, Object providerContext) {
            FactHandle fh = tuple.getFactHandle();
            Object obj = fh.getObject();
            if (obj instanceof DroolsQuery) {
                obj = this.declaration.getValue(null, obj);
            }
            return this.xpathEvaluator.evaluate(valueResolver, tuple, obj).iterator();
        }

        @Override
        public DataProvider clone() {
            return this;
        }

        @Override
        public void replaceDeclaration(Declaration declaration, Declaration resolved) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.xpathEvaluator.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof XpathChunk)) {
                return false;
            }
            XpathDataProvider other = (XpathDataProvider)obj;
            return this.xpathEvaluator.equals(other.xpathEvaluator) && Objects.equals(this.declaration, other.declaration);
        }

        public int hashCode() {
            int hash = 31 * this.xpathEvaluator.hashCode();
            if (this.declaration != null) {
                hash += 37 * this.declaration.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isReactive() {
            return true;
        }
    }

    public static class XpathChunk
    implements AcceptsClassObjectType,
    Externalizable {
        private String field;
        private int index;
        private boolean iterate;
        private boolean lazy;
        private boolean array;
        private List<Constraint> constraints;
        private Declaration declaration;
        private ClassObjectType classObjectType;
        private ObjectType returnedType;
        private Method accessor;

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.field);
            out.writeInt(this.index);
            out.writeBoolean(this.iterate);
            out.writeBoolean(this.lazy);
            out.writeBoolean(this.array);
            out.writeObject(this.constraints);
            out.writeObject(this.declaration);
            out.writeObject(this.classObjectType);
            out.writeObject(this.returnedType);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.field = (String)in.readObject();
            this.index = in.readInt();
            this.iterate = in.readBoolean();
            this.lazy = in.readBoolean();
            this.array = in.readBoolean();
            this.constraints = (List)in.readObject();
            this.declaration = (Declaration)in.readObject();
            this.classObjectType = (ClassObjectType)in.readObject();
            this.returnedType = (ClassObjectType)in.readObject();
        }

        public XpathChunk() {
        }

        private XpathChunk(String field, int index, boolean iterate, boolean lazy, boolean array) {
            this.field = field;
            this.index = index;
            this.iterate = iterate;
            this.lazy = lazy;
            this.array = array;
        }

        private static XpathChunk get(Class<?> clazz, String field, int index, boolean iterate, boolean lazy) {
            Method accessor = ClassUtils.getAccessor(clazz, (String)field);
            if (accessor == null) {
                return null;
            }
            return new XpathChunk(accessor.getName(), index, iterate, lazy, iterate && accessor.getReturnType().isArray());
        }

        private Method getAccessor() {
            if (this.accessor == null) {
                try {
                    this.accessor = this.classObjectType.getClassType().getMethod(this.field, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.accessor;
        }

        public void addConstraint(Constraint constraint) {
            if (this.constraints == null) {
                this.constraints = new ArrayList<Constraint>();
            }
            this.setConstraintType((MutableTypeConstraint)constraint);
            this.constraints.add(constraint);
        }

        private void setConstraintType(MutableTypeConstraint constraint) {
            Declaration[] declarations = constraint.getRequiredDeclarations();
            boolean isAlphaConstraint = true;
            for (int i = 0; isAlphaConstraint && i < declarations.length; ++i) {
                if (declarations[i].isGlobal()) continue;
                isAlphaConstraint = false;
            }
            Constraint.ConstraintType type = isAlphaConstraint ? Constraint.ConstraintType.ALPHA : Constraint.ConstraintType.BETA;
            constraint.setType(type);
        }

        public Object evaluate(Object obj) {
            try {
                List<Object> result = this.getAccessor().invoke(obj, new Object[0]);
                if (this.array) {
                    result = Arrays.asList((Object[])result);
                }
                if (this.index >= 0) {
                    result = result.subList(this.index, this.index + 1);
                }
                return result;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Class<?> getReturnedClass() {
            if (this.returnedType != null) {
                return ((ClassObjectType)this.returnedType).getClassType();
            }
            try {
                Method accessor = this.classObjectType.getClassType().getMethod(this.field, new Class[0]);
                return ClassUtils.convertFromPrimitiveType(this.iterate ? this.getItemClass(accessor) : accessor.getReturnType());
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public void setReturnedType(ObjectType returnedType) {
            this.returnedType = returnedType;
        }

        private Class<?> getItemClass(Method accessor) {
            Class<?> lastReturnedClass = accessor.getReturnType();
            if (Iterable.class.isAssignableFrom(lastReturnedClass)) {
                return this.getParametricType(accessor);
            }
            if (lastReturnedClass.isArray()) {
                return lastReturnedClass.getComponentType();
            }
            return lastReturnedClass;
        }

        private Class<?> getParametricType(Method accessor) {
            Type[] parametricType;
            Type returnedType = accessor.getGenericReturnType();
            if (returnedType instanceof ParameterizedType && (parametricType = ((ParameterizedType)returnedType).getActualTypeArguments()).length > 0) {
                return parametricType[0] instanceof Class ? (Class)parametricType[0] : (Class)((ParameterizedType)parametricType[0]).getRawType();
            }
            return Object.class;
        }

        public From asFrom() {
            From from = new From(new XpathDataProvider(new SingleChunkXpathEvaluator(this), this.declaration));
            from.setResultClass(this.getReturnedClass());
            return from;
        }

        public List<AlphaNodeFieldConstraint> getAlphaConstraints() {
            return this.getConstraintsByType(Constraint.ConstraintType.ALPHA);
        }

        public List<BetaNodeFieldConstraint> getBetaConstraints() {
            return this.getConstraintsByType(Constraint.ConstraintType.BETA);
        }

        public List<XpathConstraint> getXpathConstraints() {
            return this.getConstraintsByType(Constraint.ConstraintType.XPATH);
        }

        private <T> List<T> getConstraintsByType(Constraint.ConstraintType constraintType) {
            if (this.constraints == null) {
                return Collections.emptyList();
            }
            ArrayList<Constraint> typedConstraints = new ArrayList<Constraint>();
            for (Constraint constraint : this.constraints) {
                if (constraint.getType() != constraintType) continue;
                typedConstraints.add(constraint);
            }
            return typedConstraints;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder((this.lazy ? "?" : "") + this.classObjectType.getClassType().getSimpleName());
            if (this.iterate) {
                sb.append("/");
            } else {
                sb.append(".");
            }
            sb.append(this.field);
            if (this.index >= 0) {
                sb.append("[").append(this.index).append("]");
            }
            if (this.constraints != null && !this.constraints.isEmpty()) {
                sb.append("{");
                sb.append(this.constraints.get(0));
                for (int i = 1; i < this.constraints.size(); ++i) {
                    sb.append(", ").append(this.constraints.get(i));
                }
                sb.append("}");
            }
            return sb.toString();
        }

        @Override
        public void setClassObjectType(ClassObjectType classObjectType) {
            this.classObjectType = classObjectType;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof XpathChunk)) {
                return false;
            }
            XpathChunk other = (XpathChunk)obj;
            return this.field.equals(other.field) && this.index == other.index && this.iterate == other.iterate && this.lazy == other.lazy && this.array == other.array && Objects.equals(this.declaration, other.declaration);
        }

        public int hashCode() {
            int hash = 23 * this.field.hashCode() + 29 * this.index;
            if (this.declaration != null) {
                hash += 31 * this.declaration.hashCode();
            }
            if (this.iterate) {
                hash += 37;
            }
            if (this.lazy) {
                hash += 41;
            }
            if (this.array) {
                hash += 43;
            }
            return hash;
        }
    }

    private static class SingleChunkXpathEvaluator
    implements XpathEvaluator {
        private final XpathChunk chunk;

        private SingleChunkXpathEvaluator(XpathChunk chunk) {
            this.chunk = chunk;
        }

        @Override
        public Iterable<?> evaluate(ValueResolver valueResolver, BaseTuple leftBaseTuple, Object object) {
            return this.evaluateObject(valueResolver, leftBaseTuple, this.chunk, new ArrayList<Object>(), object);
        }

        private List<Object> evaluateObject(ValueResolver valueResolver, BaseTuple leftBaseTuple, XpathChunk chunk, List<Object> list, Object object) {
            Object result = chunk.evaluate(object);
            if (!chunk.lazy && result instanceof ReactiveObject) {
                ((ReactiveObject)result).addTuple(leftBaseTuple);
            }
            if (chunk.iterate && result instanceof Iterable) {
                for (Object value : (Iterable)result) {
                    if (!chunk.lazy && value instanceof ReactiveObject) {
                        ((ReactiveObject)value).addTuple(leftBaseTuple);
                    }
                    if (value == null) continue;
                    list.add(value);
                }
            } else if (result != null) {
                list.add(result);
            }
            return list;
        }

        public String toString() {
            return this.chunk.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SingleChunkXpathEvaluator)) {
                return false;
            }
            SingleChunkXpathEvaluator other = (SingleChunkXpathEvaluator)obj;
            return this.chunk.equals(other.chunk);
        }

        public int hashCode() {
            return this.chunk.hashCode();
        }
    }

    private static interface XpathEvaluator {
        public Iterable<?> evaluate(ValueResolver var1, BaseTuple var2, Object var3);
    }
}

