/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import org.drools.base.base.ValueResolver;
import org.drools.base.reteoo.AccumulateContextEntry;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.Accumulate;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.GroupElement;
import org.drools.base.rule.RuleConditionElement;
import org.drools.base.rule.accessor.Accumulator;
import org.drools.base.rule.accessor.CompiledInvoker;
import org.drools.base.rule.accessor.Wireable;
import org.kie.api.runtime.rule.FactHandle;

public class SingleAccumulate
extends Accumulate {
    private Accumulator accumulator;

    public SingleAccumulate() {
    }

    public SingleAccumulate(RuleConditionElement source, Declaration[] requiredDeclarations) {
        super(source, requiredDeclarations);
    }

    public SingleAccumulate(RuleConditionElement source, Declaration[] requiredDeclarations, Accumulator accumulator) {
        super(source, requiredDeclarations);
        this.accumulator = accumulator;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.accumulator = (Accumulator)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (CompiledInvoker.isCompiledInvoker(this.accumulator)) {
            out.writeObject(null);
        } else {
            out.writeObject(this.accumulator);
        }
    }

    @Override
    public boolean isMultiFunction() {
        return false;
    }

    @Override
    public Accumulator[] getAccumulators() {
        return new Accumulator[]{this.accumulator};
    }

    @Override
    public Object createFunctionContext() {
        return this.accumulator.createContext();
    }

    @Override
    public Object init(Object workingMemoryContext, Object accContext, Object funcContext, BaseTuple leftTuple, ValueResolver valueResolver) {
        Object returned = this.accumulator.init(workingMemoryContext, funcContext, leftTuple, this.requiredDeclarations, valueResolver);
        return returned;
    }

    @Override
    public Object accumulate(Object workingMemoryContext, Object context, BaseTuple match, FactHandle handle, ValueResolver valueResolver) {
        return this.accumulator.accumulate(workingMemoryContext, ((AccumulateContextEntry)context).getFunctionContext(), match, handle, this.requiredDeclarations, this.getInnerDeclarationCache(), valueResolver);
    }

    @Override
    public Object accumulate(Object workingMemoryContext, BaseTuple match, FactHandle childHandle, Object groupByContext, Object tupleList, ValueResolver valueResolver) {
        throw new UnsupportedOperationException("This should never be called, it's for LambdaGroupByAccumulate only.");
    }

    @Override
    public boolean tryReverse(Object workingMemoryContext, Object context, BaseTuple leftTuple, FactHandle handle, BaseTuple match, ValueResolver valueResolver) {
        return this.accumulator.tryReverse(workingMemoryContext, ((AccumulateContextEntry)context).getFunctionContext(), leftTuple, handle, match.getContextObject(), this.requiredDeclarations, this.getInnerDeclarationCache(), valueResolver);
    }

    @Override
    public boolean supportsReverse() {
        return this.accumulator.supportsReverse();
    }

    @Override
    public Object getResult(Object workingMemoryContext, Object context, BaseTuple leftTuple, ValueResolver valueResolver) {
        return this.accumulator.getResult(workingMemoryContext, ((AccumulateContextEntry)context).getFunctionContext(), leftTuple, this.requiredDeclarations, valueResolver);
    }

    @Override
    public SingleAccumulate clone() {
        RuleConditionElement clonedSource = this.source instanceof GroupElement ? ((GroupElement)this.source).cloneOnlyGroup() : this.source.clone();
        SingleAccumulate clone = new SingleAccumulate(clonedSource, this.requiredDeclarations, this.accumulator);
        this.registerClone(clone);
        return clone;
    }

    @Override
    public void replaceAccumulatorDeclaration(Declaration declaration, Declaration resolved) {
        this.accumulator.replaceDeclaration(declaration, resolved);
    }

    @Override
    public Object createWorkingMemoryContext() {
        return this.accumulator.createWorkingMemoryContext();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.accumulator.hashCode();
        result = 31 * result + Arrays.hashCode(this.requiredDeclarations);
        result = 31 * result + Arrays.hashCode(this.innerDeclarationCache);
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleAccumulate other = (SingleAccumulate)obj;
        if (!this.accumulator.equals(other.accumulator)) {
            return false;
        }
        if (!Arrays.equals(this.requiredDeclarations, other.requiredDeclarations)) {
            return false;
        }
        if (!Arrays.equals(this.innerDeclarationCache, other.innerDeclarationCache)) {
            return false;
        }
        if (this.source == null) {
            return other.source == null;
        }
        return this.source.equals(other.source);
    }

    public final class Wirer
    implements Wireable.Immutable,
    Serializable {
        private static final long serialVersionUID = -9072646735174734614L;
        private transient boolean initialized;

        @Override
        public void wire(Object object) {
            Accumulator acc;
            SingleAccumulate.this.accumulator = acc = (Accumulator)object;
            for (Accumulate clone : SingleAccumulate.this.cloned) {
                ((SingleAccumulate)clone).accumulator = acc;
            }
            this.initialized = true;
        }

        @Override
        public boolean isInitialized() {
            return this.initialized;
        }
    }
}

