/*
 * Decompiled with CFR 0.152.
 */
package org.drools.tms.agenda;

import org.drools.core.common.ActivationsManager;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.Sink;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListNode;
import org.drools.tms.LogicalDependency;
import org.drools.tms.SimpleMode;
import org.drools.tms.TruthMaintenanceSystemImpl;
import org.drools.tms.agenda.TruthMaintenanceSystemInternalMatch;
import org.drools.tms.beliefsystem.ModedAssertion;

public class TruthMaintenanceSystemRuleTerminalNodeLeftTuple<T extends ModedAssertion<T>>
extends RuleTerminalNodeLeftTuple
implements TruthMaintenanceSystemInternalMatch<T> {
    private LinkedList<SimpleMode> blockers;
    private LinkedList<LogicalDependency<T>> justified;
    private LinkedList<LogicalDependency<SimpleMode>> blocked;

    public TruthMaintenanceSystemRuleTerminalNodeLeftTuple() {
    }

    public TruthMaintenanceSystemRuleTerminalNodeLeftTuple(InternalFactHandle factHandle, Sink sink, boolean leftTupleMemoryEnabled) {
        super(factHandle, sink, leftTupleMemoryEnabled);
    }

    public TruthMaintenanceSystemRuleTerminalNodeLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        super(factHandle, leftTuple, sink);
    }

    public TruthMaintenanceSystemRuleTerminalNodeLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        super(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    public TruthMaintenanceSystemRuleTerminalNodeLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        super(leftTuple, rightTuple, sink);
    }

    public TruthMaintenanceSystemRuleTerminalNodeLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        super(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LinkedList<SimpleMode> getBlockers() {
        return this.blockers;
    }

    public boolean hasBlockers() {
        return this.blockers != null && !this.blockers.isEmpty();
    }

    @Override
    public void addBlocked(LogicalDependency<SimpleMode> dep) {
        if (this.blocked == null) {
            this.blocked = new LinkedList();
        }
        this.blocked.add(dep);
        TruthMaintenanceSystemRuleTerminalNodeLeftTuple blocked = (TruthMaintenanceSystemRuleTerminalNodeLeftTuple)dep.getJustified();
        if (blocked.blockers == null) {
            blocked.blockers = new LinkedList();
            blocked.blockers.add((LinkedListNode)dep.getMode());
        } else if (dep.getMode().getNext() == null && dep.getMode().getPrevious() == null && blocked.getBlockers().getFirst() != dep.getMode()) {
            blocked.blockers.add((LinkedListNode)dep.getMode());
        }
    }

    @Override
    public void removeAllBlockersAndBlocked(ActivationsManager activationsManager) {
        if (this.blockers != null) {
            for (SimpleMode node = (SimpleMode)this.blockers.getFirst(); node != null; node = (SimpleMode)node.getNext()) {
                LogicalDependency dep = (LogicalDependency)node.getObject();
                dep.getJustifier().getBlocked().remove((LinkedListNode)dep);
            }
        }
        this.blockers = null;
        if (this.blocked != null) {
            LogicalDependency dep = (LogicalDependency)this.blocked.getFirst();
            while (dep != null) {
                LogicalDependency tmp = (LogicalDependency)dep.getNext();
                this.removeBlocked(dep);
                TruthMaintenanceSystemRuleTerminalNodeLeftTuple justified = (TruthMaintenanceSystemRuleTerminalNodeLeftTuple)dep.getJustified();
                if (justified.getBlockers().isEmpty() && justified.isActive()) {
                    activationsManager.stageLeftTuple(justified.getRuleAgendaItem(), (InternalMatch)justified);
                }
                dep = tmp;
            }
        }
        this.blocked = null;
    }

    @Override
    public void removeBlocked(LogicalDependency<SimpleMode> dep) {
        this.blocked.remove(dep);
        TruthMaintenanceSystemRuleTerminalNodeLeftTuple blocked = (TruthMaintenanceSystemRuleTerminalNodeLeftTuple)dep.getJustified();
        blocked.blockers.remove((LinkedListNode)dep.getMode());
    }

    @Override
    public LinkedList<LogicalDependency<SimpleMode>> getBlocked() {
        return this.blocked;
    }

    @Override
    public void setBlocked(LinkedList<LogicalDependency<SimpleMode>> justified) {
        this.blocked = justified;
    }

    @Override
    public void addLogicalDependency(LogicalDependency<T> node) {
        if (this.justified == null) {
            this.justified = new LinkedList();
        }
        this.justified.add(node);
    }

    @Override
    public LinkedList<LogicalDependency<T>> getLogicalDependencies() {
        return this.justified;
    }

    @Override
    public void setLogicalDependencies(LinkedList<LogicalDependency<T>> justified) {
        this.justified = justified;
    }

    public void cancelActivation(ActivationsManager activationsManager) {
        this.removeAllBlockersAndBlocked(activationsManager);
        super.cancelActivation(activationsManager);
        TruthMaintenanceSystemImpl.removeLogicalDependencies(this);
    }
}

