/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.drools.base.base.ObjectType;
import org.drools.base.common.NetworkNode;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.reteoo.NodeTypeEnums;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.UpdateContext;
import org.drools.core.reteoo.AbstractTerminalNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.EmptyLeftTupleSinkAdapter;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.SubnetworkTuple;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.util.bitmask.BitMask;
import org.kie.api.definition.rule.Rule;

public class RightInputAdapterNode
extends ObjectSource
implements LeftTupleSinkNode,
PathEndNode {
    private static final long serialVersionUID = 510L;
    private LeftTupleSource tupleSource;
    private LeftTupleSource startTupleSource;
    private boolean tupleMemoryEnabled;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private LeftTupleNode[] pathNodes;
    private PathEndNode[] pathEndNodes;
    private PathEndNode.PathMemSpec pathMemSpec;
    private SegmentMemory.SegmentPrototype[] segmentPrototypes;
    private SegmentMemory.SegmentPrototype[] eagerSegmentPrototypes;
    private int objectCount;

    public RightInputAdapterNode() {
    }

    public RightInputAdapterNode(int id, LeftTupleSource source, LeftTupleSource startTupleSource, BuildContext context) {
        super(id, context.getPartitionId());
        this.tupleSource = source;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.startTupleSource = startTupleSource;
        this.hashcode = this.calculateHashCode();
        this.initMemoryId(context);
    }

    @Override
    public PathEndNode.PathMemSpec getPathMemSpec() {
        return this.getPathMemSpec(null);
    }

    @Override
    public PathEndNode.PathMemSpec getPathMemSpec(TerminalNode removingTN) {
        if (this.pathMemSpec == null) {
            this.pathMemSpec = this.calculatePathMemSpec(this.startTupleSource, removingTN);
        }
        return this.pathMemSpec;
    }

    @Override
    public void nullPathMemSpec() {
        this.pathMemSpec = null;
    }

    @Override
    public void setPathMemSpec(PathEndNode.PathMemSpec pathMemSpec) {
        this.pathMemSpec = pathMemSpec;
    }

    @Override
    public void resetPathMemSpec(TerminalNode removingTN) {
        this.nullPathMemSpec();
        this.pathMemSpec = this.getPathMemSpec(removingTN);
    }

    @Override
    public void setSegmentPrototypes(SegmentMemory.SegmentPrototype[] smems) {
        this.segmentPrototypes = smems;
    }

    @Override
    public SegmentMemory.SegmentPrototype[] getSegmentPrototypes() {
        return this.segmentPrototypes;
    }

    @Override
    public SegmentMemory.SegmentPrototype[] getEagerSegmentPrototypes() {
        return this.eagerSegmentPrototypes;
    }

    @Override
    public void setEagerSegmentPrototypes(SegmentMemory.SegmentPrototype[] eagerSegmentPrototypes) {
        this.eagerSegmentPrototypes = eagerSegmentPrototypes;
    }

    @Override
    public void setPathEndNodes(PathEndNode[] pathEndNodes) {
        this.pathEndNodes = pathEndNodes;
    }

    @Override
    public PathEndNode[] getPathEndNodes() {
        return this.pathEndNodes;
    }

    @Override
    public LeftTupleSource getStartTupleSource() {
        return this.startTupleSource;
    }

    @Override
    public int getPathIndex() {
        return this.tupleSource.getPathIndex() + 1;
    }

    @Override
    public int getObjectCount() {
        return this.objectCount;
    }

    @Override
    public void setObjectCount(int count) {
        this.objectCount = count;
    }

    @Override
    public RiaPathMemory createMemory(RuleBaseConfiguration config, ReteEvaluator reteEvaluator) {
        return (RiaPathMemory)AbstractTerminalNode.initPathMemory(this, new RiaPathMemory(this, reteEvaluator));
    }

    @Override
    public SubnetworkTuple createPeer(LeftTuple original) {
        SubnetworkTuple peer = new SubnetworkTuple();
        peer.initPeer(original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    public void doAttach(BuildContext context) {
        this.tupleSource.addTupleSink(this, context);
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.tupleSource.networkUpdated(updateContext);
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        if (!this.isInUse()) {
            this.tupleSource.removeTupleSink(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    public short getType() {
        return 71;
    }

    private int calculateHashCode() {
        return this.tupleSource.hashCode() * 17 + (this.tupleMemoryEnabled ? 1234 : 4321);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof RightInputAdapterNode && this.hashCode() == object.hashCode() && this.tupleSource.getId() == ((RightInputAdapterNode)object).tupleSource.getId() && this.tupleMemoryEnabled == ((RightInputAdapterNode)object).tupleMemoryEnabled;
    }

    @Override
    public String toString() {
        return "RightInputAdapterNode(" + this.id + ")[ tupleMemoryEnabled=" + this.tupleMemoryEnabled + ", tupleSource=" + this.tupleSource + ", source=" + this.source + ", associations=" + this.associations + ", partitionId=" + this.partitionId + "]";
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, boolean leftTupleMemoryEnabled) {
        return new SubnetworkTuple(factHandle, this, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        return new SubnetworkTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new SubnetworkTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        return new SubnetworkTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        return new SubnetworkTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.tupleSource;
    }

    public void setTupleSource(LeftTupleSource tupleSource) {
        this.tupleSource = tupleSource;
    }

    @Override
    public ObjectTypeNode.Id getLeftInputOtnId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLeftInputOtnId(ObjectTypeNode.Id leftInputOtnId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitMask calculateDeclaredMask(ObjectType modifiedType, List<String> settableProperties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitMask getLeftInferredMask() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory wm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LeftTupleNode[] getPathNodes() {
        if (this.pathNodes == null) {
            this.pathNodes = AbstractTerminalNode.getPathNodes(this);
        }
        return this.pathNodes;
    }

    @Override
    public boolean hasPathNode(LeftTupleNode node) {
        for (LeftTupleNode pathNode : this.getPathNodes()) {
            if (node.getId() != pathNode.getId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public LeftTupleSinkPropagator getSinkPropagator() {
        return EmptyLeftTupleSinkAdapter.getInstance();
    }

    @Override
    public void addAssociation(BuildContext context, Rule rule) {
        super.addAssociation(context, rule);
        context.addPathEndNode(this);
    }

    @Override
    public boolean removeAssociation(Rule rule, RuleRemovalContext context) {
        boolean result = this.associations.remove(rule);
        if (this.getAssociationsSize() == 0) {
            return result;
        }
        ArrayList<PathEndNode> remainingPathNodes = new ArrayList<PathEndNode>();
        for (PathEndNode pathEndNode : this.pathEndNodes) {
            if (pathEndNode.getAssociatedTerminalsSize() <= 0) continue;
            remainingPathNodes.add(pathEndNode);
        }
        this.pathEndNodes = remainingPathNodes.toArray(new PathEndNode[remainingPathNodes.size()]);
        return result;
    }

    public static class RiaPathMemory
    extends PathMemory
    implements Memory {
        private List<RuleImpl> rules;

        public RiaPathMemory(PathEndNode pathEndNode, ReteEvaluator reteEvaluator) {
            super(pathEndNode, reteEvaluator);
        }

        @Override
        protected boolean initDataDriven(ReteEvaluator reteEvaluator) {
            for (PathEndNode pnode : this.getPathEndNode().getPathEndNodes()) {
                RuleImpl rule;
                if (!(pnode instanceof TerminalNode) || !this.isRuleDataDriven(reteEvaluator, rule = ((TerminalNode)pnode).getRule())) continue;
                return true;
            }
            return false;
        }

        public RightInputAdapterNode getRightInputAdapterNode() {
            return (RightInputAdapterNode)this.getPathEndNode();
        }

        @Override
        public void doLinkRule(ReteEvaluator reteEvaluator) {
            this.getRightInputAdapterNode().getObjectSinkPropagator().doLinkRiaNode(reteEvaluator);
        }

        @Override
        public void doLinkRule(ActivationsManager activationsManager) {
            this.doLinkRule(activationsManager.getReteEvaluator());
        }

        @Override
        public void doUnlinkRule(ReteEvaluator reteEvaluator) {
            this.getRightInputAdapterNode().getObjectSinkPropagator().doUnlinkRiaNode(reteEvaluator);
        }

        private void updateRuleTerminalNodes() {
            this.rules = new ArrayList<RuleImpl>();
            for (ObjectSink osink : this.getRightInputAdapterNode().getObjectSinkPropagator().getSinks()) {
                for (LeftTupleSink ltsink : ((BetaNode)osink).getSinkPropagator().getSinks()) {
                    this.findAndAddTN(ltsink, this.rules);
                }
            }
        }

        private void findAndAddTN(LeftTupleSink ltsink, List<RuleImpl> terminalNodes) {
            if (NodeTypeEnums.isTerminalNode((NetworkNode)ltsink)) {
                terminalNodes.add(((TerminalNode)ltsink).getRule());
            } else if (ltsink.getType() == 71) {
                for (NetworkNode childSink : ltsink.getSinks()) {
                    this.findAndAddTN((LeftTupleSink)childSink, terminalNodes);
                }
            } else {
                for (LeftTupleSink childLtSink : ltsink.getSinkPropagator().getSinks()) {
                    this.findAndAddTN(childLtSink, terminalNodes);
                }
            }
        }

        public List<RuleImpl> getAssociatedRules() {
            if (this.rules == null) {
                this.updateRuleTerminalNodes();
            }
            return this.rules;
        }

        public String getRuleNames() {
            HashSet<String> ruleNames = new HashSet<String>();
            for (RuleImpl rule : this.getAssociatedRules()) {
                ruleNames.add(rule.getName());
            }
            return ((Object)ruleNames).toString();
        }

        @Override
        public short getNodeType() {
            return 71;
        }

        @Override
        public String toString() {
            return "RiaMem(" + this.getRightInputAdapterNode().getId() + ") [" + this.getRuleNames() + "]";
        }
    }
}

