/*
 * Decompiled with CFR 0.152.
 */
package org.drools.doc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.doc.Comment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrlRuleData {
    private static final String rulesExpr = "(^\\s*#.*?\\n)?(^\\s*rule.*?$)(.*?)(when)(.*?)(then)(.*?)(^\\s*end)";
    private static final Pattern finder = Pattern.compile("(^\\s*#.*?\\n)?(^\\s*rule.*?$)(.*?)(when)(.*?)(then)(.*?)(^\\s*end)", 40);
    public final Collection<String> header;
    public final Collection<String> lhs;
    public final Collection<String> rhs;
    public final String ruleName;
    public final String description;
    public final Collection<String> metadata;
    public final Map<String, List<String>> otherInformation;

    private DrlRuleData(String ruleName, String header, String lhs, String rhs, String description, List<String> metadata, Map<String, List<String>> otherInformation) {
        this.ruleName = ruleName;
        this.header = this.asList(header.split("\n"));
        this.lhs = this.asList(lhs.split("\n"));
        this.rhs = this.asList(rhs.split("\n"));
        this.description = description;
        this.metadata = metadata;
        this.otherInformation = otherInformation;
    }

    private Collection<String> asList(String[] array) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            String string = array[i];
            if (string.trim().equals("")) continue;
            list.add(string);
        }
        return list;
    }

    public static List<DrlRuleData> findRulesDataFromDrl(String drl) {
        Matcher m = finder.matcher(drl);
        ArrayList<DrlRuleData> list = new ArrayList<DrlRuleData>();
        while (m.find()) {
            Comment comment = DrlRuleData.processComment(m.group(1));
            String ruleName = m.group(2);
            ruleName = ruleName.substring(ruleName.indexOf("rule") + "rule".length()).trim();
            list.add(new DrlRuleData(ruleName, m.group(3), m.group(5), m.group(7), comment.description, comment.metadata, new HashMap<String, List<String>>()));
        }
        return list;
    }

    static Comment processComment(String text) {
        Comment comment = new Comment();
        if (text == null) {
            comment.description = "";
            comment.metadata = new ArrayList<String>();
            return comment;
        }
        comment.description = text.replaceAll("#", "").trim();
        comment.metadata = DrlRuleData.findMetaData(text);
        return comment;
    }

    private static List<String> findMetaData(String text) {
        ArrayList<String> list = new ArrayList<String>();
        while (text.contains("@")) {
            int start = text.indexOf(64);
            text = text.substring(start + 1);
            int end = text.indexOf("\n");
            list.add(text.substring(0, end));
            text = text.substring(end);
        }
        return list;
    }
}

