/*
 * Decompiled with CFR 0.152.
 */
package org.drools.doc;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfWriter;
import java.io.OutputStream;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.drools.doc.DrlPackageData;
import org.drools.doc.DrlRuleData;
import org.drools.doc.DroolsDocsComponentFactory;

public class DroolsDocsBuilder {
    protected final String currentDate = DroolsDocsBuilder.getFormatter().format(new Date());
    private final DrlPackageData packageData;

    protected static Format getFormatter() {
        return new SimpleDateFormat(DroolsDocsBuilder.getDateFormatMask());
    }

    protected DroolsDocsBuilder(String packageDrl) {
        this.packageData = DrlPackageData.findPackageDataFromDrl(packageDrl);
    }

    protected DroolsDocsBuilder(DrlPackageData packageData) {
        this.packageData = packageData;
    }

    public static DroolsDocsBuilder getInstance(String packageDrl) {
        return new DroolsDocsBuilder(packageDrl);
    }

    public static DroolsDocsBuilder getInstance(DrlPackageData packageData) {
        return new DroolsDocsBuilder(packageData);
    }

    public void writePDF(OutputStream out) {
        Document document = new Document();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)out);
            HeaderFooter footer = DroolsDocsComponentFactory.createFooter(this.packageData.packageName);
            document.setFooter(footer);
            document.addTitle(this.packageData.packageName.toUpperCase());
            document.open();
            DroolsDocsComponentFactory.createFirstPage(document, this.currentDate, this.packageData);
            document.newPage();
            document.add((Element)new Phrase("Contents"));
            document.add((Element)DroolsDocsComponentFactory.createContents(this.packageData.rules));
            document.newPage();
            for (DrlRuleData ruleData : this.packageData.rules) {
                DroolsDocsComponentFactory.createRulePage(document, this.packageData.packageName, ruleData);
            }
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
        document.close();
    }

    public static String getDateFormatMask() {
        String fmt = System.getProperty("drools.dateformat");
        if (fmt == null) {
            fmt = "dd-MMM-yyyy";
        }
        return fmt;
    }
}

