/*
 * Decompiled with CFR 0.152.
 */
package org.drools.doc;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.drools.doc.DrlPackageData;
import org.drools.doc.DrlRuleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsDocsComponentFactory {
    private static final int INTENTATION_LEFT = 20;
    private static final String INDENT = "    ";
    private static final Font CHAPTER_TITLE = FontFactory.getFont((String)"Times", (float)20.0f, (int)1);
    private static final Font PACKAGE_NAME = FontFactory.getFont((String)"Times", (float)10.0f, (int)1);
    private static final Font RULE_PACKAGE_TITLE = FontFactory.getFont((String)"Times", (float)24.0f, (int)1);
    private static final Font CATEGORIES_TEXT = FontFactory.getFont((String)"Times", (float)12.0f);
    private static final Font BODY_TEXT = FontFactory.getFont((String)"Times", (float)10.0f);
    static final Font HEADER_FOOTER_TEXT = FontFactory.getFont((String)"Times", (float)8.0f);

    public static Table createDescription(String description) throws DocumentException {
        Table table = DroolsDocsComponentFactory.createEmptyTable();
        Cell headerCell = DroolsDocsComponentFactory.newEmptyHeaderCell("Description");
        table.addCell(headerCell);
        table.addCell(DroolsDocsComponentFactory.newEmptyCell(INDENT + description));
        return table;
    }

    private static Table createEmptyTable() throws BadElementException {
        Table table = new Table(1);
        table.setBorderWidthTop(1.0f);
        table.setBorderWidthLeft(1.0f);
        table.setBorderWidthRight(1.0f);
        table.setBorderWidthBottom(0.0f);
        table.setPadding(3.0f);
        table.setAlignment(0);
        return table;
    }

    public static void createOtherItems(Document document, Map<String, List<String>> other) throws DocumentException {
        for (String key : other.keySet()) {
            document.add((Element)DroolsDocsComponentFactory.createTable(key, (Collection<String>)other.get(key)));
        }
    }

    public static Table createRuleTable(DrlRuleData drl) throws BadElementException, DocumentException {
        Table table = DroolsDocsComponentFactory.createEmptyTable();
        Cell headerCell = DroolsDocsComponentFactory.newEmptyWhenThenCell("Attributes");
        table.addCell(headerCell);
        for (String s : drl.header) {
            table.addCell(DroolsDocsComponentFactory.newEmptyCell(INDENT + s.trim()));
        }
        table.addCell(DroolsDocsComponentFactory.newEmptyWhenThenCell("    WHEN"));
        for (String s : drl.lhs) {
            table.addCell(DroolsDocsComponentFactory.newEmptyCell("        " + s.trim()));
        }
        table.addCell(DroolsDocsComponentFactory.newEmptyWhenThenCell("    THEN"));
        for (String s : drl.rhs) {
            table.addCell(DroolsDocsComponentFactory.newEmptyCell("        " + s.trim()));
        }
        return table;
    }

    public static Table createTable(String topic, Collection<String> items) throws BadElementException, DocumentException {
        Table metadata = DroolsDocsComponentFactory.createEmptyTable();
        Cell headerCell = DroolsDocsComponentFactory.newEmptyHeaderCell(topic);
        metadata.addCell(headerCell);
        for (String s : items) {
            metadata.addCell(DroolsDocsComponentFactory.newEmptyCell(s));
        }
        return metadata;
    }

    public static Table createMetaDataTable(Collection<String> metadatas) throws BadElementException, DocumentException {
        Table metadata = DroolsDocsComponentFactory.createEmptyTable();
        Cell headerCell = DroolsDocsComponentFactory.newEmptyHeaderCell("META DATA");
        metadata.addCell(headerCell);
        for (String s : metadatas) {
            metadata.addCell(DroolsDocsComponentFactory.newEmptyCell(INDENT + s));
        }
        return metadata;
    }

    public static com.lowagie.text.List createContents(List<DrlRuleData> rules) {
        com.lowagie.text.List index = new com.lowagie.text.List(true);
        for (DrlRuleData drlRuleData : rules) {
            Chunk chunk = new Chunk(drlRuleData.ruleName);
            ListItem listItem = new ListItem(chunk);
            index.add((Object)listItem);
        }
        return index;
    }

    private static Cell newEmptyWhenThenCell(String text) throws BadElementException {
        Cell c = new Cell((Element)new Phrase(text, BODY_TEXT));
        c.setBackgroundColor(Color.decode("#CCCCFF"));
        c.setLeading(10.0f);
        c.setBorder(1);
        return c;
    }

    private static Cell newEmptyHeaderCell(String text) throws BadElementException {
        Cell c = new Cell((Element)new Phrase(text, CATEGORIES_TEXT));
        c.setBackgroundColor(Color.decode("#CCCCFF"));
        c.setLeading(10.0f);
        c.setBorder(0);
        c.setBorderWidthBottom(1.0f);
        return c;
    }

    private static Cell newEmptyCell(String text) throws BadElementException {
        Cell c = new Cell((Element)new Phrase(text, BODY_TEXT));
        c.setLeading(10.0f);
        c.setBorder(0);
        c.setBorderWidthBottom(1.0f);
        return c;
    }

    public static HeaderFooter createFooter(String packageName) {
        HeaderFooter footer = new HeaderFooter(new Phrase(packageName + "-", HEADER_FOOTER_TEXT), true);
        footer.setBorder(1);
        footer.setAlignment(2);
        return footer;
    }

    public static void createRulePage(Document document, String packageName, DrlRuleData drlData) throws DocumentException {
        document.add((Element)new Paragraph(packageName, PACKAGE_NAME));
        document.add((Element)new Paragraph("Rule " + drlData.ruleName, CHAPTER_TITLE));
        int index = drlData.ruleName.lastIndexOf("extends");
        if (index > 0) {
            document.add((Element)new Paragraph("Extends:", BODY_TEXT));
            Paragraph ext = new Paragraph(drlData.ruleName.substring("extends".length() + index), BODY_TEXT);
            ext.setIndentationLeft(20.0f);
            document.add((Element)ext);
        }
        document.add((Element)DroolsDocsComponentFactory.createDescription(drlData.description));
        document.add((Element)DroolsDocsComponentFactory.createRuleTable(drlData));
        document.add((Element)DroolsDocsComponentFactory.createMetaDataTable(drlData.metadata));
        DroolsDocsComponentFactory.createOtherItems(document, drlData.otherInformation);
        document.newPage();
    }

    public static void createFirstPage(Document document, String currentDate, DrlPackageData packageData) throws DocumentException {
        Paragraph title = new Paragraph("\n\n\n\n\n" + packageData.packageName.toUpperCase(), RULE_PACKAGE_TITLE);
        title.setAlignment(1);
        document.add((Element)title);
        Paragraph date = new Paragraph("Documentation created: " + currentDate, BODY_TEXT);
        date.setAlignment(1);
        document.add((Element)date);
        document.add((Element)new Paragraph("\n\n\n\n\nDescription: " + packageData.description, BODY_TEXT));
        document.add((Element)DroolsDocsComponentFactory.createTable("Metadata: ", packageData.metadata));
        document.add((Element)DroolsDocsComponentFactory.createTable("Globals: ", packageData.globals));
        DroolsDocsComponentFactory.createOtherItems(document, packageData.otherInformation);
    }
}

