/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.ast.descr;

import java.util.Collections;
import java.util.List;
import org.drools.drl.ast.descr.RestrictionDescr;

public class EvaluatorBasedRestrictionDescr
extends RestrictionDescr {
    private static final long serialVersionUID = 150L;
    private String evaluator;
    private boolean negated;
    private List<String> parameters;

    public EvaluatorBasedRestrictionDescr() {
    }

    public EvaluatorBasedRestrictionDescr(String evaluator, boolean isNegated, String parameterText) {
        this(evaluator, isNegated, Collections.singletonList(parameterText));
    }

    public EvaluatorBasedRestrictionDescr(String evaluator, boolean isNegated, List<String> parameters) {
        this.evaluator = evaluator;
        this.negated = isNegated;
        this.parameters = parameters;
    }

    public String getEvaluator() {
        return this.evaluator;
    }

    @Override
    public boolean isNegated() {
        return this.negated;
    }

    public String getParameterText() {
        if (this.parameters != null) {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String param : this.parameters) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append(param);
            }
            return builder.toString();
        }
        return null;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public void setEvaluator(String evaluator) {
        this.evaluator = evaluator;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    public String toString() {
        return (this.isNegated() ? "not " : "") + this.getEvaluator() + (this.getParameterText() != null ? "[" + this.getParameterText() + "]" : "");
    }
}

