/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.ast.descr;

import java.util.List;
import org.drools.drl.ast.descr.BaseDescr;

public class OperatorDescr
extends BaseDescr {
    private static final long serialVersionUID = 520L;
    private String operator;
    private boolean negated;
    private List<String> parameters;
    private String alias;
    private String leftString;
    private String rightString;
    private boolean leftIsHandle;
    private boolean rightIsHandle;

    public OperatorDescr() {
    }

    public OperatorDescr(String operator, boolean negated, List<String> parameters) {
        this.setOperator(operator);
        this.negated = negated;
        this.parameters = parameters;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator.trim();
    }

    @Override
    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public String getParametersText() {
        if (this.parameters != null) {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String param : this.parameters) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append(param);
            }
            return builder.toString();
        }
        return null;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String toString() {
        return (this.negated ? "not " : "") + this.operator + (this.parameters != null ? this.parameters.toString() : "");
    }

    public void setLeftString(String left) {
        this.leftString = left;
    }

    public void setRightString(String right) {
        this.rightString = right;
    }

    public String getLeftString() {
        return this.leftString;
    }

    public String getRightString() {
        return this.rightString;
    }

    public boolean isLeftIsHandle() {
        return this.leftIsHandle;
    }

    public void setLeftIsHandle(boolean leftIsHandle) {
        this.leftIsHandle = leftIsHandle;
    }

    public boolean isRightIsHandle() {
        return this.rightIsHandle;
    }

    public void setRightIsHandle(boolean rightIsHandle) {
        this.rightIsHandle = rightIsHandle;
    }
}

