/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.definitions.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.base.RuleBase;
import org.drools.base.common.DroolsObjectInputStream;
import org.drools.base.common.DroolsObjectOutputStream;
import org.drools.base.definitions.InternalKnowledgePackage;
import org.drools.base.definitions.ProcessPackage;
import org.drools.base.definitions.ResourceTypePackageRegistry;
import org.drools.base.definitions.rule.impl.GlobalImpl;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.factmodel.ClassDefinition;
import org.drools.base.rule.DialectRuntimeData;
import org.drools.base.rule.DialectRuntimeRegistry;
import org.drools.base.rule.Function;
import org.drools.base.rule.ImportDeclaration;
import org.drools.base.rule.InvalidRulePackage;
import org.drools.base.rule.TypeDeclaration;
import org.drools.base.rule.WindowDeclaration;
import org.drools.base.ruleunit.RuleUnitDescriptionLoader;
import org.drools.base.util.CloneUtil;
import org.drools.util.ClassTypeResolver;
import org.drools.util.ClassUtils;
import org.drools.util.TypeResolver;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.rule.Global;
import org.kie.api.definition.rule.Query;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.FactType;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.prototype.Prototype;
import org.kie.api.runtime.rule.AccumulateFunction;

public class KnowledgePackageImpl
implements InternalKnowledgePackage,
Externalizable {
    private static final long serialVersionUID = 510L;
    private static final String[] implicitImports = new String[]{"org.kie.api.definition.rule.*", "org.kie.api.definition.type.*", "org.drools.tms.beliefsystem.abductive.Abductive", "org.drools.tms.beliefsystem.abductive.Abducible"};
    protected String name;
    protected Map<String, RuleImpl> rules = new LinkedHashMap<String, RuleImpl>();
    protected Map<String, ImportDeclaration> imports = new HashMap<String, ImportDeclaration>();
    protected Map<String, Function> functions;
    protected Map<String, AccumulateFunction> accumulateFunctions;
    protected Set<String> staticImports;
    protected Map<String, Type> globals;
    protected Map<String, Prototype> prototypes;
    protected DialectRuntimeRegistry dialectRuntimeRegistry;
    protected Map<String, TypeDeclaration> typeDeclarations = new ConcurrentHashMap<String, TypeDeclaration>();
    protected Set<String> entryPointsIds;
    protected Map<String, WindowDeclaration> windowDeclarations;
    protected ResourceTypePackageRegistry resourceTypePackages;
    protected Map<String, Object> cloningResources = new HashMap<String, Object>();
    protected boolean valid = true;
    protected boolean needStreamMode = false;
    private String errorSummary;
    private transient TypeResolver typeResolver;
    private transient RuleUnitDescriptionLoader ruleUnitDescriptionLoader;
    private transient AtomicBoolean inUse = new AtomicBoolean(false);

    public KnowledgePackageImpl() {
        this(null);
    }

    public KnowledgePackageImpl(String name) {
        this.name = name;
        this.accumulateFunctions = Collections.emptyMap();
        this.staticImports = Collections.emptySet();
        this.globals = Collections.emptyMap();
        this.prototypes = Collections.emptyMap();
        this.functions = Collections.emptyMap();
        this.dialectRuntimeRegistry = new DialectRuntimeRegistry();
        this.entryPointsIds = Collections.emptySet();
        this.windowDeclarations = Collections.emptyMap();
        this.resourceTypePackages = new ResourceTypePackageRegistry();
    }

    @Override
    public ResourceTypePackageRegistry getResourceTypePackages() {
        return this.resourceTypePackages;
    }

    @Override
    public Collection<Rule> getRules() {
        return Collections.unmodifiableCollection(this.rules.values());
    }

    public Function getFunction(String name) {
        return this.functions.getOrDefault(name, null);
    }

    @Override
    public Collection<Process> getProcesses() {
        if (this.getRuleFlows().isEmpty()) {
            return Collections.emptyList();
        }
        Collection<Process> processes = this.getRuleFlows().values();
        ArrayList<Process> list = new ArrayList<Process>(processes.size());
        list.addAll(processes);
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public Collection<FactType> getFactTypes() {
        if (this.typeDeclarations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ClassDefinition> list = new ArrayList<ClassDefinition>();
        for (TypeDeclaration typeDeclaration : this.typeDeclarations.values()) {
            list.add(typeDeclaration.getTypeClassDef());
        }
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public Collection<Query> getQueries() {
        ArrayList<RuleImpl> list = new ArrayList<RuleImpl>(this.rules.size());
        for (RuleImpl rule : this.rules.values()) {
            if (!rule.isQuery()) continue;
            list.add(rule);
        }
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public Collection<String> getFunctionNames() {
        return Collections.unmodifiableCollection(this.functions.keySet());
    }

    @Override
    public Collection<Global> getGlobalVariables() {
        ArrayList<GlobalImpl> list = new ArrayList<GlobalImpl>(this.getGlobals().size());
        for (Map.Entry<String, Type> global : this.getGlobals().entrySet()) {
            list.add(new GlobalImpl(global.getKey(), global.getValue().getTypeName()));
        }
        return Collections.unmodifiableCollection(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput stream) throws IOException {
        ObjectOutput out;
        ByteArrayOutputStream bytes = null;
        if (stream instanceof DroolsObjectOutputStream) {
            out = stream;
        } else {
            bytes = new ByteArrayOutputStream();
            out = new DroolsObjectOutputStream(bytes);
        }
        try {
            out.writeObject(this.name);
            out.writeObject(this.dialectRuntimeRegistry);
            out.writeObject(this.typeDeclarations);
            out.writeObject(this.imports);
            out.writeObject(this.staticImports);
            out.writeObject(this.functions);
            out.writeObject(this.accumulateFunctions);
            out.writeObject(this.prototypes);
            out.writeObject(this.globals);
            out.writeBoolean(this.valid);
            out.writeBoolean(this.needStreamMode);
            out.writeObject(this.rules);
            out.writeObject(this.entryPointsIds);
            out.writeObject(this.windowDeclarations);
            out.writeObject(this.resourceTypePackages);
        }
        finally {
            if (bytes != null) {
                bytes.flush();
                bytes.close();
                stream.writeObject(bytes.toByteArray());
            }
        }
    }

    @Override
    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        boolean isDroolsStream = stream instanceof DroolsObjectInputStream;
        DroolsObjectInputStream in = isDroolsStream ? (DroolsObjectInputStream)stream : new DroolsObjectInputStream(new ByteArrayInputStream((byte[])stream.readObject()));
        this.name = (String)in.readObject();
        this.dialectRuntimeRegistry = (DialectRuntimeRegistry)in.readObject();
        this.typeDeclarations = (Map)in.readObject();
        this.imports = (Map)in.readObject();
        this.staticImports = (Set)in.readObject();
        this.functions = (Map)in.readObject();
        this.accumulateFunctions = (Map)in.readObject();
        this.prototypes = (Map)in.readObject();
        this.globals = (Map)in.readObject();
        this.valid = in.readBoolean();
        this.needStreamMode = in.readBoolean();
        this.rules = (Map)in.readObject();
        this.entryPointsIds = (Set)in.readObject();
        this.windowDeclarations = (Map)in.readObject();
        this.resourceTypePackages = (ResourceTypePackageRegistry)in.readObject();
        if (!isDroolsStream) {
            in.close();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ClassLoader getPackageClassLoader() {
        DialectRuntimeData javaRuntime = this.getDialectRuntimeRegistry().getDialectData("java");
        return javaRuntime.getClassLoader();
    }

    @Override
    public DialectRuntimeRegistry getDialectRuntimeRegistry() {
        return this.dialectRuntimeRegistry;
    }

    @Override
    public void addImport(ImportDeclaration importDecl) {
        this.imports.put(importDecl.getTarget(), importDecl);
        if (this.typeResolver != null) {
            this.typeResolver.addImport(importDecl.getTarget());
        }
    }

    @Override
    public Map<String, ImportDeclaration> getImports() {
        return this.imports;
    }

    @Override
    public void addTypeDeclaration(TypeDeclaration typeDecl) {
        this.typeDeclarations.put(typeDecl.getTypeName(), typeDecl);
    }

    @Override
    public void removeTypeDeclaration(String type) {
        this.typeDeclarations.remove(type);
    }

    @Override
    public Map<String, TypeDeclaration> getTypeDeclarations() {
        return this.typeDeclarations;
    }

    @Override
    public TypeDeclaration getTypeDeclaration(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        TypeDeclaration typeDeclaration = this.getExactTypeDeclaration(clazz);
        if (typeDeclaration == null) {
            for (TypeDeclaration type : this.typeDeclarations.values()) {
                if (!type.isValid() || !type.matches(clazz)) continue;
                typeDeclaration = type;
                break;
            }
        }
        return typeDeclaration;
    }

    public TypeDeclaration getExactTypeDeclaration(Class<?> clazz) {
        return this.getTypeDeclaration(ClassUtils.getSimpleName(clazz));
    }

    @Override
    public TypeDeclaration getTypeDeclaration(String type) {
        return this.typeDeclarations.get(type);
    }

    @Override
    public void addStaticImport(String functionImport) {
        if (this.staticImports == Collections.EMPTY_SET) {
            this.staticImports = new HashSet<String>(2);
        }
        this.staticImports.add(functionImport);
    }

    @Override
    public void addFunction(Function function) {
        if (this.functions == Collections.EMPTY_MAP) {
            this.functions = new HashMap<String, Function>(1);
        }
        this.functions.put(function.getName(), function);
        this.dialectRuntimeRegistry.getDialectData(function.getDialect()).setDirty(true);
    }

    @Override
    public Map<String, Function> getFunctions() {
        return this.functions;
    }

    @Override
    public void addAccumulateFunction(String name, AccumulateFunction function) {
        if (this.accumulateFunctions == Collections.EMPTY_MAP) {
            this.accumulateFunctions = new HashMap<String, AccumulateFunction>(1);
        }
        this.accumulateFunctions.put(name, function);
    }

    @Override
    public Map<String, AccumulateFunction> getAccumulateFunctions() {
        return this.accumulateFunctions;
    }

    public void removeFunctionImport(String functionImport) {
        this.staticImports.remove(functionImport);
    }

    @Override
    public Set<String> getStaticImports() {
        return this.staticImports;
    }

    @Override
    public void addGlobal(String identifier, Type type) {
        if (this.globals == Collections.EMPTY_MAP) {
            this.globals = new HashMap<String, Type>(1);
        }
        this.globals.put(identifier, type);
    }

    @Override
    public void removeGlobal(String identifier) {
        this.globals.remove(identifier);
    }

    @Override
    public Map<String, Type> getGlobals() {
        return this.globals;
    }

    @Override
    public void removeFunction(String functionName) {
        Function function = this.functions.remove(functionName);
        if (function != null) {
            this.dialectRuntimeRegistry.removeFunction(this, function);
        }
    }

    @Override
    public Prototype getPrototype(String name) {
        return this.prototypes.get(name);
    }

    @Override
    public void addPrototype(Prototype prototype) {
        if (this.prototypes == Collections.EMPTY_MAP) {
            this.prototypes = new HashMap<String, Prototype>(1);
        }
        this.prototypes.put(prototype.getName(), prototype);
    }

    @Override
    public void addRule(RuleImpl rule) {
        this.rules.put(rule.getName(), rule);
    }

    @Override
    public void addProcess(Process process) {
        ResourceTypePackageRegistry rtps = this.getResourceTypePackages();
        ProcessPackage rtp = ProcessPackage.getOrCreate(rtps);
        rtp.add(process);
    }

    @Override
    public Map<String, Process> getRuleFlows() {
        ProcessPackage rtp = (ProcessPackage)this.getResourceTypePackages().get(ResourceType.BPMN2);
        return rtp == null ? Collections.emptyMap() : rtp.getRuleFlows();
    }

    @Override
    public void removeRuleFlow(String id) {
        ProcessPackage rtp = (ProcessPackage)this.getResourceTypePackages().get(ResourceType.BPMN2);
        if (rtp == null || rtp.lookup(id) == null) {
            throw new IllegalArgumentException("The rule flow with id [" + id + "] is not part of this package.");
        }
        rtp.remove(id);
    }

    @Override
    public void removeRule(RuleImpl rule) {
        this.rules.remove(rule.getName());
        this.dialectRuntimeRegistry.removeRule(this, rule);
    }

    @Override
    public RuleImpl getRule(String name) {
        return this.rules.get(name);
    }

    public String toString() {
        return "[Package name=" + this.name + "]";
    }

    @Override
    public void setError(String summary) {
        this.errorSummary = summary;
        this.valid = false;
    }

    @Override
    public void resetErrors() {
        this.errorSummary = "";
        this.valid = true;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void checkValidity() {
        if (!this.isValid()) {
            throw new InvalidRulePackage(this.getErrorSummary());
        }
    }

    public String getErrorSummary() {
        return this.errorSummary;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KnowledgePackageImpl)) {
            return false;
        }
        KnowledgePackageImpl other = (KnowledgePackageImpl)object;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void clear() {
        this.rules.clear();
        this.dialectRuntimeRegistry.clear();
        this.imports.clear();
        this.functions.clear();
        this.accumulateFunctions.clear();
        this.staticImports.clear();
        this.globals.clear();
        this.prototypes.clear();
        this.typeDeclarations.clear();
        this.windowDeclarations.clear();
    }

    @Override
    public FactType getFactType(String typeName) {
        if (typeName == null || this.name != null && !typeName.startsWith(this.name + ".")) {
            return null;
        }
        String key = this.name == null ? typeName : typeName.substring(this.name.length() + 1);
        TypeDeclaration decl = this.typeDeclarations.get(key);
        if (decl == null) {
            return null;
        }
        if (decl.isDefinition() || decl.isGeneratedFact()) {
            return decl.getTypeClassDef();
        }
        throw new UnsupportedOperationException("KieBase.getFactType should only be used to retrieve declared beans. Class " + typeName + " exists outside DRL ");
    }

    @Override
    public void wireTypeDeclarations() {
        for (TypeDeclaration typeDeclaration : this.typeDeclarations.values()) {
            Class<?> typeClass = null;
            try {
                typeClass = typeDeclaration.getTypeClass();
                if (typeClass == null && typeClass.isPrimitive()) continue;
                Class<?> cls = this.getPackageClassLoader().loadClass(typeClass.getName());
                typeDeclaration.setTypeClass(cls);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to load typeClass '" + typeClass.getName() + "'");
            }
        }
    }

    @Override
    public Set<String> getEntryPointIds() {
        return this.entryPointsIds;
    }

    @Override
    public void addEntryPointId(String id) {
        if (this.entryPointsIds == Collections.EMPTY_SET) {
            this.entryPointsIds = new HashSet<String>();
        }
        this.entryPointsIds.add(id);
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        if (this.typeResolver != null && this.typeResolver.getClassLoader() == classLoader) {
            return;
        }
        this.typeResolver = new ClassTypeResolver(new HashSet<String>(this.getImports().keySet()), classLoader, this.getName());
        this.typeResolver.addImport(this.getName() + ".*");
        for (String implicitImport : this.getImplicitImports()) {
            this.typeResolver.addImplicitImport(implicitImport);
        }
        this.ruleUnitDescriptionLoader = new RuleUnitDescriptionLoader(this);
    }

    protected String[] getImplicitImports() {
        return implicitImports;
    }

    @Override
    public RuleUnitDescriptionLoader getRuleUnitDescriptionLoader() {
        return this.ruleUnitDescriptionLoader;
    }

    @Override
    public void addWindowDeclaration(WindowDeclaration window) {
        if (this.windowDeclarations == Collections.EMPTY_MAP) {
            this.windowDeclarations = new HashMap<String, WindowDeclaration>();
        }
        this.windowDeclarations.put(window.getName(), window);
    }

    @Override
    public Map<String, WindowDeclaration> getWindowDeclarations() {
        return this.windowDeclarations;
    }

    @Override
    public boolean removeObjectsGeneratedFromResource(Resource resource) {
        List<RuleImpl> rulesToBeRemoved = this.removeRulesGeneratedFromResource(resource);
        List<TypeDeclaration> typesToBeRemoved = this.removeTypesGeneratedFromResource(resource);
        List<Function> functionsToBeRemoved = this.removeFunctionsGeneratedFromResource(resource);
        boolean resourceTypePackageSomethingRemoved = this.removeFromResourceTypePackageGeneratedFromResource(resource);
        return !rulesToBeRemoved.isEmpty() || !typesToBeRemoved.isEmpty() || !functionsToBeRemoved.isEmpty() || resourceTypePackageSomethingRemoved;
    }

    @Override
    public boolean removeFromResourceTypePackageGeneratedFromResource(Resource resource) {
        return this.resourceTypePackages.remove(resource);
    }

    @Override
    public List<TypeDeclaration> removeTypesGeneratedFromResource(Resource resource) {
        List<TypeDeclaration> typesToBeRemoved = this.getTypesGeneratedFromResource(resource);
        if (!typesToBeRemoved.isEmpty()) {
            DialectRuntimeData dialect = this.getDialectRuntimeRegistry().getDialectData("java");
            for (TypeDeclaration type : typesToBeRemoved) {
                if (type.getTypeClassName() != null) {
                    this.removeTypeFromStore(type);
                    dialect.remove(type.getTypeClassName());
                    if (this.typeResolver != null) {
                        this.typeResolver.registerClass(type.getTypeClassName(), null);
                    }
                }
                this.removeTypeDeclaration(type.getTypeName());
            }
            dialect.reload();
        }
        return typesToBeRemoved;
    }

    protected void removeTypeFromStore(TypeDeclaration type) {
    }

    @Override
    public List<RuleImpl> removeRulesGeneratedFromResource(Resource resource) {
        List<RuleImpl> rulesToBeRemoved = this.getRulesGeneratedFromResource(resource);
        for (RuleImpl rule : rulesToBeRemoved) {
            this.removeRule(rule);
        }
        return rulesToBeRemoved;
    }

    @Override
    public List<RuleImpl> getRulesGeneratedFromResource(Resource resource) {
        ArrayList<RuleImpl> rulesFromResource = new ArrayList<RuleImpl>();
        for (RuleImpl rule : this.rules.values()) {
            if (!resource.equals(rule.getResource())) continue;
            rulesFromResource.add(rule);
        }
        return rulesFromResource;
    }

    private List<TypeDeclaration> getTypesGeneratedFromResource(Resource resource) {
        ArrayList<TypeDeclaration> typesFromResource = new ArrayList<TypeDeclaration>();
        for (TypeDeclaration type : this.typeDeclarations.values()) {
            if (!resource.equals(type.getResource())) continue;
            typesFromResource.add(type);
        }
        return typesFromResource;
    }

    @Override
    public List<Function> removeFunctionsGeneratedFromResource(Resource resource) {
        List<Function> functionsToBeRemoved = this.getFunctionsGeneratedFromResource(resource);
        for (Function function : functionsToBeRemoved) {
            this.removeFunction(function.getName());
        }
        return functionsToBeRemoved;
    }

    private List<Function> getFunctionsGeneratedFromResource(Resource resource) {
        ArrayList<Function> functionsFromResource = new ArrayList<Function>();
        for (Function function : this.functions.values()) {
            if (!resource.equals(function.getResource())) continue;
            functionsFromResource.add(function);
        }
        return functionsFromResource;
    }

    @Override
    public List<Process> removeProcessesGeneratedFromResource(Resource resource) {
        List<Process> processesToBeRemoved = this.getProcessesGeneratedFromResource(resource);
        for (Process process : processesToBeRemoved) {
            this.removeProcess(process);
        }
        return processesToBeRemoved;
    }

    private void removeProcess(Process process) {
        ProcessPackage rtp = (ProcessPackage)this.getResourceTypePackages().get(ResourceType.BPMN2);
        if (rtp != null) {
            rtp.remove(process.getId());
        }
    }

    private List<Process> getProcessesGeneratedFromResource(Resource resource) {
        ProcessPackage rtp = (ProcessPackage)this.getResourceTypePackages().get(ResourceType.BPMN2);
        if (rtp == null) {
            return Collections.emptyList();
        }
        ArrayList<Process> processesFromResource = new ArrayList<Process>();
        for (Process process : rtp) {
            if (!resource.equals(process.getResource())) continue;
            processesFromResource.add(process);
        }
        return processesFromResource;
    }

    public boolean needsStreamMode() {
        return this.needStreamMode;
    }

    @Override
    public void setNeedStreamMode() {
        this.needStreamMode = true;
    }

    @Override
    public KnowledgePackageImpl deepCloneIfAlreadyInUse(ClassLoader classLoader) {
        if (this.inUse.compareAndSet(false, true)) {
            return this;
        }
        if (classLoader instanceof ProjectClassLoader) {
            DialectRuntimeData javaDialectRuntimeData = this.dialectRuntimeRegistry.getDialectData("java");
            if (javaDialectRuntimeData == null) {
                return this;
            }
            ClassLoader originalClassLoader = javaDialectRuntimeData.getRootClassLoader();
            if (classLoader == originalClassLoader) {
                return this;
            }
            if (originalClassLoader instanceof ProjectClassLoader) {
                ProjectClassLoader ocl = (ProjectClassLoader)originalClassLoader;
                ocl.initFrom((ProjectClassLoader)originalClassLoader);
            }
        }
        KnowledgePackageImpl clonedPkg = CloneUtil.deepClone(this, classLoader, this.cloningResources);
        clonedPkg.setClassLoader(classLoader);
        if (this.ruleUnitDescriptionLoader != null) {
            for (String ruleUnit : this.ruleUnitDescriptionLoader.getDescriptions().keySet()) {
                clonedPkg.getRuleUnitDescriptionLoader().getDescription(ruleUnit);
            }
        }
        return clonedPkg;
    }

    @Override
    public void mergeTraitRegistry(RuleBase knowledgeBase) {
    }

    @Override
    public void addCloningResource(String key, Object resource) {
        this.cloningResources.put(key, resource);
    }
}

