/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.rule.accessor;

import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.drools.base.base.ClassObjectType;
import org.drools.base.definitions.InternalKnowledgePackage;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.GroupElement;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.RuleConditionElement;
import org.drools.base.rule.accessor.GlobalExtractor;
import org.drools.util.ClassUtils;
import org.kie.internal.ruleunit.RuleUnitDescription;

public class DeclarationScopeResolver {
    private final Deque<RuleConditionElement> buildList;
    private final Map<String, Type> globalMap;
    private final InternalKnowledgePackage pkg;
    private RuleImpl rule;
    private Optional<RuleUnitDescription> ruleUnitDescr = Optional.empty();

    protected DeclarationScopeResolver() {
        this(new HashMap<String, Type>(), new ArrayDeque<RuleConditionElement>());
    }

    public DeclarationScopeResolver(Map<String, Type> globalMap, Deque<RuleConditionElement> buildList) {
        this(globalMap, buildList, null);
    }

    public DeclarationScopeResolver(Map<String, Type> globalMap, InternalKnowledgePackage pkg) {
        this(globalMap, new ArrayDeque<RuleConditionElement>(), pkg);
    }

    private DeclarationScopeResolver(Map<String, Type> globalMap, Deque<RuleConditionElement> buildList, InternalKnowledgePackage pkg) {
        this.globalMap = globalMap;
        this.buildList = buildList;
        this.pkg = pkg;
    }

    public void setRule(RuleImpl rule) {
        this.rule = rule;
        this.ruleUnitDescr = this.pkg.getRuleUnitDescriptionLoader().getDescription(rule);
    }

    public RuleConditionElement peekBuildStack() {
        return this.buildList.peek();
    }

    public RuleConditionElement popBuildStack() {
        return this.buildList.pop();
    }

    public void pushOnBuildStack(RuleConditionElement element) {
        this.buildList.push(element);
    }

    private Declaration getExtendedDeclaration(RuleImpl rule, String identifier) {
        Declaration declaration = rule.getLhs().resolveDeclaration(identifier);
        if (declaration != null) {
            return declaration;
        }
        return rule.getParent() == null ? null : this.getExtendedDeclaration(rule.getParent(), identifier);
    }

    private Map<String, Declaration> getAllExtendedDeclaration(RuleImpl rule, Map<String, Declaration> dec) {
        dec.putAll(rule.getLhs().getInnerDeclarations());
        if (null != rule.getParent()) {
            return this.getAllExtendedDeclaration(rule.getParent(), dec);
        }
        return dec;
    }

    public Declaration getDeclaration(String identifier) {
        Declaration parentDeclaration;
        Iterator<RuleConditionElement> iterator = this.buildList.descendingIterator();
        while (iterator.hasNext()) {
            Declaration declaration = iterator.next().resolveDeclaration(identifier);
            if (declaration == null) continue;
            return declaration;
        }
        if (this.rule != null && this.rule.getParent() != null && null != (parentDeclaration = this.getExtendedDeclaration(this.rule.getParent(), identifier))) {
            return parentDeclaration;
        }
        Type type = this.resolveVarType(identifier);
        if (type != null) {
            ClassObjectType classObjectType = new ClassObjectType(ClassUtils.rawType(type));
            Pattern dummy = new Pattern(0, classObjectType);
            GlobalExtractor globalExtractor = new GlobalExtractor(identifier, classObjectType);
            Declaration declaration = new Declaration(identifier, globalExtractor, dummy);
            if (this.pkg != null) {
                this.pkg.wireObjectType(classObjectType, dummy);
                this.pkg.wireObjectType(classObjectType, globalExtractor);
            }
            return declaration;
        }
        return null;
    }

    public Type resolveVarType(String identifier) {
        return this.ruleUnitDescr.flatMap(unit -> unit.getVarType(identifier)).orElseGet(() -> this.globalMap.get(identifier));
    }

    public String normalizeValueForUnit(String value) {
        return this.ruleUnitDescr.map(unit -> {
            int dotPos = value.indexOf(46);
            String firstPart = dotPos > 0 ? value.substring(0, dotPos) : value;
            return unit.hasVar(firstPart) ? "$$unit." + value : value;
        }).orElse(value);
    }

    public boolean hasDataSource(String name) {
        return this.ruleUnitDescr.map(descr -> descr.hasDataSource(name)).orElse(false);
    }

    public boolean available(RuleImpl rule, String name) {
        Declaration parentDeclaration;
        Iterator<RuleConditionElement> iterator = this.buildList.descendingIterator();
        while (iterator.hasNext()) {
            RuleConditionElement rce = iterator.next();
            Declaration declaration = rce.resolveDeclaration(name);
            if (declaration == null) continue;
            return true;
        }
        if (this.globalMap.containsKey(name)) {
            return true;
        }
        return rule != null && rule.getParent() != null && null != (parentDeclaration = this.getExtendedDeclaration(rule.getParent(), name));
    }

    public boolean isDuplicated(RuleImpl rule, String name, String type) {
        if (this.globalMap.containsKey(name)) {
            return true;
        }
        Iterator<RuleConditionElement> iterator = this.buildList.descendingIterator();
        while (iterator.hasNext()) {
            GroupElement ge;
            boolean inOr;
            RuleConditionElement rce = iterator.next();
            Declaration declaration = rce.resolveDeclaration(name);
            if (declaration == null) continue;
            boolean bl = inOr = rce instanceof GroupElement && (ge = (GroupElement)rce).isOr();
            if (!inOr || type == null) {
                return !inOr;
            }
            return !declaration.getDeclarationClass().getName().equals(type);
        }
        if (rule != null && rule.getParent() != null) {
            Declaration parentDeclaration = this.getExtendedDeclaration(rule.getParent(), name);
            return null != parentDeclaration;
        }
        return false;
    }

    public Map<String, Declaration> getDeclarations(RuleImpl rule) {
        return this.getDeclarations(rule, "default");
    }

    public Map<String, Declaration> getDeclarations(RuleImpl rule, String consequenceName) {
        HashMap<String, Declaration> declarations = new HashMap<String, Declaration>();
        for (RuleConditionElement aBuildList : this.buildList) {
            Map<String, Declaration> map;
            GroupElement ge;
            if (aBuildList instanceof GroupElement && (ge = (GroupElement)aBuildList).getType() == GroupElement.Type.OR) continue;
            if (aBuildList instanceof GroupElement) {
                GroupElement ge2 = (GroupElement)aBuildList;
                map = ge2.getInnerDeclarations(consequenceName);
            } else {
                map = aBuildList.getInnerDeclarations();
            }
            Map<String, Declaration> innerDeclarations = map;
            declarations.putAll(innerDeclarations);
        }
        if (null != rule.getParent()) {
            return this.getAllExtendedDeclaration(rule.getParent(), declarations);
        }
        return declarations;
    }

    public Map<String, Class<?>> getDeclarationClasses(RuleImpl rule) {
        return DeclarationScopeResolver.getDeclarationClasses(this.getDeclarations(rule));
    }

    public static Map<String, Class<?>> getDeclarationClasses(Map<String, Declaration> declarations) {
        HashMap classes = new HashMap();
        for (Map.Entry<String, Declaration> decl : declarations.entrySet()) {
            Class<?> declarationClass = decl.getValue().getDeclarationClass();
            if (declarationClass == null) continue;
            classes.put(decl.getKey(), declarationClass);
        }
        return classes;
    }

    public Pattern findPatternById(int id) {
        if (!this.buildList.isEmpty()) {
            return this.findPatternInNestedElements(id, this.buildList.peekFirst());
        }
        return null;
    }

    private Pattern findPatternInNestedElements(int id, RuleConditionElement rce) {
        for (RuleConditionElement ruleConditionElement : rce.getNestedElements()) {
            Pattern p;
            if (ruleConditionElement instanceof Pattern) {
                Pattern p2 = (Pattern)ruleConditionElement;
                if (p2.getPatternId() != id) continue;
                return p2;
            }
            if (ruleConditionElement.isPatternScopeDelimiter() || (p = this.findPatternInNestedElements(id, ruleConditionElement)) == null) continue;
            return p;
        }
        return null;
    }
}

