/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Optional;
import org.drools.base.base.ObjectType;
import org.drools.base.base.ValueResolver;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.ContextEntry;
import org.drools.base.rule.MutableTypeConstraint;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.constraint.BetaConstraint;
import org.drools.base.util.index.IndexUtil;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.BetaConstraints;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.util.index.IndexFactory;
import org.drools.util.bitmask.BitMask;
import org.kie.api.runtime.rule.FactHandle;

public class SingleBetaConstraints
implements BetaConstraints<ContextEntry> {
    private static final long serialVersionUID = 510L;
    protected BetaConstraint<ContextEntry> constraint;
    protected boolean indexed;
    protected transient boolean disableIndex;

    public SingleBetaConstraints() {
    }

    public SingleBetaConstraints(BetaConstraint[] constraint, RuleBaseConfiguration conf) {
        this(constraint[0], conf, false);
    }

    public SingleBetaConstraints(BetaConstraint constraint, RuleBaseConfiguration conf) {
        this(constraint, conf, false);
    }

    public SingleBetaConstraints(BetaConstraint constraint, RuleBaseConfiguration conf, boolean disableIndex) {
        this.constraint = constraint;
        this.disableIndex = disableIndex;
    }

    @Override
    public void init(BuildContext context, int betaNodeType) {
        RuleBaseConfiguration config = context.getRuleBase().getRuleBaseConfiguration();
        if (this.disableIndex || !config.isIndexLeftBetaMemory() && !config.isIndexRightBetaMemory()) {
            this.indexed = false;
        } else {
            this.initIndexes(config.getCompositeKeyDepth(), betaNodeType, config);
        }
    }

    @Override
    public void initIndexes(int depth, int betaNodeType, RuleBaseConfiguration config) {
        this.indexed = depth >= 1 && IndexUtil.isIndexableForNode(betaNodeType, this.constraint, config);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.constraint = (BetaConstraint)in.readObject();
        this.indexed = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.constraint);
        out.writeBoolean(this.indexed);
    }

    @Override
    public SingleBetaConstraints cloneIfInUse() {
        if (this.constraint instanceof MutableTypeConstraint && ((MutableTypeConstraint)this.constraint).setInUse()) {
            return this.clone();
        }
        return this;
    }

    public SingleBetaConstraints clone() {
        SingleBetaConstraints clone = new SingleBetaConstraints((BetaConstraint)this.constraint.cloneIfInUse(), null, this.disableIndex);
        clone.indexed = this.indexed;
        return clone;
    }

    @Override
    public ContextEntry createContext() {
        return this.constraint.createContext();
    }

    @Override
    public void updateFromTuple(ContextEntry context, ValueResolver valueResolver, Tuple tuple) {
        context.updateFromTuple(valueResolver, tuple);
    }

    @Override
    public void updateFromFactHandle(ContextEntry context, ValueResolver valueResolver, FactHandle handle) {
        context.updateFromFactHandle(valueResolver, handle);
    }

    @Override
    public boolean isAllowedCachedLeft(ContextEntry context, FactHandle handle) {
        return this.indexed || this.constraint.isAllowedCachedLeft(context, handle);
    }

    @Override
    public boolean isAllowedCachedRight(BaseTuple tuple, ContextEntry context) {
        return this.constraint.isAllowedCachedRight(tuple, context);
    }

    @Override
    public boolean isIndexed() {
        return this.indexed;
    }

    @Override
    public int getIndexCount() {
        return this.indexed ? 1 : 0;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public BetaMemory createBetaMemory(RuleBaseConfiguration config, int nodeType) {
        return IndexFactory.createBetaMemory(config, nodeType, this.constraint);
    }

    public int hashCode() {
        return this.constraint.hashCode();
    }

    public BetaConstraint getConstraint() {
        return this.constraint;
    }

    @Override
    public BetaConstraint[] getConstraints() {
        return new BetaConstraint[]{this.constraint};
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SingleBetaConstraints other = (SingleBetaConstraints)object;
        return this.constraint == other.constraint || this.constraint.equals(other.constraint);
    }

    @Override
    public void resetFactHandle(ContextEntry context) {
        context.resetFactHandle();
    }

    @Override
    public void resetTuple(ContextEntry context) {
        context.resetTuple();
    }

    @Override
    public BetaConstraints getOriginalConstraint() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitMask getListenedPropertyMask(Pattern pattern, ObjectType modifiedType, List<String> settableProperties) {
        return this.constraint.getListenedPropertyMask(Optional.of(pattern), modifiedType, settableProperties);
    }

    @Override
    public boolean isLeftUpdateOptimizationAllowed() {
        return true;
    }

    @Override
    public void registerEvaluationContext(BuildContext buildContext) {
        this.constraint.registerEvaluationContext(buildContext);
    }
}

