/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.base.reteoo.AccumulateContextEntry;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.Accumulate;
import org.drools.base.rule.constraint.AlphaNodeFieldConstraint;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.common.TupleSetsImpl;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.TupleFactory;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.FastIterator;

public class PhreakAccumulateNode {
    public void doNode(AccumulateNode accNode, LeftTupleSink sink, AccumulateNode.AccumulateMemory am, ReteEvaluator reteEvaluator, TupleSets srcLeftTuples, TupleSets trgLeftTuples, TupleSets stagedLeftTuples) {
        TupleImpl next;
        BetaMemory bm = am.getBetaMemory();
        TupleSets srcRightTuples = bm.getStagedRightTuples().takeAll();
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(accNode, am, reteEvaluator, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        TupleSetsImpl tempLeftTuples = new TupleSetsImpl();
        if (srcRightTuples.getDeleteFirst() != null) {
            this.doRightDeletes(accNode, am, reteEvaluator, srcRightTuples, tempLeftTuples);
        }
        if (srcRightTuples.getUpdateFirst() != null) {
            RuleNetworkEvaluator.doUpdatesReorderRightMemory(bm, srcRightTuples);
            this.doRightUpdates(accNode, am, reteEvaluator, srcRightTuples, tempLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            RuleNetworkEvaluator.doUpdatesReorderLeftMemory(bm, srcLeftTuples);
            this.doLeftUpdates(accNode, am, reteEvaluator, srcLeftTuples, tempLeftTuples);
        }
        if (!accNode.isRightInputIsRiaNode()) {
            if (srcRightTuples.getInsertFirst() != null) {
                this.doRightInserts(accNode, am, reteEvaluator, srcRightTuples, tempLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(accNode, am, reteEvaluator, srcLeftTuples, tempLeftTuples);
            }
        } else {
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(accNode, am, reteEvaluator, srcLeftTuples, tempLeftTuples);
            }
            if (srcRightTuples.getInsertFirst() != null) {
                this.doRightInserts(accNode, am, reteEvaluator, srcRightTuples, tempLeftTuples);
            }
        }
        Accumulate accumulate = accNode.getAccumulate();
        TupleImpl leftTuple = tempLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            this.evaluateResultConstraints(accNode, sink, accumulate, leftTuple, leftTuple.getPropagationContext(), reteEvaluator, am, (AccumulateNode.BaseAccumulation)leftTuple.getContextObject(), trgLeftTuples, stagedLeftTuples);
            leftTuple.clearStaged();
            leftTuple = next;
        }
        leftTuple = tempLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            this.evaluateResultConstraints(accNode, sink, accumulate, leftTuple, leftTuple.getPropagationContext(), reteEvaluator, am, (AccumulateNode.BaseAccumulation)leftTuple.getContextObject(), trgLeftTuples, stagedLeftTuples);
            leftTuple.clearStaged();
            leftTuple = next;
        }
        srcRightTuples.resetAll();
        srcLeftTuples.resetAll();
    }

    private void doLeftInserts(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, ReteEvaluator reteEvaluator, TupleSets srcLeftTuples, TupleSets trgLeftTuples) {
        Accumulate accumulate = accNode.getAccumulate();
        BetaMemory bm = am.getBetaMemory();
        TupleMemory ltm = bm.getLeftTupleMemory();
        TupleMemory rtm = bm.getRightTupleMemory();
        Object contextEntry = bm.getContext();
        BetaConstraints constraints = accNode.getRawConstraints();
        boolean leftTupleMemoryEnabled = accNode.isLeftTupleMemoryEnabled();
        TupleImpl leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            boolean useLeftMemory;
            TupleImpl next = leftTuple.getStagedNext();
            boolean bl = useLeftMemory = leftTupleMemoryEnabled || RuleNetworkEvaluator.useLeftMemory(accNode, leftTuple);
            if (useLeftMemory) {
                ltm.add(leftTuple);
            }
            AccumulateNode.BaseAccumulation accresult = this.initAccumulationContext(am, reteEvaluator, accumulate, leftTuple);
            if (accNode.isRightInputIsRiaNode()) {
                leftTuple.clearStaged();
                trgLeftTuples.addInsert(leftTuple);
                leftTuple = next;
                continue;
            }
            constraints.updateFromTuple(contextEntry, reteEvaluator, leftTuple);
            FastIterator<TupleImpl> rightIt = accNode.getRightIterator(rtm);
            RightTuple rightTuple = accNode.getFirstRightTuple(leftTuple, rtm, rightIt);
            while (rightTuple != null) {
                RightTuple nextRightTuple = (RightTuple)rightIt.next(rightTuple);
                if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandleForEvaluation())) {
                    this.addMatch(accNode, accumulate, leftTuple, rightTuple, null, null, reteEvaluator, am, accresult, useLeftMemory, true);
                }
                rightTuple = nextRightTuple;
            }
            leftTuple.clearStaged();
            trgLeftTuples.addInsert(leftTuple);
            constraints.resetTuple(contextEntry);
            leftTuple = next;
        }
        constraints.resetTuple(contextEntry);
    }

    AccumulateNode.BaseAccumulation initAccumulationContext(AccumulateNode.AccumulateMemory am, ReteEvaluator reteEvaluator, Accumulate accumulate, TupleImpl leftTuple) {
        AccumulateNode.AccumulateContext accContext = new AccumulateNode.AccumulateContext();
        leftTuple.setContextObject(accContext);
        PhreakAccumulateNode.initContext(am.workingMemoryContext, reteEvaluator, accumulate, leftTuple, accContext);
        return accContext;
    }

    public static void initContext(Object workingMemoryContext, ReteEvaluator reteEvaluator, Accumulate accumulate, BaseTuple leftTuple, AccumulateContextEntry accContext) {
        Object funcContext = accumulate.createFunctionContext();
        funcContext = accumulate.init(workingMemoryContext, accContext, funcContext, leftTuple, reteEvaluator);
        accContext.setFunctionContext(funcContext);
    }

    private void doRightInserts(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, ReteEvaluator reteEvaluator, TupleSets srcRightTuples, TupleSets trgLeftTuples) {
        Accumulate accumulate = accNode.getAccumulate();
        BetaMemory bm = am.getBetaMemory();
        TupleMemory ltm = bm.getLeftTupleMemory();
        TupleMemory rtm = bm.getRightTupleMemory();
        Object contextEntry = bm.getContext();
        BetaConstraints constraints = accNode.getRawConstraints();
        if (srcRightTuples.getInsertSize() > 32 && rtm instanceof AbstractHashTable) {
            ((AbstractHashTable)((Object)rtm)).ensureCapacity(srcRightTuples.getInsertSize());
        }
        boolean tupleMemoryEnabled = accNode.isLeftTupleMemoryEnabled();
        TupleImpl rightTuple = srcRightTuples.getInsertFirst();
        while (rightTuple != null) {
            boolean useTupleMemory;
            TupleImpl next = rightTuple.getStagedNext();
            boolean bl = useTupleMemory = tupleMemoryEnabled || RuleNetworkEvaluator.useLeftMemory(accNode, rightTuple);
            if (useTupleMemory || !accNode.isRightInputIsRiaNode()) {
                rtm.add(rightTuple);
            }
            if (accNode.isRightInputIsRiaNode() || ltm != null && ltm.size() > 0) {
                constraints.updateFromFactHandle(contextEntry, reteEvaluator, rightTuple.getFactHandleForEvaluation());
                FastIterator<TupleImpl> leftIt = accNode.getLeftIterator(ltm);
                TupleImpl leftTuple = accNode.getFirstLeftTuple(rightTuple, ltm, leftIt);
                while (leftTuple != null) {
                    if (constraints.isAllowedCachedRight(leftTuple, contextEntry)) {
                        AccumulateNode.BaseAccumulation accctx = (AccumulateNode.BaseAccumulation)leftTuple.getContextObject();
                        this.addMatch(accNode, accumulate, leftTuple, rightTuple, null, null, reteEvaluator, am, accctx, true, false);
                        if (leftTuple.getStagedType() == 0) {
                            trgLeftTuples.addUpdate(leftTuple);
                        }
                    }
                    leftTuple = (LeftTuple)leftIt.next(leftTuple);
                }
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
        constraints.resetFactHandle(contextEntry);
    }

    private void doLeftUpdates(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, ReteEvaluator reteEvaluator, TupleSets srcLeftTuples, TupleSets trgLeftTuples) {
        BetaMemory bm = am.getBetaMemory();
        TupleMemory rtm = bm.getRightTupleMemory();
        Accumulate accumulate = accNode.getAccumulate();
        Object contextEntry = bm.getContext();
        BetaConstraints constraints = accNode.getRawConstraints();
        TupleImpl leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            TupleImpl next = leftTuple.getStagedNext();
            AccumulateNode.BaseAccumulation accctx = (AccumulateNode.BaseAccumulation)leftTuple.getContextObject();
            if (accNode.isRightInputIsRiaNode()) {
                leftTuple.clearStaged();
                trgLeftTuples.addUpdate(leftTuple);
                leftTuple = next;
                continue;
            }
            constraints.updateFromTuple(contextEntry, reteEvaluator, leftTuple);
            FastIterator<TupleImpl> rightIt = accNode.getRightIterator(rtm);
            RightTuple rightTuple = accNode.getFirstRightTuple(leftTuple, rtm, rightIt);
            TupleImpl childLeftTuple = leftTuple.getFirstChild();
            if (childLeftTuple != null && rtm.isIndexed() && !rightIt.isFullIterator() && (rightTuple == null || rightTuple.getMemory() != childLeftTuple.getRightParent().getMemory())) {
                PhreakAccumulateNode.removePreviousMatchesForLeftTuple(accumulate, leftTuple, reteEvaluator, am, accctx, true);
                childLeftTuple = null;
            }
            if (rightTuple != null) {
                this.doLeftUpdatesProcessChildren(accNode, am, reteEvaluator, bm, accumulate, constraints, rightIt, leftTuple, accctx, rightTuple, childLeftTuple);
            }
            leftTuple.clearStaged();
            trgLeftTuples.addUpdate(leftTuple);
            leftTuple = next;
        }
        constraints.resetTuple(contextEntry);
    }

    private void doLeftUpdatesProcessChildren(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, ReteEvaluator reteEvaluator, BetaMemory bm, Accumulate accumulate, BetaConstraints constraints, FastIterator<TupleImpl> rightIt, TupleImpl leftTuple, AccumulateNode.BaseAccumulation accctx, TupleImpl rightTuple, TupleImpl match) {
        if (match == null) {
            while (rightTuple != null) {
                if (constraints.isAllowedCachedLeft(bm.getContext(), rightTuple.getFactHandleForEvaluation())) {
                    this.addMatch(accNode, accumulate, leftTuple, rightTuple, null, null, reteEvaluator, am, accctx, true, true);
                }
                rightTuple = rightIt.next(rightTuple);
            }
        } else {
            boolean isDirty = false;
            while (rightTuple != null) {
                if (constraints.isAllowedCachedLeft(bm.getContext(), rightTuple.getFactHandleForEvaluation())) {
                    if (match == null || match.getRightParent() != rightTuple) {
                        this.addMatch(accNode, accumulate, leftTuple, rightTuple, match, null, reteEvaluator, am, accctx, true, true);
                    } else {
                        temp = match.getHandleNext();
                        match.reAddRight();
                        match = temp;
                        isDirty = accumulate.hasRequiredDeclarations();
                    }
                } else if (match != null && match.getRightParent() == rightTuple) {
                    temp = match.getHandleNext();
                    boolean reversed = this.removeMatch(accNode, accumulate, rightTuple, match, reteEvaluator, am, accctx, false);
                    match = temp;
                    isDirty = !reversed;
                }
                rightTuple = rightIt.next(rightTuple);
            }
            if (isDirty) {
                this.reaccumulateForLeftTuple(accNode, accumulate, leftTuple, null, null, reteEvaluator, am, accctx, true);
            }
        }
    }

    private void doRightUpdates(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, ReteEvaluator reteEvaluator, TupleSets srcRightTuples, TupleSets trgLeftTuples) {
        BetaMemory bm = am.getBetaMemory();
        TupleMemory ltm = bm.getLeftTupleMemory();
        Object contextEntry = bm.getContext();
        BetaConstraints constraints = accNode.getRawConstraints();
        Accumulate accumulate = accNode.getAccumulate();
        TupleImpl rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            TupleImpl next = rightTuple.getStagedNext();
            if (ltm != null && ltm.size() > 0) {
                TupleImpl childLeftTuple = rightTuple.getFirstChild();
                FastIterator<TupleImpl> leftIt = accNode.getLeftIterator(ltm);
                TupleImpl leftTuple = accNode.getFirstLeftTuple(rightTuple, ltm, leftIt);
                constraints.updateFromFactHandle(contextEntry, reteEvaluator, rightTuple.getFactHandleForEvaluation());
                if (childLeftTuple != null && ltm.isIndexed() && !leftIt.isFullIterator() && (leftTuple == null || leftTuple.getMemory() != childLeftTuple.getLeftParent().getMemory())) {
                    this.removePreviousMatchesForRightTuple(accNode, accumulate, rightTuple, reteEvaluator, am, childLeftTuple, trgLeftTuples);
                    childLeftTuple = null;
                }
                if (leftTuple != null) {
                    this.doRightUpdatesProcessChildren(accNode, am, reteEvaluator, bm, constraints, accumulate, leftIt, rightTuple, childLeftTuple, leftTuple, trgLeftTuples);
                }
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
        constraints.resetFactHandle(contextEntry);
    }

    private void doRightUpdatesProcessChildren(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, ReteEvaluator reteEvaluator, BetaMemory bm, BetaConstraints constraints, Accumulate accumulate, FastIterator<TupleImpl> leftIt, TupleImpl rightTuple, TupleImpl childLeftTuple, TupleImpl leftTuple, TupleSets trgLeftTuples) {
        if (childLeftTuple == null) {
            while (leftTuple != null) {
                if (constraints.isAllowedCachedRight(leftTuple, bm.getContext())) {
                    if (leftTuple.getStagedType() == 0) {
                        trgLeftTuples.addUpdate(leftTuple);
                    }
                    AccumulateNode.BaseAccumulation accctx = (AccumulateNode.BaseAccumulation)leftTuple.getContextObject();
                    this.addMatch(accNode, accumulate, leftTuple, rightTuple, null, null, reteEvaluator, am, accctx, true, false);
                }
                leftTuple = leftIt.next(leftTuple);
            }
        } else {
            while (leftTuple != null) {
                if (constraints.isAllowedCachedRight(leftTuple, bm.getContext())) {
                    if (leftTuple.getStagedType() == 0) {
                        trgLeftTuples.addUpdate(leftTuple);
                    }
                    AccumulateNode.BaseAccumulation accctx = (AccumulateNode.BaseAccumulation)leftTuple.getContextObject();
                    if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                        TupleImpl temp = childLeftTuple.getRightParentNext();
                        childLeftTuple.reAddLeft();
                        this.removeMatch(accNode, accumulate, rightTuple, childLeftTuple, reteEvaluator, am, accctx, true);
                        childLeftTuple = temp;
                    }
                    this.addMatch(accNode, accumulate, leftTuple, rightTuple, null, childLeftTuple, reteEvaluator, am, accctx, true, false);
                } else if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                    if (leftTuple.getStagedType() == 0) {
                        trgLeftTuples.addUpdate(leftTuple);
                    }
                    TupleImpl temp = childLeftTuple.getRightParentNext();
                    AccumulateNode.BaseAccumulation accctx = (AccumulateNode.BaseAccumulation)leftTuple.getContextObject();
                    this.removeMatch(accNode, accumulate, rightTuple, childLeftTuple, reteEvaluator, am, accctx, true);
                    childLeftTuple = temp;
                }
                leftTuple = leftIt.next(leftTuple);
            }
        }
    }

    private void doLeftDeletes(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, ReteEvaluator reteEvaluator, TupleSets srcLeftTuples, TupleSets trgLeftTuples, TupleSets stagedLeftTuples) {
        BetaMemory bm = am.getBetaMemory();
        TupleMemory ltm = bm.getLeftTupleMemory();
        Accumulate accumulate = accNode.getAccumulate();
        TupleImpl leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            TupleImpl next = leftTuple.getStagedNext();
            if (leftTuple.getMemory() != null) {
                ltm.remove(leftTuple);
                AccumulateNode.BaseAccumulation accctx = (AccumulateNode.BaseAccumulation)leftTuple.getContextObject();
                leftTuple.setContextObject(null);
                PhreakAccumulateNode.removePreviousMatchesForLeftTuple(accumulate, leftTuple, reteEvaluator, am, accctx, false);
                this.propagateDelete(trgLeftTuples, stagedLeftTuples, accctx);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    protected void propagateDelete(TupleSets trgLeftTuples, TupleSets stagedLeftTuples, Object accPropCtx) {
        AccumulateContextEntry entry = (AccumulateContextEntry)accPropCtx;
        if (entry.isPropagated()) {
            RuleNetworkEvaluator.normalizeStagedTuples(stagedLeftTuples, (TupleImpl)entry.getResultLeftTuple());
            trgLeftTuples.addDelete((TupleImpl)entry.getResultLeftTuple());
        }
    }

    private void doRightDeletes(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, ReteEvaluator reteEvaluator, TupleSets srcRightTuples, TupleSets trgLeftTuples) {
        TupleMemory rtm = am.getBetaMemory().getRightTupleMemory();
        Accumulate accumulate = accNode.getAccumulate();
        TupleImpl rightTuple = srcRightTuples.getDeleteFirst();
        while (rightTuple != null) {
            TupleImpl next = rightTuple.getStagedNext();
            if (rightTuple.getMemory() != null) {
                rtm.remove(rightTuple);
                if (rightTuple.getFirstChild() != null) {
                    TupleImpl match = rightTuple.getFirstChild();
                    while (match != null) {
                        TupleImpl nextLeft = match.getRightParentNext();
                        TupleImpl leftTuple = match.getLeftParent();
                        AccumulateNode.BaseAccumulation accctx = (AccumulateNode.BaseAccumulation)leftTuple.getContextObject();
                        this.removeMatch(accNode, accumulate, rightTuple, match, reteEvaluator, am, accctx, true);
                        if (leftTuple.getStagedType() == 0) {
                            trgLeftTuples.addUpdate(leftTuple);
                        }
                        match = nextLeft;
                    }
                }
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
    }

    protected void evaluateResultConstraints(AccumulateNode accNode, LeftTupleSink sink, Accumulate accumulate, TupleImpl leftTuple, PropagationContext context, ReteEvaluator reteEvaluator, AccumulateNode.AccumulateMemory memory, AccumulateNode.BaseAccumulation accctx, TupleSets trgLeftTuples, TupleSets stagedLeftTuples) {
        PropagationContext propagationContext = accctx.getPropagationContext();
        accctx.setPropagationContext(null);
        Object result = accumulate.getResult(memory.workingMemoryContext, accctx, leftTuple, reteEvaluator);
        this.propagateResult(accNode, sink, leftTuple, context, reteEvaluator, memory, trgLeftTuples, stagedLeftTuples, null, result, (AccumulateContextEntry)((Object)accctx), propagationContext, reteEvaluator.getRuleSessionConfiguration().isAccumulateNullPropagation());
    }

    protected final void propagateResult(AccumulateNode accNode, LeftTupleSink sink, TupleImpl leftTuple, PropagationContext context, ReteEvaluator reteEvaluator, AccumulateNode.AccumulateMemory memory, TupleSets trgLeftTuples, TupleSets stagedLeftTuples, Object key, Object result, AccumulateContextEntry accPropCtx, PropagationContext propagationContext, boolean allowNullPropagation) {
        if (!allowNullPropagation && result == null) {
            if (accPropCtx.isPropagated()) {
                trgLeftTuples.addDelete((TupleImpl)accPropCtx.getResultLeftTuple());
                accPropCtx.setPropagated(false);
            }
            return;
        }
        if (accPropCtx.getResultFactHandle() == null) {
            InternalFactHandle handle = accNode.createResultFactHandle(context, reteEvaluator, leftTuple, this.createResult(accNode, key, result));
            accPropCtx.setResultFactHandle(handle);
            accPropCtx.setResultLeftTuple(TupleFactory.createLeftTuple(handle, leftTuple, (Sink)sink));
        } else {
            ((InternalFactHandle)accPropCtx.getResultFactHandle()).setObject(this.createResult(accNode, key, result));
        }
        AlphaNodeFieldConstraint[] resultConstraints = accNode.getResultConstraints();
        BetaConstraints resultBinder = accNode.getResultBinder();
        boolean isAllowed = true;
        for (AlphaNodeFieldConstraint resultConstraint : resultConstraints) {
            if (resultConstraint.isAllowed(accPropCtx.getResultFactHandle(), reteEvaluator)) continue;
            isAllowed = false;
            break;
        }
        if (isAllowed) {
            resultBinder.updateFromTuple(memory.resultsContext, reteEvaluator, leftTuple);
            if (!resultBinder.isAllowedCachedLeft(memory.resultsContext, accPropCtx.getResultFactHandle())) {
                isAllowed = false;
            }
            resultBinder.resetTuple(memory.resultsContext);
        }
        TupleImpl childLeftTuple = (TupleImpl)accPropCtx.getResultLeftTuple();
        childLeftTuple.setPropagationContext(propagationContext != null ? propagationContext : leftTuple.getPropagationContext());
        if (accPropCtx.isPropagated()) {
            RuleNetworkEvaluator.normalizeStagedTuples(stagedLeftTuples, childLeftTuple);
            if (isAllowed) {
                trgLeftTuples.addUpdate(childLeftTuple);
            } else {
                trgLeftTuples.addDelete(childLeftTuple);
                accPropCtx.setPropagated(false);
            }
        } else if (isAllowed) {
            trgLeftTuples.addInsert(childLeftTuple);
            accPropCtx.setPropagated(true);
        }
    }

    protected Object createResult(AccumulateNode accNode, Object key, Object result) {
        return result;
    }

    private void addMatch(AccumulateNode accNode, Accumulate accumulate, TupleImpl leftTuple, TupleImpl rightTuple, TupleImpl currentLeftChild, TupleImpl currentRightChild, ReteEvaluator reteEvaluator, AccumulateNode.AccumulateMemory am, AccumulateNode.BaseAccumulation accctx, boolean useLeftMemory, boolean leftPropagation) {
        TupleImpl tuple = leftTuple;
        InternalFactHandle handle = rightTuple.getFactHandle();
        if (accNode.isRightInputIsRiaNode()) {
            tuple = rightTuple;
            handle = rightTuple.getFactHandleForEvaluation();
        }
        if (leftPropagation && handle.isExpired()) {
            return;
        }
        accctx.setPropagationContext(rightTuple.getPropagationContext());
        Object value = accumulate.accumulate(am.workingMemoryContext, accctx, tuple, handle, reteEvaluator);
        if (useLeftMemory) {
            TupleImpl match = TupleFactory.createLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, accNode, true);
            this.postAccumulate(accNode, accctx, match);
            match.setContextObject(value);
        }
    }

    void postAccumulate(AccumulateNode accNode, Object accctx, TupleImpl match) {
    }

    private boolean removeMatch(AccumulateNode accNode, Accumulate accumulate, TupleImpl rightTuple, TupleImpl match, ReteEvaluator reteEvaluator, AccumulateNode.AccumulateMemory am, AccumulateNode.BaseAccumulation accctx, boolean reaccumulate) {
        boolean reversed;
        TupleImpl leftParent = match.getLeftParent();
        TupleImpl rightParent = match.getRightParent();
        match.unlinkFromLeftParent();
        match.unlinkFromRightParent();
        InternalFactHandle handle = rightTuple.getFactHandle();
        TupleImpl tuple = leftParent;
        if (accNode.isRightInputIsRiaNode()) {
            tuple = rightTuple;
            handle = rightTuple.getFactHandleForEvaluation();
        }
        if (!(reversed = accumulate.tryReverse(am.workingMemoryContext, accctx, tuple, handle, match, reteEvaluator))) {
            this.reaccumulateForLeftTuple(accNode, accumulate, leftParent, rightParent, match, reteEvaluator, am, accctx, reaccumulate);
        }
        return reversed;
    }

    protected void reaccumulateForLeftTuple(AccumulateNode accNode, Accumulate accumulate, TupleImpl leftParent, TupleImpl unused1, TupleImpl unused2, ReteEvaluator reteEvaluator, AccumulateNode.AccumulateMemory am, AccumulateNode.BaseAccumulation accctx, boolean reaccumulate) {
        if (reaccumulate) {
            PhreakAccumulateNode.reinit(accumulate, leftParent, reteEvaluator, am, accctx);
            for (TupleImpl childMatch = leftParent.getFirstChild(); childMatch != null; childMatch = childMatch.getHandleNext()) {
                TupleImpl rightTuple = childMatch.getRightParent();
                InternalFactHandle childHandle = rightTuple.getFactHandle();
                TupleImpl tuple = leftParent;
                if (accNode.isRightInputIsRiaNode()) {
                    tuple = rightTuple;
                    childHandle = rightTuple.getFactHandleForEvaluation();
                }
                Object value = accumulate.accumulate(am.workingMemoryContext, accctx, tuple, childHandle, reteEvaluator);
                this.postAccumulate(accNode, accctx, childMatch);
                childMatch.setContextObject(value);
            }
        }
    }

    private void removePreviousMatchesForRightTuple(AccumulateNode accNode, Accumulate accumulate, TupleImpl rightTuple, ReteEvaluator reteEvaluator, AccumulateNode.AccumulateMemory memory, TupleImpl firstChild, TupleSets trgLeftTuples) {
        TupleImpl match = firstChild;
        while (match != null) {
            TupleImpl next = match.getRightParentNext();
            TupleImpl leftTuple = match.getLeftParent();
            AccumulateNode.BaseAccumulation accctx = (AccumulateNode.BaseAccumulation)leftTuple.getContextObject();
            this.removeMatch(accNode, accumulate, rightTuple, match, reteEvaluator, memory, accctx, true);
            if (leftTuple.getStagedType() == 0) {
                trgLeftTuples.addUpdate(leftTuple);
            }
            match = next;
        }
    }

    private static void removePreviousMatchesForLeftTuple(Accumulate accumulate, TupleImpl leftTuple, ReteEvaluator reteEvaluator, AccumulateNode.AccumulateMemory memory, AccumulateNode.BaseAccumulation accctx, boolean reInit) {
        TupleImpl match = leftTuple.getFirstChild();
        while (match != null) {
            TupleImpl next = match.getHandleNext();
            match.unlinkFromRightParent();
            match.unlinkFromLeftParent();
            match = next;
        }
        if (reInit) {
            PhreakAccumulateNode.reinit(accumulate, leftTuple, reteEvaluator, memory, accctx);
        }
    }

    private static void reinit(Accumulate accumulate, TupleImpl leftTuple, ReteEvaluator reteEvaluator, AccumulateNode.AccumulateMemory memory, AccumulateNode.BaseAccumulation accctx) {
        Object funcContext = ((AccumulateContextEntry)((Object)accctx)).getFunctionContext();
        funcContext = accumulate.init(memory.workingMemoryContext, accctx, funcContext, leftTuple, reteEvaluator);
        ((AccumulateContextEntry)((Object)accctx)).setFunctionContext(funcContext);
    }
}

