/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.Executor;
import org.drools.base.rule.accessor.DataProvider;
import org.drools.base.rule.constraint.AlphaNodeFieldConstraint;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.AsyncMessage;
import org.drools.core.reteoo.AsyncMessagesCoordinator;
import org.drools.core.reteoo.AsyncSendNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.TupleImpl;
import org.kie.internal.concurrent.ExecutorProviderFactory;

public class PhreakAsyncSendNode {
    private Executor executor() {
        return ExecutorProviderFactory.getExecutorProvider().getExecutor();
    }

    public void doNode(AsyncSendNode node, AsyncSendNode.AsyncSendMemory memory, ReteEvaluator reteEvaluator, TupleSets srcLeftTuples) {
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(node, memory, reteEvaluator, srcLeftTuples);
        }
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(AsyncSendNode node, AsyncSendNode.AsyncSendMemory memory, ReteEvaluator reteEvaluator, TupleSets srcLeftTuples) {
        BetaMemory bm = memory.getBetaMemory();
        Object context = bm.getContext();
        BetaConstraints betaConstraints = node.getBetaConstraints();
        AlphaNodeFieldConstraint[] alphaConstraints = node.getAlphaConstraints();
        DataProvider dataProvider = node.getDataProvider();
        Class<?> resultClass = node.getResultClass();
        TupleImpl leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            TupleImpl next = leftTuple.getStagedNext();
            PropagationContext propagationContext = leftTuple.getPropagationContext();
            boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(node, leftTuple);
            if (useLeftMemory) {
                memory.getBetaMemory().getLeftTupleMemory().add(leftTuple);
                leftTuple.setContextObject(new LinkedHashMap());
            }
            betaConstraints.updateFromTuple(context, reteEvaluator, leftTuple);
            TupleImpl finalLeftTuple = leftTuple;
            this.executor().execute(() -> this.fetchAndSendResults(node, memory, reteEvaluator, context, betaConstraints, alphaConstraints, dataProvider, resultClass, finalLeftTuple, propagationContext));
            leftTuple.clearStaged();
            leftTuple = next;
        }
        betaConstraints.resetTuple(context);
    }

    private void fetchAndSendResults(AsyncSendNode node, AsyncSendNode.AsyncSendMemory memory, ReteEvaluator reteEvaluator, Object context, BetaConstraints betaConstraints, AlphaNodeFieldConstraint[] alphaConstraints, DataProvider dataProvider, Class<?> resultClass, TupleImpl leftTuple, PropagationContext propagationContext) {
        Iterator it = dataProvider.getResults(leftTuple, reteEvaluator, memory.providerContext);
        while (it.hasNext()) {
            InternalFactHandle factHandle;
            Object object = it.next();
            if (object == null || !resultClass.isAssignableFrom(object.getClass()) || !PhreakAsyncSendNode.isAllowed(factHandle = node.createFactHandle(leftTuple, propagationContext, reteEvaluator, object), alphaConstraints, reteEvaluator)) continue;
            this.propagate(node, reteEvaluator, factHandle, betaConstraints, context);
        }
    }

    public static boolean isAllowed(InternalFactHandle factHandle, AlphaNodeFieldConstraint[] alphaConstraints, ReteEvaluator reteEvaluator) {
        if (alphaConstraints != null) {
            for (AlphaNodeFieldConstraint alphaConstraint : alphaConstraints) {
                if (alphaConstraint.isAllowed(factHandle, reteEvaluator)) continue;
                return false;
            }
        }
        return true;
    }

    public void propagate(AsyncSendNode node, ReteEvaluator reteEvaluator, InternalFactHandle factHandle, BetaConstraints betaConstraints, Object context) {
        if (betaConstraints.isAllowedCachedLeft(context, factHandle)) {
            AsyncMessagesCoordinator.get().propagate(node.getMessageId(), new AsyncMessage(reteEvaluator, factHandle.getObject()));
        }
    }
}

