/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.base.reteoo.NodeTypeEnums;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.Memory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.common.TupleSetsImpl;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.phreak.StackEntry;
import org.drools.core.reteoo.AbstractTerminalNode;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.util.LinkedList;

public class TupleEvaluationUtil {
    public static boolean flushLeftTupleIfNecessary(ReteEvaluator reteEvaluator, SegmentMemory sm, boolean streamMode) {
        return TupleEvaluationUtil.flushLeftTupleIfNecessary(reteEvaluator, sm, null, streamMode, (short)0);
    }

    public static boolean flushLeftTupleIfNecessary(ReteEvaluator reteEvaluator, SegmentMemory sm, TupleImpl leftTuple, boolean streamMode, short stagedType) {
        PathMemory pmem = TupleEvaluationUtil.findPathToFlush(sm, leftTuple, streamMode);
        if (pmem == null) {
            return false;
        }
        TupleEvaluationUtil.forceFlushLeftTuple(pmem, sm, reteEvaluator, TupleEvaluationUtil.createLeftTupleTupleSets(leftTuple, stagedType));
        TupleEvaluationUtil.forceFlushWhenRiaNode(reteEvaluator, pmem);
        return true;
    }

    public static PathMemory findPathToFlush(SegmentMemory sm, TupleImpl leftTuple, boolean streamMode) {
        boolean forceFlush = streamMode || leftTuple != null && leftTuple.getFactHandle() != null && leftTuple.getFactHandle().isEvent();
        return forceFlush ? sm.getPathMemories().get(0) : sm.getFirstDataDrivenPathMemory();
    }

    public static TupleSets createLeftTupleTupleSets(TupleImpl leftTuple, short stagedType) {
        TupleSetsImpl leftTupleSets = new TupleSetsImpl();
        if (leftTuple != null) {
            switch (stagedType) {
                case 1: {
                    leftTupleSets.addInsert(leftTuple);
                    break;
                }
                case 3: {
                    leftTupleSets.addDelete(leftTuple);
                    break;
                }
                case 2: {
                    leftTupleSets.addUpdate(leftTuple);
                }
            }
        }
        return leftTupleSets;
    }

    public static void forceFlushWhenRiaNode(ReteEvaluator reteEvaluator, PathMemory pmem) {
        for (PathMemory outPmem : TupleEvaluationUtil.findPathsToFlushFromRia(reteEvaluator, pmem)) {
            TupleEvaluationUtil.forceFlushPath(reteEvaluator, outPmem);
        }
    }

    public static List<PathMemory> findPathsToFlushFromRia(ReteEvaluator reteEvaluator, PathMemory pmem) {
        ArrayList<PathMemory> paths = null;
        if (pmem.isDataDriven() && pmem.getNodeType() == 5244209) {
            for (PathEndNode pnode : pmem.getPathEndNode().getPathEndNodes()) {
                PathMemory outPmem;
                if (!NodeTypeEnums.isTerminalNode(pnode) || !(outPmem = reteEvaluator.getNodeMemory(pnode)).isDataDriven()) continue;
                if (paths == null) {
                    paths = new ArrayList<PathMemory>();
                }
                paths.add(outPmem);
            }
        }
        return paths == null ? Collections.emptyList() : paths;
    }

    public static void forceFlushPath(ReteEvaluator reteEvaluator, PathMemory outPmem) {
        SegmentMemory outSmem = outPmem.getSegmentMemories()[0];
        if (outSmem != null) {
            TupleEvaluationUtil.forceFlushLeftTuple(outPmem, outSmem, reteEvaluator, new TupleSetsImpl());
        }
    }

    public static void forceFlushLeftTuple(PathMemory pmem, SegmentMemory sm, ReteEvaluator reteEvaluator, TupleSets leftTupleSets) {
        Memory mem;
        LeftTupleNode node;
        SegmentMemory[] smems = pmem.getSegmentMemories();
        long bit = 1L;
        if (NodeTypeEnums.isLeftInputAdapterNode(sm.getRootNode()) && !NodeTypeEnums.isLeftInputAdapterNode(sm.getTipNode())) {
            node = sm.getRootNode().getSinkPropagator().getFirstLeftTupleSink();
            mem = sm.getNodeMemories()[1];
            bit = 2L;
        } else {
            node = sm.getRootNode();
            mem = sm.getNodeMemories()[0];
        }
        PathMemory rtnPmem = NodeTypeEnums.isTerminalNode(pmem.getPathEndNode()) ? pmem : reteEvaluator.getNodeMemory((AbstractTerminalNode)pmem.getPathEndNode().getPathEndNodes()[0]);
        ActivationsManager activationsManager = pmem.getActualActivationsManager(reteEvaluator);
        RuleNetworkEvaluator.INSTANCE.outerEval(pmem, node, bit, mem, smems, sm.getPos(), leftTupleSets, activationsManager, new LinkedList<StackEntry>(), true, rtnPmem.getOrCreateRuleAgendaItem(activationsManager).getRuleExecutor());
    }
}

