/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Serializable;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.phreak.TupleEvaluationUtil;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.reteoo.builder.BuildContext;

public class NotNode
extends BetaNode {
    private static final long serialVersionUID = 510L;
    private boolean emptyBetaConstraints;

    public NotNode() {
    }

    public NotNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints joinNodeBinder, BuildContext context) {
        super(id, leftInput, rightInput, joinNodeBinder, context);
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.setObjectCount(leftInput.getObjectCount());
        this.emptyBetaConstraints = joinNodeBinder.getConstraints().length == 0 || context.isEmptyForAllBetaConstraints();
    }

    @Override
    protected void reorderRightTuple(ReteEvaluator reteEvaluator, TupleImpl rightTuple) {
        RuleNetworkEvaluator.doExistentialUpdatesReorderChildLeftTuple(reteEvaluator, this, (RightTuple)rightTuple);
    }

    public boolean isEmptyBetaConstraints() {
        return this.emptyBetaConstraints;
    }

    public void setEmptyBetaConstraints(boolean emptyBetaConstraints) {
        this.emptyBetaConstraints = emptyBetaConstraints;
    }

    @Override
    public int getType() {
        return 11142708;
    }

    @Override
    public String toString() {
        ObjectTypeNode source = this.getObjectTypeNode();
        return "[NotNode(" + this.getId() + ") - " + (Serializable)(source != null ? source.getObjectType() : "<source from a subnetwork>") + "]";
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, ReteEvaluator reteEvaluator) {
        BetaMemory memory = NotNode.getBetaMemoryFromRightInput(this, reteEvaluator);
        RightTuple rightTuple = this.createRightTuple(factHandle, this, pctx);
        rightTuple.setPropagationContext(pctx);
        boolean stagedInsertWasEmpty = memory.getStagedRightTuples().addInsert(rightTuple);
        if (memory.getAndIncCounter() == 0 && this.isEmptyBetaConstraints()) {
            if (stagedInsertWasEmpty) {
                memory.setNodeDirtyWithoutNotify();
            }
            memory.linkNode(this, reteEvaluator);
        } else if (stagedInsertWasEmpty) {
            memory.setNodeDirty(this, reteEvaluator);
        }
        TupleEvaluationUtil.flushLeftTupleIfNecessary(reteEvaluator, memory.getOrCreateSegmentMemory(this, reteEvaluator), this.isStreamMode());
    }

    @Override
    public void retractRightTuple(TupleImpl rightTuple, PropagationContext pctx, ReteEvaluator reteEvaluator) {
        BetaMemory memory = (BetaMemory)reteEvaluator.getNodeMemory(this);
        rightTuple.setPropagationContext(pctx);
        this.doDeleteRightTuple(rightTuple, reteEvaluator, memory);
    }

    @Override
    public void doDeleteRightTuple(TupleImpl rightTuple, ReteEvaluator reteEvaluator, BetaMemory memory) {
        TupleSets stagedRightTuples = memory.getStagedRightTuples();
        boolean stagedDeleteWasEmpty = stagedRightTuples.addDelete(rightTuple);
        if (memory.getAndDecCounter() == 1 && this.isEmptyBetaConstraints()) {
            if (stagedDeleteWasEmpty) {
                memory.setNodeDirtyWithoutNotify();
            }
            memory.linkNode(this, reteEvaluator);
        } else if (stagedDeleteWasEmpty) {
            memory.setNodeDirty(this, reteEvaluator);
        }
        TupleEvaluationUtil.flushLeftTupleIfNecessary(reteEvaluator, memory.getOrCreateSegmentMemory(this, reteEvaluator), this.isStreamMode());
    }

    @Override
    public void modifyRightTuple(TupleImpl rightTuple, PropagationContext context, ReteEvaluator reteEvaluator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        if (!this.isInUse()) {
            this.getLeftTupleSource().removeTupleSink(this);
            this.getRightInput().removeObjectSink(this);
            return true;
        }
        return false;
    }

    public boolean isLeftUpdateOptimizationAllowed() {
        return this.getRawConstraints().isLeftUpdateOptimizationAllowed();
    }
}

