/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.reteoo.NodeTypeEnums;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.EmptyObjectSinkAdapter;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkPropagator;

public class SingleObjectSinkAdapter
implements ObjectSinkPropagator {
    private static final long serialVersionUID = 510L;
    private ObjectSink sink;
    private ObjectSink[] sinks;

    public SingleObjectSinkAdapter() {
    }

    public SingleObjectSinkAdapter(ObjectSink sink) {
        this.sink = sink;
        this.sinks = new ObjectSink[]{this.sink};
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sink = (ObjectSink)in.readObject();
        this.sinks = new ObjectSink[]{this.sink};
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.sink);
    }

    @Override
    public ObjectSinkPropagator addObjectSink(ObjectSink sink, int alphaNodeHashingThreshold, int alphaNodeRangeIndexThreshold) {
        CompositeObjectSinkAdapter sinkAdapter = new CompositeObjectSinkAdapter(alphaNodeHashingThreshold, alphaNodeRangeIndexThreshold);
        sinkAdapter.addObjectSink(this.sink, alphaNodeHashingThreshold, alphaNodeRangeIndexThreshold);
        sinkAdapter.addObjectSink(sink, alphaNodeHashingThreshold, alphaNodeRangeIndexThreshold);
        return sinkAdapter;
    }

    @Override
    public ObjectSinkPropagator removeObjectSink(ObjectSink sink) {
        if (this.sink.equals(sink)) {
            return EmptyObjectSinkAdapter.getInstance();
        }
        throw new IllegalArgumentException("Cannot remove " + sink + " when this sink propagator only contains " + this.sink);
    }

    @Override
    public void propagateAssertObject(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator) {
        this.sink.assertObject(factHandle, context, reteEvaluator);
    }

    @Override
    public void propagateModifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        this.sink.modifyObject(factHandle, modifyPreviousTuples, context, reteEvaluator);
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        this.sink.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, reteEvaluator);
    }

    @Override
    public void doLinkRiaNode(ReteEvaluator reteEvaluator) {
        SingleObjectSinkAdapter.staticDoLinkRiaNode(this.sink, reteEvaluator);
    }

    public static void staticDoLinkRiaNode(ObjectSink sink, ReteEvaluator reteEvaluator) {
        BetaMemory bm;
        if (sink.getType() == 11798068) {
            AccumulateNode accnode = (AccumulateNode)sink;
            AccumulateNode.AccumulateMemory accMem = (AccumulateNode.AccumulateMemory)reteEvaluator.getNodeMemory(accnode);
            bm = accMem.getBetaMemory();
        } else if (NodeTypeEnums.isBetaNode(sink)) {
            BetaNode betaNode = (BetaNode)sink;
            bm = BetaNode.getBetaMemoryFromRightInput(betaNode, reteEvaluator);
        } else {
            throw new RuntimeException("Should not be possible to have link into a node of type" + sink);
        }
        if (bm.getStagedRightTuples().isEmpty()) {
            if (bm.getRightTupleMemory().size() == 0) {
                bm.linkNode((BetaNode)sink, reteEvaluator);
            } else {
                bm.setNodeDirty((BetaNode)sink, reteEvaluator);
            }
        }
    }

    @Override
    public void doUnlinkRiaNode(ReteEvaluator reteEvaluator) {
        SingleObjectSinkAdapter.staticDoUnlinkRiaNode(this.sink, reteEvaluator);
    }

    public static void staticDoUnlinkRiaNode(ObjectSink sink, ReteEvaluator reteEvaluator) {
        BetaMemory bm;
        if (sink.getType() == 11798068) {
            AccumulateNode accnode = (AccumulateNode)sink;
            AccumulateNode.AccumulateMemory accMem = (AccumulateNode.AccumulateMemory)reteEvaluator.getNodeMemory(accnode);
            bm = accMem.getBetaMemory();
        } else if (NodeTypeEnums.isBetaNode(sink)) {
            BetaNode betaNode = (BetaNode)sink;
            bm = BetaNode.getBetaMemoryFromRightInput(betaNode, reteEvaluator);
        } else {
            throw new RuntimeException("Should not be possible to have link into a node of type" + sink);
        }
        if (sink.getType() == 11142708) {
            bm.linkNode((BetaNode)sink, reteEvaluator);
        } else {
            bm.unlinkNode(reteEvaluator);
        }
    }

    @Override
    public BaseNode getMatchingNode(BaseNode candidate) {
        return this.sink.equals(candidate) ? (BaseNode)((Object)this.sink) : null;
    }

    @Override
    public ObjectSink[] getSinks() {
        return this.sinks;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

