/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.builder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.base.InitialFact;
import org.drools.base.rule.GroupElement;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.RuleConditionElement;
import org.drools.base.rule.constraint.BetaConstraint;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.TupleStartEqualsConstraint;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.builder.BuildUtils;
import org.drools.core.reteoo.builder.NodeFactory;
import org.drools.core.reteoo.builder.ReteooComponentBuilder;
import org.kie.api.definition.rule.Propagation;

public class GroupElementBuilder
implements ReteooComponentBuilder {
    protected final Map<GroupElement.Type, ReteooComponentBuilder> geBuilders = new HashMap<GroupElement.Type, ReteooComponentBuilder>();

    public GroupElementBuilder() {
        this.geBuilders.put(GroupElement.AND, new AndBuilder());
        this.geBuilders.put(GroupElement.OR, new OrBuilder());
        this.geBuilders.put(GroupElement.NOT, new NotBuilder());
        this.geBuilders.put(GroupElement.EXISTS, new ExistsBuilder());
    }

    @Override
    public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
        GroupElement ge = (GroupElement)rce;
        ReteooComponentBuilder builder = this.geBuilders.get((Object)ge.getType());
        context.push(ge);
        context.pushRuleComponent(ge);
        builder.build(context, utils, rce);
        context.pop();
        context.popRuleComponent();
    }

    @Override
    public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
        GroupElement ge = (GroupElement)rce;
        ReteooComponentBuilder builder = this.geBuilders.get((Object)ge.getType());
        return builder.requiresLeftActivation(utils, rce);
    }

    public static class AndBuilder
    implements ReteooComponentBuilder {
        @Override
        public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
            GroupElement ge = (GroupElement)rce;
            if (ge.getChildren().size() == 1) {
                RuleConditionElement child = ge.getChildren().get(0);
                ReteooComponentBuilder builder = utils.getBuilderFor(child);
                builder.build(context, utils, child);
                AndBuilder.buildTupleSource(context, utils, this.isTerminalAlpha(context, child));
            } else {
                for (RuleConditionElement child : ge.getChildren()) {
                    ReteooComponentBuilder builder = utils.getBuilderFor(child);
                    builder.build(context, utils, child);
                    AndBuilder.buildTupleSource(context, utils, false);
                    AndBuilder.buildJoinNode(context, utils);
                }
            }
        }

        private boolean isTerminalAlpha(BuildContext context, RuleConditionElement child) {
            boolean isInitialFact = ((Pattern)child).getObjectType().isAssignableTo(InitialFact.class);
            boolean hasTimer = context.getRule().getTimer() != null;
            RuleBaseConfiguration conf = context.getRuleBase().getRuleBaseConfiguration();
            boolean lockOnActive = context.getRule().isLockOnActive();
            boolean eager = context.getRule().getMetaData(Propagation.class.getName()) != null || context.getRule().getMetaData(Propagation.class.getSimpleName()) != null;
            return !isInitialFact && !hasTimer && !lockOnActive && !eager && !conf.isParallelEvaluation() && !conf.isSequential() && !conf.isDeclarativeAgenda();
        }

        public static void buildTupleSource(BuildContext context, BuildUtils utils, boolean terminal) {
            if (context.getObjectSource() != null && context.getTupleSource() == null) {
                ObjectSource source = context.getObjectSource();
                while (source.getType() != 4259849) {
                    source = source.getParentObjectSource();
                }
                context.setRootObjectTypeNode((ObjectTypeNode)source);
                context.setTupleSource(utils.attachNode(context, CoreComponentFactory.get().getNodeFactoryService().buildLeftInputAdapterNode(context.getNextNodeId(), context.getObjectSource(), context, terminal)));
                context.setObjectSource(null);
            }
        }

        public static void buildJoinNode(BuildContext context, BuildUtils utils) {
            if (context.getObjectSource() != null && context.getTupleSource() != null) {
                BetaConstraints betaConstraints = utils.createBetaNodeConstraint(context, context.getBetaconstraints(), false);
                JoinNode joinNode = CoreComponentFactory.get().getNodeFactoryService().buildJoinNode(context.getNextNodeId(), context.getTupleSource(), context.getObjectSource(), betaConstraints, context);
                context.setTupleSource(utils.attachNode(context, joinNode));
                context.setBetaconstraints(null);
                context.setObjectSource(null);
            }
        }

        @Override
        public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
            GroupElement and = (GroupElement)rce;
            if (and.getChildren().isEmpty()) {
                return true;
            }
            RuleConditionElement child = and.getChildren().get(0);
            ReteooComponentBuilder builder = utils.getBuilderFor(child);
            return builder.requiresLeftActivation(utils, child);
        }
    }

    public static class OrBuilder
    implements ReteooComponentBuilder {
        @Override
        public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
            throw new RuntimeException("BUG: Can't build a rete network with an inner OR group element");
        }

        @Override
        public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
            throw new RuntimeException("BUG: Can't build a rete network with an inner OR group element");
        }
    }

    public static class NotBuilder
    implements ReteooComponentBuilder {
        @Override
        public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
            GroupElement not = (GroupElement)rce;
            LeftTupleSource tupleSource = context.getTupleSource();
            RuleConditionElement child = not.getChildren().get(0);
            ReteooComponentBuilder builder = utils.getBuilderFor(child);
            builder.build(context, utils, child);
            if (context.getObjectSource() == null && context.getTupleSource() != null) {
                RightInputAdapterNode riaNode = CoreComponentFactory.get().getNodeFactoryService().buildRightInputNode(context.getNextNodeId(), context.getTupleSource(), tupleSource, context);
                context.setObjectSource(utils.attachNode(context, riaNode));
                context.setTupleSource(tupleSource);
                TupleStartEqualsConstraint constraint = TupleStartEqualsConstraint.getInstance();
                ArrayList<BetaConstraint> predicates = new ArrayList<BetaConstraint>();
                predicates.add(constraint);
                context.setBetaconstraints(predicates);
            }
            NodeFactory nfactory = CoreComponentFactory.get().getNodeFactoryService();
            BetaConstraints betaConstraints = utils.createBetaNodeConstraint(context, context.getBetaconstraints(), false);
            NotNode node = nfactory.buildNotNode(context.getNextNodeId(), context.getTupleSource(), context.getObjectSource(), betaConstraints, context);
            node.setEmptyBetaConstraints(context.getBetaconstraints().isEmpty());
            context.setTupleSource(utils.attachNode(context, node));
            context.setBetaconstraints(null);
            context.setObjectSource(null);
        }

        @Override
        public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
            return true;
        }
    }

    public static class ExistsBuilder
    implements ReteooComponentBuilder {
        @Override
        public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
            Serializable betaConstraints;
            GroupElement exists = (GroupElement)rce;
            LeftTupleSource tupleSource = context.getTupleSource();
            RuleConditionElement child = exists.getChildren().get(0);
            ReteooComponentBuilder builder = utils.getBuilderFor(child);
            builder.build(context, utils, child);
            if (context.getObjectSource() == null && context.getTupleSource() != null) {
                RightInputAdapterNode riaNode = CoreComponentFactory.get().getNodeFactoryService().buildRightInputNode(context.getNextNodeId(), context.getTupleSource(), tupleSource, context);
                context.setObjectSource(utils.attachNode(context, riaNode));
                context.setTupleSource(tupleSource);
                betaConstraints = new ArrayList();
                context.setBetaconstraints((List<BetaConstraint>)((Object)betaConstraints));
            }
            NodeFactory nfactory = CoreComponentFactory.get().getNodeFactoryService();
            betaConstraints = utils.createBetaNodeConstraint(context, context.getBetaconstraints(), false);
            ExistsNode node = nfactory.buildExistsNode(context.getNextNodeId(), context.getTupleSource(), context.getObjectSource(), (BetaConstraints)betaConstraints, context);
            context.setTupleSource(utils.attachNode(context, node));
            context.setBetaconstraints(null);
            context.setObjectSource(null);
        }

        @Override
        public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
            return true;
        }
    }
}

