/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.util.ArrayList;
import org.drools.base.rule.IndexableConstraint;
import org.drools.base.rule.constraint.BetaConstraint;
import org.drools.base.util.IndexedValueReader;
import org.drools.base.util.index.ConstraintTypeOperator;
import org.drools.base.util.index.IndexUtil;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.util.AbstractHashTable;
import org.kie.internal.conf.IndexPrecedenceOption;

public class IndexSpec {
    private ConstraintTypeOperator constraintType = ConstraintTypeOperator.UNKNOWN;
    private IndexedValueReader[] indexes;

    public IndexSpec(int nodeType, BetaConstraint[] constraints, RuleBaseConfiguration config) {
        this.init(nodeType, constraints, config);
    }

    public IndexSpec(IndexedValueReader[] indexes, ConstraintTypeOperator constraintType) {
        this.indexes = indexes;
        this.constraintType = constraintType;
    }

    public IndexSpec(IndexedValueReader[] indexes) {
        this.indexes = indexes;
        this.constraintType = ConstraintTypeOperator.EQUAL;
    }

    public ConstraintTypeOperator getConstraintType() {
        return this.constraintType;
    }

    public IndexedValueReader[] getIndexes() {
        return this.indexes;
    }

    public AbstractHashTable.Index getIndex() {
        int PRIME;
        int startResult = PRIME = 31;
        int i = 1;
        for (IndexedValueReader j : this.indexes) {
            startResult += PRIME * startResult + i;
            ++i;
        }
        return switch (this.indexes.length) {
            case 0 -> throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  0");
            case 1 -> new AbstractHashTable.SingleIndex(this.indexes, startResult);
            case 2 -> new AbstractHashTable.DoubleCompositeIndex(this.indexes, startResult);
            case 3 -> new AbstractHashTable.TripleCompositeIndex(this.indexes, startResult);
            default -> throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  great than 3");
        };
    }

    public IndexedValueReader getIndex(int pos) {
        return this.indexes[pos];
    }

    public void init(int nodeType, BetaConstraint[] constraints, RuleBaseConfiguration config) {
        int firstIndexableConstraint;
        int keyDepth = config.getCompositeKeyDepth();
        IndexPrecedenceOption indexPrecedenceOption = config.getIndexPrecedenceOption();
        int n = firstIndexableConstraint = indexPrecedenceOption == IndexPrecedenceOption.EQUALITY_PRIORITY ? this.determineTypeWithEqualityPriority(nodeType, constraints, config) : this.determineTypeWithPatternOrder(nodeType, constraints, config);
        if (this.constraintType == ConstraintTypeOperator.EQUAL) {
            ArrayList<IndexedValueReader> indexList = new ArrayList<IndexedValueReader>();
            if (IndexUtil.isEqualIndexable(constraints[firstIndexableConstraint])) {
                indexList.add(((IndexableConstraint)((Object)constraints[firstIndexableConstraint])).getFieldIndex());
            }
            for (int i = firstIndexableConstraint + 1; i < constraints.length && indexList.size() < keyDepth; ++i) {
                if (!IndexUtil.isEqualIndexable(constraints[i]) || ((IndexableConstraint)((Object)constraints[i])).isUnification()) continue;
                indexList.add(((IndexableConstraint)((Object)constraints[i])).getFieldIndex());
            }
            this.indexes = indexList.toArray(new IndexedValueReader[indexList.size()]);
        } else if (this.constraintType.isComparison()) {
            this.indexes = new IndexedValueReader[]{((IndexableConstraint)((Object)constraints[firstIndexableConstraint])).getFieldIndex()};
        }
    }

    public int determineTypeWithEqualityPriority(int nodeType, BetaConstraint[] constraints, RuleBaseConfiguration config) {
        int indexedConstraintPos = 0;
        for (int i = 0; i < constraints.length; ++i) {
            if (!(constraints[i] instanceof IndexableConstraint)) continue;
            IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)constraints[i]);
            ConstraintTypeOperator type = indexableConstraint.getConstraintType();
            if (type == ConstraintTypeOperator.EQUAL) {
                this.constraintType = type;
                return i;
            }
            if (this.constraintType != ConstraintTypeOperator.UNKNOWN || !type.isIndexableForNode(nodeType, indexableConstraint, config)) continue;
            this.constraintType = type;
            indexedConstraintPos = i;
        }
        return indexedConstraintPos;
    }

    public int determineTypeWithPatternOrder(int nodeType, BetaConstraint[] constraints, RuleBaseConfiguration config) {
        for (int i = 0; i < constraints.length; ++i) {
            ConstraintTypeOperator type = ConstraintTypeOperator.getType(constraints[i]);
            if (!type.isIndexableForNode(nodeType, (IndexableConstraint)((Object)constraints[i]), config)) continue;
            this.constraintType = type;
            return i;
        }
        return constraints.length;
    }
}

