/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drlonyaml.cli;

import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.concurrent.Callable;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DrlParser;
import org.drools.drlonyaml.cli.utils.Utils;
import org.drools.drlonyaml.model.DrlPackage;
import org.drools.util.IoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="drl2yaml", description={"Converts a single .drl file to YAML format."})
public class Drl2Yaml
implements Callable<Integer> {
    @CommandLine.Option(names={"-o", "--output"}, paramLabel="OUTPUT_FILE", description={"The output file to write the content of the conversion to. If left empty, the translated format will be emitted on STDOUT."})
    private File archive;
    @CommandLine.Parameters(index="0", paramLabel="INPUT_FILE", description={"The .drl file to be converted in YAML format. If left empty, content will be read from STDIN."}, arity="0..1")
    private File inputFile;
    private InputStream inputStream;
    private static final DrlParser drlParser = new DrlParser();

    @Override
    public Integer call() throws Exception {
        this.inputStream = Utils.conventionInputStream(this.inputFile);
        String content = new String(IoUtils.readBytesFromInputStream(this.inputStream));
        String yaml = Drl2Yaml.drl2yaml(content);
        Utils.conventionOutputConsumer(this.archive).accept(yaml);
        return 0;
    }

    public static String drl2yaml(String drl) throws Exception {
        PackageDescr pkgDescr = drlParser.parse(new StringReader(drl));
        DrlPackage model = DrlPackage.from(pkgDescr);
        StringWriter writer = new StringWriter();
        org.drools.drlonyaml.model.Utils.getYamlMapper().writeValue(writer, (Object)model);
        String yaml = writer.toString();
        writer.close();
        return yaml;
    }
}

