/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drlonyaml.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.drools.drl.ast.descr.AttributeDescr;
import org.drools.drl.ast.descr.FunctionDescr;
import org.drools.drl.ast.descr.GlobalDescr;
import org.drools.drl.ast.descr.ImportDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drlonyaml.model.Function;
import org.drools.drlonyaml.model.Global;
import org.drools.drlonyaml.model.Import;
import org.drools.drlonyaml.model.Rule;

@JsonPropertyOrder(value={"name", "unit", "dialect", "imports", "globals", "rules", "functions"})
public class DrlPackage {
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String name = "";
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String unit = "";
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String dialect = "";
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Import> imports = new ArrayList<Import>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Global> globals = new ArrayList<Global>();
    private List<Rule> rules = new ArrayList<Rule>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Function> functions = new ArrayList<Function>();

    public static DrlPackage from(PackageDescr pkg) {
        AttributeDescr dialectAttr;
        Objects.requireNonNull(pkg);
        DrlPackage result = new DrlPackage();
        result.name = pkg.getName();
        if (pkg.getUnit() != null) {
            result.unit = pkg.getUnit().getTarget();
        }
        if ((dialectAttr = pkg.getAttribute("dialect")) != null) {
            result.dialect = dialectAttr.getValue();
        }
        for (ImportDescr i : pkg.getImports()) {
            result.imports.add(Import.from(i));
        }
        for (GlobalDescr g : pkg.getGlobals()) {
            result.globals.add(Global.from(g));
        }
        for (RuleDescr r : pkg.getRules()) {
            result.rules.add(Rule.from(r));
        }
        for (FunctionDescr f : pkg.getFunctions()) {
            result.functions.add(Function.from(f));
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getDialect() {
        return this.dialect;
    }

    public List<Import> getImports() {
        return this.imports;
    }

    public List<Global> getGlobals() {
        return this.globals;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public List<Function> getFunctions() {
        return this.functions;
    }
}

