/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drlonyaml.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.ExprConstraintDescr;
import org.drools.drl.ast.descr.FromDescr;
import org.drools.drl.ast.descr.MVELExprDescr;
import org.drools.drl.ast.descr.PatternDescr;
import org.drools.drl.parser.lang.XpathAnalysis;
import org.drools.drlonyaml.model.Base;

@JsonDeserialize(as=Pattern.class)
public class Pattern
implements Base {
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String given;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String datasource;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String as;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<String> having = new ArrayList<String>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String from;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Pattern from(PatternDescr pattern) {
        Objects.requireNonNull(pattern);
        Pattern result = new Pattern();
        if (pattern.getObjectType() != null) {
            result.given = pattern.getObjectType();
            for (BaseDescr baseDescr : pattern.getConstraint().getDescrs()) {
                if (baseDescr instanceof MVELExprDescr) {
                    result.having.add(((MVELExprDescr)baseDescr).getExpression());
                }
                if (!(baseDescr instanceof ExprConstraintDescr)) throw new UnsupportedOperationException();
                result.having.add(((ExprConstraintDescr)baseDescr).getExpression());
            }
            if (pattern.getSource() != null) {
                if (!(pattern.getSource() instanceof FromDescr)) throw new UnsupportedOperationException("unknown patternSourceDescr");
                result.from = ((FromDescr)pattern.getSource()).getDataSource().getText();
            }
        } else {
            String oopathExpr = pattern.getDescrs().get(0).getText();
            XpathAnalysis xpathAnalysis = XpathAnalysis.analyze(oopathExpr);
            if (!xpathAnalysis.isSinglePart()) {
                throw new UnsupportedOperationException();
            }
            XpathAnalysis.XpathPart xpathPart = xpathAnalysis.getPart(0);
            result.datasource = xpathPart.getField();
            result.having.addAll(xpathPart.getConstraints());
        }
        if (pattern.getAllBoundIdentifiers().isEmpty()) return result;
        result.as = pattern.getAllBoundIdentifiers().size() == 1 ? pattern.getAllBoundIdentifiers().get(0) : pattern.getAllBoundIdentifiers().get(0);
        return result;
    }

    public String getGiven() {
        return this.given;
    }

    public String getAs() {
        return this.as;
    }

    public List<String> getHaving() {
        return this.having;
    }

    public String getFrom() {
        return this.from;
    }

    public String getDatasource() {
        return this.datasource;
    }
}

