/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.base;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.function.Function;
import org.drools.base.base.DroolsQuery;
import org.drools.base.factmodel.traits.Thing;
import org.drools.base.factmodel.traits.Trait;
import org.drools.base.facttemplates.FactTemplate;
import org.drools.core.base.CoercionUtil;
import org.kie.api.runtime.rule.EventHandle;

public enum ValueType {
    NULL_TYPE("null", null, 1),
    PCHAR_TYPE("char", Character.TYPE, 6, CoercionUtil::coerceToCharacter),
    PBYTE_TYPE("byte", Byte.TYPE, 4),
    PSHORT_TYPE("short", Short.TYPE, 4, CoercionUtil::coerceToShort),
    PINTEGER_TYPE("int", Integer.TYPE, 4, CoercionUtil::coerceToInteger),
    PLONG_TYPE("long", Long.TYPE, 4, CoercionUtil::coerceToLong),
    PFLOAT_TYPE("float", Float.TYPE, 5, CoercionUtil::coerceToFloat),
    PDOUBLE_TYPE("double", Double.TYPE, 5, CoercionUtil::coerceToDouble),
    PBOOLEAN_TYPE("boolean", Boolean.TYPE, 2),
    CHAR_TYPE("Character", Character.class, 6, CoercionUtil::coerceToCharacter),
    BYTE_TYPE("Byte", Byte.class, 4),
    SHORT_TYPE("Short", Short.class, 4, CoercionUtil::coerceToShort),
    INTEGER_TYPE("Integer", Integer.class, 4, CoercionUtil::coerceToInteger),
    LONG_TYPE("Long", Long.class, 4, CoercionUtil::coerceToLong),
    FLOAT_TYPE("Float", Float.class, 5, CoercionUtil::coerceToFloat),
    DOUBLE_TYPE("Double", Double.class, 5, CoercionUtil::coerceToDouble),
    BOOLEAN_TYPE("Boolean", Boolean.class, 2),
    NUMBER_TYPE("Number", Number.class, 3),
    BIG_DECIMAL_TYPE("BigDecimal", BigDecimal.class, 3, CoercionUtil::coerceToBigDecimal),
    BIG_INTEGER_TYPE("BigInteger", BigInteger.class, 3, CoercionUtil::coerceToBigInteger),
    DATE_TYPE("Date", Date.class, 8),
    LOCAL_DATE_TYPE("LocalDate", LocalDate.class, 8),
    LOCAL_TIME_TYPE("LocalTime", LocalDateTime.class, 8),
    ARRAY_TYPE("Array", Object[].class, 9),
    STRING_TYPE("String", String.class, 7, CoercionUtil::coerceToString),
    OBJECT_TYPE("Object", Object.class, 10),
    FACTTEMPLATE_TYPE("FactTemplate", FactTemplate.class, 0),
    EVENT_TYPE("Event", EventHandle.class, 10),
    QUERY_TYPE("Query", DroolsQuery.class, 10),
    TRAIT_TYPE("Trait", Thing.class, 10),
    CLASS_TYPE("Class", Class.class, 10);

    private final String name;
    private final Class<?> classType;
    private final int simpleType;
    private final Function<Object, ?> coerceFunction;

    private ValueType(String name, Class<?> classType, int simpleType) {
        this(name, classType, simpleType, Function.identity());
    }

    private ValueType(String name, Class<?> classType, int simpleType, Function<Object, ?> coerceFunction) {
        this.name = name;
        this.classType = classType;
        this.simpleType = simpleType;
        this.coerceFunction = coerceFunction;
    }

    public Object coerce(Object value) {
        return this.coerceFunction.apply(value);
    }

    public String toString() {
        return "ValueType = '" + this.name + "'";
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getClassType() {
        return this.classType;
    }

    public boolean isBoolean() {
        return this.classType == Boolean.class || this.classType == Boolean.TYPE;
    }

    public boolean isNumber() {
        return this.simpleType == 4 || this.simpleType == 5 || this.simpleType == 6 || this.simpleType == 3;
    }

    public boolean isIntegerNumber() {
        return this.simpleType == 4;
    }

    public boolean isDecimalNumber() {
        return this.simpleType == 5;
    }

    public boolean isChar() {
        return this.simpleType == 6;
    }

    public boolean isDate() {
        return this.simpleType == 8;
    }

    public boolean isEvent() {
        return this.classType == EventHandle.class;
    }

    public static ValueType determineValueType(Class<?> clazz) {
        if (clazz == null) {
            return NULL_TYPE;
        }
        if (clazz == FactTemplate.class) {
            return FACTTEMPLATE_TYPE;
        }
        if (clazz == DroolsQuery.class) {
            return QUERY_TYPE;
        }
        if (clazz == Character.TYPE) {
            return PCHAR_TYPE;
        }
        if (clazz == Byte.TYPE) {
            return PBYTE_TYPE;
        }
        if (clazz == Short.TYPE) {
            return PSHORT_TYPE;
        }
        if (clazz == Integer.TYPE) {
            return PINTEGER_TYPE;
        }
        if (clazz == Long.TYPE) {
            return PLONG_TYPE;
        }
        if (clazz == Float.TYPE) {
            return PFLOAT_TYPE;
        }
        if (clazz == Double.TYPE) {
            return PDOUBLE_TYPE;
        }
        if (clazz == Boolean.TYPE) {
            return PBOOLEAN_TYPE;
        }
        if (clazz == Character.class) {
            return CHAR_TYPE;
        }
        if (clazz == Byte.class) {
            return BYTE_TYPE;
        }
        if (clazz == Short.class) {
            return SHORT_TYPE;
        }
        if (clazz == Integer.class) {
            return INTEGER_TYPE;
        }
        if (clazz == Long.class) {
            return LONG_TYPE;
        }
        if (clazz == Float.class) {
            return FLOAT_TYPE;
        }
        if (clazz == Double.class) {
            return DOUBLE_TYPE;
        }
        if (clazz == Boolean.class) {
            return BOOLEAN_TYPE;
        }
        if (clazz == BigDecimal.class) {
            return BIG_DECIMAL_TYPE;
        }
        if (clazz == BigInteger.class) {
            return BIG_INTEGER_TYPE;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return NUMBER_TYPE;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return DATE_TYPE;
        }
        if (clazz == LocalDate.class) {
            return LOCAL_DATE_TYPE;
        }
        if (clazz == LocalDateTime.class) {
            return LOCAL_TIME_TYPE;
        }
        if (clazz.isArray()) {
            return ARRAY_TYPE;
        }
        if (clazz == String.class) {
            return STRING_TYPE;
        }
        if (clazz == EventHandle.class) {
            return EVENT_TYPE;
        }
        if (clazz == Class.class) {
            return CLASS_TYPE;
        }
        if (Thing.class.isAssignableFrom(clazz) || clazz.isAnnotationPresent(Trait.class)) {
            return TRAIT_TYPE;
        }
        return OBJECT_TYPE;
    }
}

