/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.common;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import org.drools.base.common.RuleBasePartitionId;
import org.drools.util.ObjectPool;
import org.kie.internal.concurrent.ExecutorProviderFactory;

public class PartitionsManager {
    public static final int MIN_PARALLEL_THRESHOLD = 8;
    public static final int MAX_PARALLEL_THRESHOLD = 32;
    private int partitionCounter = 0;
    private int parallelEvaluationSlotsCount = -1;

    public RuleBasePartitionId createNewPartitionId() {
        return new RuleBasePartitionId(this, ++this.partitionCounter);
    }

    public boolean hasParallelEvaluation() {
        return this.partitionCounter >= 8;
    }

    public int getParallelEvaluationSlotsCount() {
        return this.parallelEvaluationSlotsCount;
    }

    public void init() {
        this.parallelEvaluationSlotsCount = Math.min(this.partitionCounter, 32);
    }

    public static void doOnForkJoinPool(Runnable task) {
        ((ForkJoinTask)ForkJoinPoolHolder.RULES_EVALUATION_POOL.submit(task)).join();
    }

    public static <T> T doOnForkJoinPool(Callable<T> task) {
        return (T)((ForkJoinTask)ForkJoinPoolHolder.RULES_EVALUATION_POOL.submit((Callable)task)).join();
    }

    public static ExecutorService borrowFireUntilHaltExecutors() {
        return FireUntilHaltExecutorsPoolHolder.POOL.borrow();
    }

    public static void offerFireUntilHaltExecutors(ExecutorService executor) {
        FireUntilHaltExecutorsPoolHolder.POOL.offer(executor);
    }

    private static class FireUntilHaltExecutorsPoolHolder {
        private static final ObjectPool<ExecutorService> POOL = ObjectPool.newLockFreePool(() -> ExecutorProviderFactory.getExecutorProvider().newFixedThreadPool(32));

        private FireUntilHaltExecutorsPoolHolder() {
        }
    }

    private static class ForkJoinPoolHolder {
        private static final ForkJoinPool RULES_EVALUATION_POOL = new ForkJoinPool();

        private ForkJoinPoolHolder() {
        }
    }
}

