/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.base.ValueResolver;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.ContextEntry;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.constraint.BetaNodeFieldConstraint;
import org.drools.base.rule.constraint.Constraint;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.Tuple;
import org.kie.api.runtime.rule.FactHandle;

public class TupleStartEqualsConstraint
implements BetaNodeFieldConstraint {
    private static final long serialVersionUID = 510L;
    private Declaration[] declarations = new Declaration[0];
    private static final TupleStartEqualsConstraint INSTANCE = new TupleStartEqualsConstraint();

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.declarations = (Declaration[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.declarations);
    }

    public static TupleStartEqualsConstraint getInstance() {
        return INSTANCE;
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        return this.declarations;
    }

    @Override
    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
    }

    @Override
    public boolean isTemporal() {
        return false;
    }

    @Override
    public ContextEntry createContextEntry() {
        return new TupleStartEqualsConstraintContextEntry();
    }

    @Override
    public boolean isAllowedCachedLeft(ContextEntry context, FactHandle handle) {
        int size = ((TupleStartEqualsConstraintContextEntry)context).compareSize;
        Tuple tuple = ((Tuple)handle.getObject()).getSubTuple(size);
        return ((TupleStartEqualsConstraintContextEntry)context).leftTuple.getSubTuple(size).equals(tuple);
    }

    @Override
    public boolean isAllowedCachedRight(BaseTuple tuple, ContextEntry context) {
        LeftTuple nonEmptyLeftTuple = (LeftTuple)tuple.skipEmptyHandles();
        return nonEmptyLeftTuple.equals(((TupleStartEqualsConstraintContextEntry)context).rightTuple.getSubTuple(nonEmptyLeftTuple.size()));
    }

    public String toString() {
        return "[ TupleStartEqualsConstraint ]";
    }

    public int hashCode() {
        return 10;
    }

    public boolean equals(Object object) {
        return object instanceof TupleStartEqualsConstraint;
    }

    @Override
    public TupleStartEqualsConstraint clone() {
        return INSTANCE;
    }

    @Override
    public Constraint.ConstraintType getType() {
        return Constraint.ConstraintType.BETA;
    }

    @Override
    public BetaNodeFieldConstraint cloneIfInUse() {
        return this;
    }

    public static class TupleStartEqualsConstraintContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = 510L;
        public Tuple leftTuple;
        public Tuple rightTuple;
        public int compareSize;
        private ContextEntry entry;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.leftTuple = (Tuple)in.readObject();
            this.rightTuple = (Tuple)in.readObject();
            this.compareSize = in.readInt();
            this.entry = (ContextEntry)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.leftTuple);
            out.writeObject(this.rightTuple);
            out.writeInt(this.compareSize);
            out.writeObject(this.entry);
        }

        @Override
        public ContextEntry getNext() {
            return this.entry;
        }

        @Override
        public void setNext(ContextEntry entry) {
            this.entry = entry;
        }

        @Override
        public void updateFromTuple(ValueResolver valueResolver, BaseTuple tuple) {
            this.leftTuple = (Tuple)tuple.skipEmptyHandles();
            this.compareSize = this.leftTuple.size();
        }

        @Override
        public void updateFromFactHandle(ValueResolver valueResolver, FactHandle handle) {
            this.rightTuple = ((LeftTuple)handle.getObject()).skipEmptyHandles();
        }

        @Override
        public void resetTuple() {
            this.leftTuple = null;
        }

        @Override
        public void resetFactHandle() {
            this.rightTuple = null;
        }
    }
}

