/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drlonyaml.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.ExprConstraintDescr;
import org.drools.drl.ast.descr.FromDescr;
import org.drools.drl.ast.descr.MVELExprDescr;
import org.drools.drl.ast.descr.PatternDescr;
import org.drools.drlonyaml.model.Base;

@JsonDeserialize(as=Pattern.class)
public class Pattern
implements Base {
    @JsonProperty(required=true)
    private String given;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String as;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<String> having = new ArrayList<String>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String from;

    public static Pattern from(PatternDescr o) {
        Objects.requireNonNull(o);
        Pattern result = new Pattern();
        result.given = o.getObjectType();
        if (!o.getAllBoundIdentifiers().isEmpty()) {
            result.as = o.getAllBoundIdentifiers().size() == 1 ? o.getAllBoundIdentifiers().get(0) : o.getAllBoundIdentifiers().get(0);
        }
        for (BaseDescr baseDescr : o.getConstraint().getDescrs()) {
            if (baseDescr instanceof MVELExprDescr) {
                result.having.add(((MVELExprDescr)baseDescr).getExpression());
            }
            if (baseDescr instanceof ExprConstraintDescr) {
                result.having.add(((ExprConstraintDescr)baseDescr).getExpression());
                continue;
            }
            throw new UnsupportedOperationException();
        }
        if (o.getSource() != null) {
            if (o.getSource() instanceof FromDescr) {
                result.from = ((FromDescr)o.getSource()).getDataSource().getText();
            } else {
                throw new UnsupportedOperationException("unknown patternSourceDescr");
            }
        }
        return result;
    }

    public String getGiven() {
        return this.given;
    }

    public String getAs() {
        return this.as;
    }

    public List<String> getHaving() {
        return this.having;
    }

    public String getFrom() {
        return this.from;
    }
}

