/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.extractors;

import java.lang.reflect.Method;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.ValueType;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.util.TimeIntervalParser;

public class ConstantValueReader
implements ReadAccessor {
    private final Object value;

    public ConstantValueReader(Object value) {
        this.value = value;
    }

    @Override
    public Object getValue(ValueResolver valueResolver, Object object) {
        return this.value;
    }

    @Override
    public char getCharValue(ValueResolver valueResolver, Object object) {
        return ((Character)this.value).charValue();
    }

    @Override
    public int getIntValue(ValueResolver valueResolver, Object object) {
        return (Integer)this.value;
    }

    @Override
    public byte getByteValue(ValueResolver valueResolver, Object object) {
        return (Byte)this.value;
    }

    @Override
    public short getShortValue(ValueResolver valueResolver, Object object) {
        return (Short)this.value;
    }

    @Override
    public long getLongValue(ValueResolver valueResolver, Object object) {
        return this.value instanceof Long ? (Long)this.value : TimeIntervalParser.getTimestampFromDate(this.value);
    }

    @Override
    public float getFloatValue(ValueResolver valueResolver, Object object) {
        return ((Float)this.value).floatValue();
    }

    @Override
    public double getDoubleValue(ValueResolver valueResolver, Object object) {
        return (Double)this.value;
    }

    @Override
    public boolean getBooleanValue(ValueResolver valueResolver, Object object) {
        return (Boolean)this.value;
    }

    @Override
    public boolean isNullValue(ValueResolver valueResolver, Object object) {
        return this.value == null;
    }

    @Override
    public int getHashCode(ValueResolver valueResolver, Object object) {
        return this.value.hashCode();
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isSelfReference() {
        return false;
    }

    @Override
    public Object getValue(Object object) {
        return this.value;
    }

    public boolean isNullValue(Object object) {
        throw new UnsupportedOperationException("org.drools.core.base.extractors.ConstantValueReader.isNullValue -> TODO");
    }

    @Override
    public ValueType getValueType() {
        throw new UnsupportedOperationException("org.drools.core.base.extractors.ConstantValueReader.getValueType -> TODO");
    }

    @Override
    public Class<?> getExtractToClass() {
        throw new UnsupportedOperationException("org.drools.core.base.extractors.ConstantValueReader.getExtractToClass -> TODO");
    }

    @Override
    public String getExtractToClassName() {
        throw new UnsupportedOperationException("org.drools.core.base.extractors.ConstantValueReader.getExtractToClassName -> TODO");
    }

    @Override
    public Method getNativeReadMethod() {
        throw new UnsupportedOperationException("org.drools.core.base.extractors.ConstantValueReader.getNativeReadMethod -> TODO");
    }

    @Override
    public String getNativeReadMethodName() {
        throw new UnsupportedOperationException("org.drools.core.base.extractors.ConstantValueReader.getNativeReadMethodName -> TODO");
    }

    @Override
    public int getHashCode(Object object) {
        throw new UnsupportedOperationException("org.drools.core.base.extractors.ConstantValueReader.getHashCode -> TODO");
    }

    @Override
    public int getIndex() {
        throw new UnsupportedOperationException("org.drools.core.base.extractors.ConstantValueReader.getIndex -> TODO");
    }
}

