/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.base.reteoo.NodeTypeEnums;
import org.drools.base.rule.constraint.QueryNameConstraint;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.phreak.BuildtimeSegmentUtilities;
import org.drools.core.phreak.EagerPhreakBuilder;
import org.drools.core.phreak.LazyPhreakBuilder;
import org.drools.core.phreak.PhreakBuilder;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.SegmentMemory;

public class RuntimeSegmentUtilities {
    public static SegmentMemory getOrCreateSegmentMemory(LeftTupleNode node, ReteEvaluator reteEvaluator) {
        return RuntimeSegmentUtilities.getOrCreateSegmentMemory(reteEvaluator.getNodeMemory((MemoryFactory)((Object)node)), node, reteEvaluator);
    }

    public static SegmentMemory getOrCreateSegmentMemory(Memory memory, LeftTupleNode node, ReteEvaluator reteEvaluator) {
        SegmentMemory smem = memory.getSegmentMemory();
        if (smem != null) {
            return smem;
        }
        LeftTupleNode segmentRoot = BuildtimeSegmentUtilities.findSegmentRoot(node);
        smem = RuntimeSegmentUtilities.restoreSegmentFromPrototype(reteEvaluator, segmentRoot);
        if (smem != null) {
            if (NodeTypeEnums.isBetaNode(segmentRoot) && segmentRoot.isRightInputIsRiaNode()) {
                RuntimeSegmentUtilities.createRiaSegmentMemory((BetaNode)segmentRoot, reteEvaluator);
            }
            return smem;
        }
        return LazyPhreakBuilder.createSegmentMemory(reteEvaluator, segmentRoot);
    }

    private static SegmentMemory restoreSegmentFromPrototype(ReteEvaluator reteEvaluator, LeftTupleNode segmentRoot) {
        SegmentMemory.SegmentPrototype proto = reteEvaluator.getKnowledgeBase().getSegmentPrototype(segmentRoot);
        if (proto == null || proto.getNodesInSegment() == null) {
            return null;
        }
        LeftTupleNode lastNode = proto.getNodesInSegment()[proto.getNodesInSegment().length - 1];
        if (NodeTypeEnums.isTerminalNode(lastNode)) {
            SegmentMemory smem;
            PathMemory pmem = (PathMemory)reteEvaluator.getNodeMemories().peekNodeMemory(lastNode);
            if (pmem == null) {
                pmem = RuntimeSegmentUtilities.initializePathMemory(reteEvaluator, (PathEndNode)lastNode);
            }
            if ((smem = pmem.getSegmentMemories()[proto.getPos()]) != null) {
                return smem;
            }
        }
        SegmentMemory smem = reteEvaluator.getKnowledgeBase().createSegmentFromPrototype(reteEvaluator, proto);
        RuntimeSegmentUtilities.updateRiaAndTerminalMemory(smem, proto, reteEvaluator);
        return smem;
    }

    public static SegmentMemory getQuerySegmentMemory(ReteEvaluator reteEvaluator, QueryElementNode queryNode) {
        ObjectTypeNode queryOtn = reteEvaluator.getDefaultEntryPoint().getEntryPointNode().getQueryNode();
        LeftInputAdapterNode liaNode = RuntimeSegmentUtilities.getQueryLiaNode(queryNode.getQueryElement().getQueryName(), queryOtn);
        LeftInputAdapterNode.LiaNodeMemory liam = reteEvaluator.getNodeMemory(liaNode);
        SegmentMemory querySmem = liam.getSegmentMemory();
        if (querySmem == null) {
            querySmem = RuntimeSegmentUtilities.getOrCreateSegmentMemory(liam, liaNode, reteEvaluator);
        }
        return querySmem;
    }

    static RightInputAdapterNode createRiaSegmentMemory(BetaNode betaNode, ReteEvaluator reteEvaluator) {
        RightInputAdapterNode riaNode = (RightInputAdapterNode)betaNode.getRightInput();
        LeftTupleSource subnetworkLts = riaNode.getStartTupleSource();
        Object rootSubNetwokrMem = reteEvaluator.getNodeMemory((MemoryFactory)((Object)subnetworkLts));
        SegmentMemory subNetworkSegmentMemory = rootSubNetwokrMem.getSegmentMemory();
        if (subNetworkSegmentMemory == null) {
            RuntimeSegmentUtilities.getOrCreateSegmentMemory(rootSubNetwokrMem, subnetworkLts, reteEvaluator);
        }
        return riaNode;
    }

    public static void createChildSegments(ReteEvaluator reteEvaluator, SegmentMemory smem, LeftTupleSinkPropagator sinkProp) {
        if (!smem.isEmpty()) {
            return;
        }
        for (LeftTupleSinkNode sink = sinkProp.getFirstLeftTupleSink(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            SegmentMemory childSmem = PhreakBuilder.isEagerSegmentCreation() ? RuntimeSegmentUtilities.createChildSegment(reteEvaluator, sink) : LazyPhreakBuilder.createChildSegment(reteEvaluator, sink);
            smem.add(childSmem);
        }
    }

    public static SegmentMemory createChildSegment(ReteEvaluator reteEvaluator, LeftTupleNode node) {
        Object memory = reteEvaluator.getNodeMemory((MemoryFactory)((Object)node));
        if (memory.getSegmentMemory() == null) {
            RuntimeSegmentUtilities.getOrCreateSegmentMemory(memory, node, reteEvaluator);
        }
        return memory.getSegmentMemory();
    }

    private static void updateRiaAndTerminalMemory(SegmentMemory smem, SegmentMemory.SegmentPrototype proto, ReteEvaluator reteEvaluator) {
        for (PathEndNode endNode : proto.getPathEndNodes()) {
            if (!EagerPhreakBuilder.isInsideSubnetwork(endNode, proto)) continue;
            PathMemory pmem = (PathMemory)reteEvaluator.getNodeMemories().peekNodeMemory(endNode);
            if (pmem != null) {
                RuntimeSegmentUtilities.addSegmentToPathMemory(pmem, smem);
            } else {
                pmem = reteEvaluator.getNodeMemories().getNodeMemory(endNode, reteEvaluator);
                RuntimeSegmentUtilities.addSegmentToPathMemory(pmem, smem);
                pmem.setSegmentMemory(smem.getPos(), smem);
                RuntimeSegmentUtilities.initializePathMemory(reteEvaluator, endNode, pmem);
            }
            if (smem.getAllLinkedMaskTest() <= 0L || !smem.isSegmentLinked()) continue;
            smem.notifyRuleLinkSegment(reteEvaluator);
        }
    }

    public static void addSegmentToPathMemory(PathMemory pmem, SegmentMemory smem) {
        if (smem.getRootNode().getPathIndex() >= pmem.getPathEndNode().getStartTupleSource().getPathIndex()) {
            smem.addPathMemory(pmem);
            pmem.setSegmentMemory(smem.getPos(), smem);
        }
    }

    public static PathMemory initializePathMemory(ReteEvaluator reteEvaluator, PathEndNode pathEndNode) {
        PathMemory pmem = reteEvaluator.getNodeMemories().getNodeMemory(pathEndNode, reteEvaluator);
        RuntimeSegmentUtilities.initializePathMemory(reteEvaluator, pathEndNode, pmem);
        return pmem;
    }

    public static void initializePathMemory(ReteEvaluator reteEvaluator, PathEndNode pathEndNode, PathMemory pmem) {
        if (pathEndNode.getEagerSegmentPrototypes() != null) {
            for (SegmentMemory.SegmentPrototype eager : pathEndNode.getEagerSegmentPrototypes()) {
                if (pmem.getSegmentMemories()[eager.getPos()] != null) continue;
                RuntimeSegmentUtilities.getOrCreateSegmentMemory(eager.getRootNode(), reteEvaluator);
            }
        }
    }

    private static LeftInputAdapterNode getQueryLiaNode(String queryName, ObjectTypeNode queryOtn) {
        for (ObjectSink sink : queryOtn.getObjectSinkPropagator().getSinks()) {
            AlphaNode alphaNode = (AlphaNode)sink;
            QueryNameConstraint nameConstraint = (QueryNameConstraint)alphaNode.getConstraint();
            if (!queryName.equals(nameConstraint.getQueryName())) continue;
            return (LeftInputAdapterNode)alphaNode.getObjectSinkPropagator().getSinks()[0];
        }
        throw new RuntimeException("Unable to find query '" + queryName + "'");
    }
}

