/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.common;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import org.drools.base.common.RuleBasePartitionId;
import org.drools.util.ObjectPool;
import org.kie.internal.concurrent.ExecutorProviderFactory;

public class PartitionsManager {
    private static final int MIN_PARALLEL_THRESHOLD = Runtime.getRuntime().availableProcessors();
    private static final int MAX_PARALLEL_THRESHOLD = MIN_PARALLEL_THRESHOLD * 4;
    private int partitionCounter = 0;
    private int parallelEvaluationSlotsCount = -1;

    public RuleBasePartitionId createNewPartitionId() {
        return new RuleBasePartitionId(this, ++this.partitionCounter);
    }

    public boolean hasParallelEvaluation() {
        return this.partitionCounter >= MIN_PARALLEL_THRESHOLD;
    }

    public int getParallelEvaluationSlotsCount() {
        return this.parallelEvaluationSlotsCount;
    }

    public void init() {
        this.parallelEvaluationSlotsCount = Math.min(this.partitionCounter, MAX_PARALLEL_THRESHOLD);
    }

    public static ForkJoinPool getFireAllExecutors() {
        return ForkJoinPoolHolder.RULES_EVALUATION_POOL;
    }

    public static ExecutorService borrowFireUntilHaltExecutors() {
        return FireUntilHaltExecutorsPoolHolder.POOL.borrow();
    }

    public static void offerFireUntilHaltExecutors(ExecutorService executor) {
        FireUntilHaltExecutorsPoolHolder.POOL.offer(executor);
    }

    private static class ForkJoinPoolHolder {
        private static final ForkJoinPool RULES_EVALUATION_POOL = new ForkJoinPool();

        private ForkJoinPoolHolder() {
        }
    }

    private static class FireUntilHaltExecutorsPoolHolder {
        private static final ObjectPool<ExecutorService> POOL = ObjectPool.newLockFreePool(() -> ExecutorProviderFactory.getExecutorProvider().newFixedThreadPool(MAX_PARALLEL_THRESHOLD));

        private FireUntilHaltExecutorsPoolHolder() {
        }
    }
}

