/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.management;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.management.GenericKieSessionMonitoringMXBean;

public abstract class GenericKieSessionMonitoringImpl
implements GenericKieSessionMonitoringMXBean {
    private static final long NANO_TO_MILLISEC = 1000000L;
    protected List<KieRuntimeEventManager> ksessions = new CopyOnWriteArrayList<KieRuntimeEventManager>();
    public AgendaStats agendaStats;
    public ProcessStats processStats;
    private String containerId;
    private String kbaseId;
    private String ksessionName;

    public GenericKieSessionMonitoringImpl(String containerId, String kbaseId, String ksessionName) {
        this.containerId = containerId;
        this.kbaseId = kbaseId;
        this.ksessionName = ksessionName;
        this.agendaStats = new AgendaStats();
        this.processStats = new ProcessStats();
    }

    public void attach(KieRuntimeEventManager ksession) {
        ksession.addEventListener(this.agendaStats);
        ksession.addEventListener(this.processStats);
        this.ksessions.add(ksession);
    }

    public void detach(KieRuntimeEventManager ksession) {
        ksession.removeEventListener(this.agendaStats);
        ksession.removeEventListener(this.processStats);
        this.ksessions.remove(ksession);
    }

    public void dispose() {
        for (KieRuntimeEventManager ksession : this.ksessions) {
            ksession.removeEventListener(this.agendaStats);
            ksession.removeEventListener(this.processStats);
        }
        this.ksessions.clear();
    }

    @Override
    public void reset() {
        this.agendaStats.reset();
        this.processStats.reset();
    }

    @Override
    public String getKieBaseId() {
        return this.kbaseId;
    }

    @Override
    public String getKieSessionName() {
        return this.ksessionName;
    }

    @Override
    public long getTotalMatchesFired() {
        return this.agendaStats.getConsolidatedStats().matchesFired.get();
    }

    @Override
    public long getTotalMatchesCancelled() {
        return this.agendaStats.getConsolidatedStats().matchesCancelled.get();
    }

    @Override
    public long getTotalMatchesCreated() {
        return this.agendaStats.getConsolidatedStats().matchesCreated.get();
    }

    @Override
    public long getTotalFiringTime() {
        return this.agendaStats.getConsolidatedStats().firingTime.get() / 1000000L;
    }

    @Override
    public Date getLastReset() {
        return this.agendaStats.getConsolidatedStats().lastReset.get();
    }

    @Override
    public double getAverageFiringTime() {
        long fires = this.agendaStats.getConsolidatedStats().matchesFired.get();
        long time = this.agendaStats.getConsolidatedStats().firingTime.get();
        return fires > 0L ? (double)time / (double)fires / 1000000.0 : 0.0;
    }

    @Override
    public GenericKieSessionMonitoringMXBean.IAgendaStatsData getStatsForRule(String ruleName) {
        AgendaStats.AgendaStatsData data = this.agendaStats.getRuleStats(ruleName);
        return data == null ? null : data;
    }

    @Override
    public Map<String, GenericKieSessionMonitoringMXBean.IAgendaStatsData> getStatsByRule() {
        return Collections.unmodifiableMap(this.agendaStats.getRulesStats());
    }

    @Override
    public long getTotalProcessInstancesStarted() {
        return this.processStats.getConsolidatedStats().processInstancesStarted.get();
    }

    @Override
    public long getTotalProcessInstancesCompleted() {
        return this.processStats.getConsolidatedStats().processInstancesCompleted.get();
    }

    @Override
    public GenericKieSessionMonitoringMXBean.IProcessStatsData getStatsForProcess(String processId) {
        ProcessStats.ProcessStatsData data = this.processStats.getProcessStats(processId);
        return data == null ? null : data;
    }

    @Override
    public Map<String, GenericKieSessionMonitoringMXBean.IProcessStatsData> getStatsByProcess() {
        return Collections.unmodifiableMap(this.processStats.getProcessStats());
    }

    public static class AgendaStats
    implements AgendaEventListener {
        private AgendaStatsData consolidated = new AgendaStatsData();
        private ConcurrentHashMap<String, AgendaStatsData> ruleStats = new ConcurrentHashMap();

        public AgendaStatsData getConsolidatedStats() {
            return this.consolidated;
        }

        public Map<String, AgendaStatsData> getRulesStats() {
            return this.ruleStats;
        }

        public AgendaStatsData getRuleStats(String ruleName) {
            return this.ruleStats.get(ruleName);
        }

        public void reset() {
            this.consolidated.reset();
            this.ruleStats.clear();
        }

        @Override
        public void matchCancelled(MatchCancelledEvent event) {
            this.consolidated.matchesCancelled.incrementAndGet();
            AgendaStatsData data = this.getRuleStatsInstance(event.getMatch().getRule().getName());
            data.matchesCancelled.incrementAndGet();
        }

        @Override
        public void matchCreated(MatchCreatedEvent event) {
            this.consolidated.matchesCreated.incrementAndGet();
            AgendaStatsData data = this.getRuleStatsInstance(event.getMatch().getRule().getName());
            data.matchesCreated.incrementAndGet();
        }

        @Override
        public void afterMatchFired(AfterMatchFiredEvent event) {
            AgendaStatsData data = this.getRuleStatsInstance(event.getMatch().getRule().getName());
            this.consolidated.stopFireClock();
            data.stopFireClock();
            this.consolidated.matchesFired.incrementAndGet();
            data.matchesFired.incrementAndGet();
        }

        @Override
        public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
        }

        @Override
        public void agendaGroupPushed(AgendaGroupPushedEvent event) {
        }

        @Override
        public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
        }

        @Override
        public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
        }

        @Override
        public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
        }

        @Override
        public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
        }

        @Override
        public void beforeMatchFired(BeforeMatchFiredEvent event) {
            AgendaStatsData data = this.getRuleStatsInstance(event.getMatch().getRule().getName());
            this.consolidated.startFireClock();
            data.startFireClock();
        }

        private AgendaStatsData getRuleStatsInstance(String ruleName) {
            return this.ruleStats.computeIfAbsent(ruleName, d -> new AgendaStatsData());
        }

        public static class AgendaStatsData
        implements GenericKieSessionMonitoringMXBean.IAgendaStatsData {
            public AtomicLong matchesFired = new AtomicLong(0L);
            public AtomicLong matchesCreated = new AtomicLong(0L);
            public AtomicLong matchesCancelled = new AtomicLong(0L);
            public AtomicLong firingTime = new AtomicLong(0L);
            public AtomicReference<Date> lastReset = new AtomicReference<Date>(new Date());
            public long start;

            @Override
            public long getMatchesFired() {
                return this.matchesFired.get();
            }

            @Override
            public long getMatchesCreated() {
                return this.matchesCreated.get();
            }

            @Override
            public long getMatchesCancelled() {
                return this.matchesCancelled.get();
            }

            @Override
            public long getFiringTime() {
                return this.firingTime.get();
            }

            @Override
            public Date getLastReset() {
                return this.lastReset.get();
            }

            public void startFireClock() {
                this.start = System.nanoTime();
            }

            public void stopFireClock() {
                this.firingTime.addAndGet(System.nanoTime() - this.start);
            }

            public void reset() {
                this.matchesFired.set(0L);
                this.matchesCreated.set(0L);
                this.matchesCancelled.set(0L);
                this.firingTime.set(0L);
                this.lastReset.set(new Date());
            }

            public String toString() {
                return "matchesCreated=" + this.matchesCreated.get() + " matchesCancelled=" + this.matchesCancelled.get() + " matchesFired=" + this.matchesFired.get() + " firingTime=" + this.firingTime.get() / 1000000L + "ms";
            }
        }
    }

    public static class ProcessStats
    implements ProcessEventListener {
        private GlobalProcessStatsData consolidated = new GlobalProcessStatsData();
        private ConcurrentHashMap<String, ProcessStatsData> processStats = new ConcurrentHashMap();

        public GlobalProcessStatsData getConsolidatedStats() {
            return this.consolidated;
        }

        public Map<String, ProcessStatsData> getProcessStats() {
            return this.processStats;
        }

        public ProcessStatsData getProcessStats(String processId) {
            return this.processStats.get(processId);
        }

        public void reset() {
            this.consolidated.reset();
            this.processStats.clear();
        }

        private ProcessStatsData getProcessStatsInstance(String processId) {
            return this.processStats.computeIfAbsent(processId, d -> new ProcessStatsData());
        }

        @Override
        public void afterProcessStarted(ProcessStartedEvent event) {
            this.consolidated.processInstancesStarted.incrementAndGet();
            ProcessStatsData data = this.getProcessStatsInstance(event.getProcessInstance().getProcessId());
            data.processInstancesStarted.incrementAndGet();
        }

        @Override
        public void afterProcessCompleted(ProcessCompletedEvent event) {
            this.consolidated.processInstancesCompleted.incrementAndGet();
            ProcessStatsData data = this.getProcessStatsInstance(event.getProcessInstance().getProcessId());
            data.processInstancesCompleted.incrementAndGet();
        }

        @Override
        public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
            ProcessStatsData data = this.getProcessStatsInstance(event.getProcessInstance().getProcessId());
            data.processNodesTriggered.incrementAndGet();
        }

        @Override
        public void afterNodeLeft(ProcessNodeLeftEvent event) {
        }

        @Override
        public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        }

        @Override
        public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        }

        @Override
        public void beforeProcessCompleted(ProcessCompletedEvent event) {
        }

        @Override
        public void beforeProcessStarted(ProcessStartedEvent event) {
        }

        @Override
        public void afterVariableChanged(ProcessVariableChangedEvent event) {
        }

        @Override
        public void beforeVariableChanged(ProcessVariableChangedEvent event) {
        }

        public static class GlobalProcessStatsData
        implements GenericKieSessionMonitoringMXBean.IGlobalProcessStatsData {
            public AtomicLong processInstancesStarted = new AtomicLong(0L);
            public AtomicLong processInstancesCompleted = new AtomicLong(0L);
            public AtomicReference<Date> lastReset = new AtomicReference<Date>(new Date());

            @Override
            public long getProcessInstancesStarted() {
                return this.processInstancesStarted.get();
            }

            @Override
            public long getProcessInstancesCompleted() {
                return this.processInstancesCompleted.get();
            }

            @Override
            public Date getLastReset() {
                return this.lastReset.get();
            }

            public void reset() {
                this.processInstancesStarted.set(0L);
                this.processInstancesCompleted.set(0L);
                this.lastReset.set(new Date());
            }

            public String toString() {
                return "processInstancesStarted=" + this.processInstancesStarted.get() + " processInstancesCompleted=" + this.processInstancesCompleted.get();
            }
        }

        public static class ProcessStatsData
        extends GlobalProcessStatsData
        implements GenericKieSessionMonitoringMXBean.IProcessStatsData {
            public AtomicLong processNodesTriggered = new AtomicLong(0L);

            @Override
            public long getProcessNodesTriggered() {
                return this.processNodesTriggered.get();
            }

            @Override
            public void reset() {
                super.reset();
                this.processNodesTriggered.set(0L);
            }

            @Override
            public String toString() {
                return super.toString() + " processNodesTriggered=" + this.processNodesTriggered.get();
            }
        }
    }
}

