/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;

public class AverageAccumulateFunction
extends AbstractAccumulateFunction<AverageData> {
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public AverageData createContext() {
        return new AverageData();
    }

    @Override
    public void init(AverageData data) {
        data.count = 0;
        data.total = 0.0;
    }

    @Override
    public void accumulate(AverageData data, Object value) {
        if (value != null) {
            ++data.count;
            data.total += ((Number)value).doubleValue();
        }
    }

    @Override
    public void reverse(AverageData data, Object value) {
        if (value != null) {
            --data.count;
            data.total -= ((Number)value).doubleValue();
        }
    }

    @Override
    public Object getResult(AverageData data) {
        return data.count == 0 ? null : Double.valueOf(data.total / (double)data.count);
    }

    @Override
    public boolean supportsReverse() {
        return true;
    }

    @Override
    public Class<?> getResultType() {
        return Double.class;
    }

    public static class AverageData
    implements Externalizable {
        public int count = 0;
        public double total = 0.0;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.count = in.readInt();
            this.total = in.readDouble();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.count);
            out.writeDouble(this.total);
        }
    }
}

